	TITLE	EDASM-80
*********************************************************************
*                     8080 EDITOR/ASSEMBLER                         *
* NORTH-STAR DOS IMPLEMENTATION,      D. F. DUNFIELD,  AUG 30, 1979 *
*********************************************************************
*
PROGRAM	EQU	$2A00		ADDRESS OF PROGRAM IN RAM
DATA	EQU	$4000		ADDRESS OF DATA AREA IN RAM
*
INBUF	EQU	DATA		ADDRESS OF INPUT BUFFER
TBUFF	EQU	DATA+128	BUFFER FOR AUTOMATIC COMMAND
FLAG	EQU	DATA+255	OUTPUT PAUSE FLAG
ADDR	EQU	FLAG-2		ASSEMBLY CODE GENERATION ADDRESS
LODADR	EQU	ADDR-2		ASSEMBLY CODE LOCATION ADDRESS
POINT	EQU	LODADR-2	SAVED EDIT TEXT POINTER
DRIVE	EQU	POINT-1		DEFAULT DISK DRIVE
OUTPUT	EQU	DRIVE-1		DEFAULT OUTPUT DEVICE
OUTFLG	EQU	OUTPUT-1	OUTPUT INHIBIT FLAG
FTYPE	EQU	OUTFLG-1	DEFAULT ACCEPTED FILE TYPE
TEMP	EQU	FTYPE-1		TEMPORARY SPACE
STACK	EQU	TEMP		ADDRESS OF STACK POINTER
OPC	EQU	INBUF+3		GENERATED OPCODE BUFFER
TEXT	EQU	DATA+$100	ADDRESS OF TEXT FILE IN RAM
*
* NORTH-STAR DOS ROUTINES
*
CTRLC	EQU	$2016		DOS CONTROL-C TEST ROUTINE
DOS	EQU	$2028		DOS REENTRY ADDRESS
DOSOUT	EQU	$200D		DOS CHARACTER OUTPUT ROUTINE
DOSIN	EQU	$2010		DOS CHARACTER INPUT ROUTINE
DOSDIR	EQU	$2025		DOS DIRECTORY DISPLAY ROUTINE
DOSDSK	EQU	$2022		DOS DISK READ/WRITE ROUTINE
DOSLOK	EQU	$201C		DOS FILE LOOKUP ROUTINE
*
* COLD START ENTRY POINT, INIT RAM TEXT FILE ETC
*
	ORG	$2A00
COLD	MVI	A,$FF		END OF FILE CHARACTER
	STA	TEXT		CLEAR RAM TEXT FILE
*
* WARM START ENTRY POINT, RAM TEXT FILE IS PRESERVED
*
WARM	CALL	CLSTAB		CLEAR SYMBOL TABLE
	MVI	A,$0D		GET CARRIAGE RETURN (NULL COMMAND)
	STA	TBUFF		INITIALIZE AUTOMATIC COMMAND
	SUB	A		GET A ZERO
	STA	OUTFLG		ALLOW OUTPUT
	STA	OUTPUT		SET DEFAULT OUTPUT DEVICE
	INR	A		GET A ONE
	STA	DRIVE		SET DEFAULT DRIVE
	MVI	A,5		DEFAULT FILETYPE IS FIVE
	STA	FTYPE		SET DEFAULT TYPE
	LXI	H,WMSG		POINT AT WELCOME MESSAGE
	CALL	PRINT		DISPLAY
*
* INITIALIZE LOCAL FLAGS, START EDITOR
*
STRT	SUB	A		GET A ZERO
	STA	FLAG		CLEAR I/O FLAG
	STA	OUTFLG		REALLOW OUTPUT
	LXI	H,TEXT		POINT TEXT POINTER TO TOP OF FILE
	SHLD	LODADR		SET LOAD ADDRESS
	SHLD	POINT		SET TEXT RESTORE POINTER
	JMP	PRNT		PROMPT FOR INPUT
* DISPLAY 'EDIT:' MESSAGE
IDONE	PUSH	H		SAVE TEXT POINTER
	LXI	H,SMSG		STARTING MESSAGE
	CALL	PRINT		DISPLAY
	POP	H		RESTORE H-L
PRNT	LXI	SP,STACK	SET UP EDIT STACK POINTER
	CALL	GET		GET A LINE
	DCX	D		BACKUP PAST RETURN
	CALL	EVAL		EVALUATE DIGIT
	LXI	D,INBUF		POINT TO INPUT BUFFER
	MOV	A,C		GET VALUE OBTAINED
	MOV	B,A		SAVE INITIAL VALUE
	CPI	1		TEST FOR ZERO
	ACI	0		AND CHANGE TO ONE IS SO
	MOV	C,A		RESAVE IN REGISTER
	LDAX	D		GET CHARACTER FROM INPUT BUFFER
	INX	D		SKIP TO FIRST CHARACTER OF OPERAND
	CPI	'Q'		TEST FOR 'QUIT' COMMAND
	JZ	DOS		IF SO, REENTER DOS
	CPI	$0D		IS IT A NULL COMMAND
	JZ	IDONE		IF SO, IGNORE
	CPI	'B'		TEST FOR 'B'EGINNING COMMAND
	JNZ	END1		IF NOT, TRY NET
*
* 'B' COMMAND, MOVE TO TOP OF FILE
*
BEG	LXI	H,TPL		POINT TO TOP MESSAGE
	CALL	PRINT		DISPLAY LINE
	LXI	H,TEXT		MOVE TO TOP
	CALL	LPRT		DISPLAY FIRST LINE
	JMP	PRNT		GET NEXT COMMAND
*
* 'E' COMMAND, MOVE TO END OF FILE
*
END1	CPI	'E'		IS IT 'E'
	JNZ	TYPE		NO, TRY 'T'
	CALL	GEOF		FIND END OF FILE
*
* DISPLAY CURRENT LINE OF TEXT
*
INPT	MOV	A,M		GET FIRST CHARACTER OF LINE
	ANA	A		IS IT END OF FILE
	JP	NOEOF		IF NOT, SKIP MESSAGE
	PUSH	H		SAVE TEXT POINTER
	LXI	H,ENL		GET END OF FILE MESSAGE
	CALL	PRINT		DISPLAY
	POP	H		RESTORE TEXT POINTER
NOEOF	CALL	LPRT		DISPLAY LINE WE ARE ON
	JMP	PRNT		GET NEXT COMMAND
*
* SUBROUTINE TO ADVANCE TO END OF FILE
GEOF	SUB	A		GET A ZERO
E1	ORA	M		TEST FOR END OF FILE
	RM			IF SO, RETURN
	INX	H		NEXT MEMORY LOCATION
	JMP	E1		KEEP LOOKING
*
* TYPE COMMAND, DISPLAY TEXT
*
TYPE	CPI	'T'		IS IT 'T'YPE?
	JNZ	NXT		NO, TRY NEXT
LP	DCR	C		REDUCE COUNT
	JZ	INPT		IF LAST ONE, DISPLAY AND QUIT
	CALL	LPRT		DISPLAY ONE LINE
	CALL	ADV		ADVANCE TO NEXT
	JM	INPT		IF END OF FILE, QUIT
	JMP	LP		KEEP GOING
* MESSAGES
TPL	STR	'TOF:'		INDICATE TOP OF FILE
	DB	$0D
ENL	STR	'EOF:'		ENDICATE END OF FILE
	DB	$0D
WMSG	DB	7		WELCOME MESSAGE
SMSG	STR	'EDIT:'		INDICATE WE ARE READY
	DB	$0D
EMSG	STR	'EDIT: '	EROR MESSAGE
	DB	$FF		STOP PRINTING WITHOUT CARRIAGE RETURN
IMSG	STR	'INPUT:'	INDICATE IN INPUT MODE
	DB	$0D
FMSG	STR	'FILE'		INDICATE FILE ERROR
	DB	$0D
OVFL	STR	'SIZE'		FILE SIZE ERROR
	DB	$0D
ADERR	STR	'ADDR'		ASSEMBLY ADDRESS IS INVALID
	DB	$0D
*
* NEXT COMMAND
*
NXT	CPI	'N'		IS IT NEXT
	JNZ	UP		NO, TRY NEXT CONE
NLP	CALL	ADV		ADVANCE A LINE
	JM	INPT		IF END, STOP
	DCR	C		REDUCE COUNT
	JNZ	NLP		KEEP GOING TILL DONE
	JMP	INPT		DISPLAY
*
* SUBROUTINE TO ADVANCE LINES
*
ADV	MOV	A,M		GET CONTENTS OF MEMORY
	ANA	A		TEST FOR END OF FILE
	RM			IF SO, QUIT
	INX	H		ADVANCE TO NEXT
	CPI	$0D		TEST FOR END OF LINE
	JNZ	ADV		NO, KEEP LOOKING
	MOV	A,M		GET CONTENTS OF NEW LINE
	ANA	A		TEST FOR END OF FILE
	RET
*
* PRINT MEMORY(HL) UP TO <CR>, HL PRESERVED
*
LPRT	PUSH	H		SAVE HL
RECV	CALL	PRINT		DISPLAY LINE
	POP	H		RESTORE HL
	RET
*
* UP COMMAND
*
UP	CPI	'U'		IS IT UP
	JNZ	LOC		NO, TRY NEXT
	DCX	H		BACK UP PAST LINE
LP2	MOV	A,H		GET HIGH ADDRESS
	CPI	=TEXT		BEYOND START OF FILE
	JC	BEG		IF SO, GO TO BEGINNING
	DCX	H		BACK UP AGAIN
	MOV	A,M		GET CHARACTER FROM LINE
	CPI	$0D		NEW LINE
	JNZ	LP2		NO, KEEP GOING
	DCR	C		ARE WE FINISHED
	JNZ	LP2		NO, KEEP GOING
	INX	H		ADVANCE
	JMP	INPT		DISPLAY NEW LINE
*
* SUBROUTINE TO EVALUATE A SIXTEEN BIT NUMBER FROM COMMAND LINE RESULT IN (BC)
*
EVAL	PUSH	H		SAVE H-L
	LXI	B,1		START WITH MULTIPLIER OF ONE
	LXI	H,0		AND A RESULT OF ZERO
ETOP	LDAX	D		GET CHARACTER FROM LINE
	CALL	NUM		IS IT A VALID NUMBER
	JC	EDON		NO, FORGET IT
	ANI	$0F		CONVERT TO DIGIT
* MULTIPLY DIGIT BY MULTIPLIER
ZLOOP	DCR	A		REDUCE DIGIT
	JM	ESP1		IF END, STOP
	DAD	B		ADD IN MULTIPLIER
	JMP	ZLOOP		AND CONTINUE
* MULTIPLY MULTIPLIER BY 10
ESP1	PUSH	H		SAVE PARTIAL RESULT
	MOV	H,B		GET MULTIPLIER...
	MOV	L,C		OLD VALUE
	DAD	B		TIMES 2
	DAD	H		TIMES 4
	DAD	B		TIMES 5
	DAD	H		TIME 10
	MOV	B,H		REPLACE OLD
	MOV	C,L		MULTIPLIER VALUE
	POP	H		RESTORE PARTIAL RESULT
	DCX	D		BACKUP IN SOURCE
	JMP	ETOP		KEEP GOING
EDON	MOV	B,H		MOVE RESULT INTO THE
	MOV	C,L		BC REGISTER PAIR
	POP	H		AND RESTORE THE TEXT POINTER
	RET
*
* SUBROUTINE TESTS FOR VALID ASCII NUMERIC DIGITS, CY=1 IF INVALID
*
NUM	CPI	'0'		IS IT < '0'
	RC			IF SO, IT'S BAD
	CPI	$3A		IS IT GREATER THAN '9'
	CMC			SET FLAG IF SO
	RET
*
* SUBROUTINE GETS A LINE FROM THE TERMINAL
*
GET	SUB	A		GET A ZERO
	MOV	B,A		SET UP ZERO INDENT
	STA	FLAG		AND CLEAR THE OUTPUT FLAG
GETC	MVI	A,'.'		GET PROMPT
	CALL	OUT		DISPLAY
	LXI	D,INBUF		POINT AT INPUT BUFFER
GZZ	DCR	B		REDUCE SPACEING COUNT
	JM	ILZ		IF END, THATS ALL
	CALL	SPACE		SPACE OVER
	STAX	D		SAVE IN INPUT BUFER
	INX	D		ADVANCE IN BUFFER
	JMP	GZZ		TRY AGAIN
ILZ	MOV	A,E		GET LOW ADDRESS
	ANA	A		OVERSTEPPED OUR BOUNDS?
	JM	NIN		IF SO, RESTART
	CALL	IN		GET A CHARACTER
	CPI	$0A		IS IT LINEFEED?
	JZ	ILZ		IGNORE
	CPI	$1B		IS IT ESCAPE?
	JNZ	GZSKP		NO, NORMAL COMMAND
* EXECUTE AUTOMATIC COMMAND
	LXI	B,TBUFF		POINT AT COMAND BUFFER
ESC1	LDAX	B		GET CHARACTER FROM COMMAND BUFFER
	STAX	D		SAVE IN INPUT BUFFER
	CPI	$0D		TEST FOR END OF LINE
	JZ	LFCR		IF SO, END IT
	CALL	OUT		ECHO ON TERMINAL
	INX	B		ADVANCE IN COMMAND BUFFER
	INX	D		ADVANCE IN COMMAND BUFFER
	JMP	ESC1		KEEP COPYINE COMMANDS OVER
GZSKP	CPI	3		IS IT CONTROL-C
	JZ	NIN		IF SO, RESTART INPUT
	CPI	$5F		TEST FOR DELETE CHARACTER
	JNZ	GOK		NOT, THEN IT'S OK
	MVI	A,8		CONVERT TO BACKSPACE
GOK	CALL	OUT		DISPLAY
	DCX	D		ASUME DELETE
	CPI	8		IS IT DELETE
	JZ	ILZ		YES, WE GUESSED RIGHT
	INX	D		NO, WE GOOFED, FIX MISTAKE
	STAX	D		SAVE IN INPUT BUFFER
	CPI	$0D		TEST FOR END OF LINE
	JZ	LFCR		IF SO, END IT
	INX	D		ADVANCE TO NEXT
	JMP	ILZ		KEEP GOING
* CONTROL-C ENTERED, RESTART INPUT
NIN	CALL	LFCR		NEW LINE
	JMP	GET		BACK FOR ANOTHER LINE
*
* LOCATE COMMAD
*
LOC	CPI	'/'		IS IT LOCATE
	JNZ	DEL		NO, TRY DELETE
	CALL	ADV		START LOOKING ON NEXT LINE
LINT	LXI	D,INBUF+1	POINT TO SECOND POSITION IN INPUT BUFFER
LLOK	MOV	A,M		GET CHARACTER FROM MEMORY
	ANA	A		TEST FOR END OF FILE
	JM	INPT		IF SO, INDICATE SO
	LDAX	D		GET CHARACTER FROM INPUT BUFFER
LL2	CMP	M		SAME AS TEXT FILE HERE ?
	INX	H		ADVANCE TO NEXT
	JNZ	LINT		NO, TRY AGAIN
	INX	D		YES, ADVANCE IN BUFFER
	LDAX	D		GET NEXT CHARACTER FROM BUFFER
	CPI	$0D		IS IT END OF LINE
	JNZ	LL2		NO, KEEP TESTING
	MVI	C,1		BACKUP ONE LINE
	JMP	LP2		BACKUP TO START OF LINE
*
* INPUT ROUTINE, GETS CHARACTER FROM CONSOLE
*
IN	SUB	A		ALWAYS READ CONSOLE
	JMP	DOSIN		CALL DOS TO GET CHARACTER
*
* DISPLAYS A SPACE ON THE TERMINAL
*
SPACE	MVI	A,' '		GET A SPACE
*
* OUTPUT ROUTINE, DISPLAYS ON SELECTED DEVICE
*
OUT	PUSH	B		SAVE REGISTERS
	MOV	B,A		COPY TO OUTPUT
	LDA	OUTFLG		GET OUTPUT FLAG
	RRC			IS OUTPUT OFF
	LDA	OUTPUT		GET DEFAULT OUTPUT DEVICE
	CNC	DOSOUT		DISPLAY
	MOV	A,B		GET ORIGINAL DATA BACK
	POP	B		RESTORE REGISTERS
	RET
*
* DELETE COMMAND
*
DEL	CPI	'D'		IS IT DELETE
	JNZ	INS		NO, TRY INSERT
	LDAX	D		GET NEXT CHARACTER FROM COMMAND
	CPI	'E'		IS IT 'E'?
	JNZ	ERR		NO, DON'T DELETE
DEL10	CALL	DELL		DELETE A LINE
	MOV	A,M		GET CHARACTER FROM LINE
	ANA	A		TEST FOR END OF FILE
	JM	INPT		IF SO, INDICATE SO
	JMP	PRNT		GET NEXT COMMAND
*
* SUBROUTINE DELETES SPECIFIED NUMBER OF LINES (IN C)
*
DELL	PUSH	H		SAVE POINTER
DL99	CALL	ADV		ADVANCE TO NEXT
	DCR	C		REDUCE COUNT
	JNZ	DL99		KEEP GOING TILL WE HAVE THAT MANY
	POP	D		GET STARTING POSITION BACK
	PUSH	D		RESAVE STARTING POSITION
DELP	MOV	A,M		GET CHARACTER FROM MEMORY.	
	STAX	D		SAVE IN MEMORY
	INX	H		NEXT IN SOURCE
	INX	D		NEXT IN DESTINATION
	ANA	A		TEST FOR END OF FILE
	JP	DELP		KEEP GOING TILL ALL TEXT MOVED
	POP	H		RESTORE TEXT POINTER
	RET
*
* INPUT COMMAND
*
INS	CPI	'I'		TEST FOR INPUT
	JNZ	CHG		NO, TRY CHANGE
	MOV	A,B		GET OPERAND
	STA	TEMP		SET INPUT TAB LENGTH
INPY	PUSH	H		SAVE HL
	LXI	H,IMSG		POINT TO MESSAGE
	CALL	PRINT		DISPLAY MESSAGE
	POP	H		RESTORE H-L
IL10	LDA	TEMP		GET INPUT TAB
	MOV	B,A		COPY TO B REGISTER
	CALL	GETC		GET A LINE
	LDA	INBUF		GET CHARACTER FROM BUFFER
	CPI	$0D		IS IT CARRIAGE RETURN
	JZ	IDONE		IF SO, END OF INPUT
	CALL	INLN		INSERT THIS LINE
	JMP	IL10		KEEP GOING
*
* SUBROUTINE TO INSERT A LINE, E CONTAINS LENGTH OF LINE
*
INLN	MOV	B,H		COPY TEXT POINTER.
	MOV	C,L		TO BC REGISTER PAIR FOR LATER
	CALL	GEOF		FIND END OF FILE
	INX	H		ADVANCE BECAUSE WE DECREMENT
	PUSH	H		SAVE ADDRESS
	MVI	D,0		ZERO HIGH BYTE OF LENGTH
	DAD	D		ADD IN LINE LENGTH
	POP	D		DE=ADDRESS OF END OF TEXT
	INX	H		ADVANCE BECAUSE WE DEC
IL01	DCX	H		BACKUP ONE CHARACTER IN SOURCE
	DCX	D		BACKUP ONE CHARACTER IN DEST
	LDAX	D		GET CHARACTER FROM SOURCE
	MOV	M,A		SAVE IN DEST
	MOV	A,E		GET LOW ADRESS
	CMP	C		TEST AGAINST START ADDRESS
	JNZ	IL01		NOT SAME, FORGET IT
	MOV	A,D		GET HIGH ADDRESS
	CMP	B		TEST AGAINST STARTING POSITION
	JNZ	IL01		KEEP MOVING TILL WE ARE BACK TO INSERT POINT
	LXI	B,INBUF		POINT TO INPUT BUFFER
IL02	LDAX	B		GET CHARACTER FROM INPUT BUFFER
	STAX	D		SAVE IN TEXT FILE
	INX	B		ADVANCE TO NEXT IN INPUT BUFFER
	INX	D		ADVANCE TO NEXT IN TEXT FILE
	CPI	$0D		TEST FOR END OF FILE
	JNZ	IL02		NO, KEEP MOVING
	RET
*
* CHANGE COMMAND
*
CHG	CPI	'C'		IS IT CHANGE
	JNZ	DUP		NO, TRY DUPLICATE LINE
	MOV	A,M		GET CHARACTER FROM INE
	ANA	A		TEST FOR END OF FILE
	JM	INPT		IF SO, IGNORE
	MVI	A,'='		GET CHANGE PROMPT
	CALL	OUT		DISPLAY ON TERMNAL
	CALL	LPRT		OUTPUT LINE
	CALL	GETC		GET INPUT (ALLOWING SPACE OVER)
	LXI	D,INBUF		POINT TO INPUT BUFFER
	PUSH	H		SAVE TEXT POINTER
COOP	LDAX	D		GET CHARCTER FROM INPUT BUFFER
	CPI	$0D		END OF LINE?
	JZ	CEND		IF SO, DELETE/INSERT LINE AND QUIT
	CPI	' '		TEST FOR BLANK
	JNZ	CDLE		NO, START DELETING
* BLANK, COPY CHARACTER FROM OLD LINE
	MOV	A,M		GET CHARACTER FROM TEXT
	STAX	D		SAVE IN BUFFER
	CPI	$0D		END OF LINE?
	JZ	CEND		IF SO, HANDLE END CASE
	INX	H		NEXT IN SOURCE
	INX	D		NEXT IN DESTINATION
	JMP	COOP		MOVE NEXT CHARACTER
* NON-BLANK, DELETE UP TO NEXT DIFFERENT CHARCTER
CDLE	MOV	B,D		COPY BUFFER POSITION INTO
	MOV	C,E		D-E FOR LATER REFERENCE
	PUSH	D		SAVE REGISTER POINTER
	MOV	D,A		SAVE CHARACTER WE ARE LOOKING FOR
CDLP	MOV	A,M		GET CHARACTER FROM SOURCE
	CPI	$0D		TEST FOR END OF LINE
	JZ	CDSKP		IF SO, DON'T SKIP
	INX	H		ADVANCE TO NEXT
CDSKP	INX	B		ADVANCE TO NEXT CHARACTER IN BUFFER
	LDAX	B		GET CHARACTER FROM BUFFER
ZAP	CMP	D		SAME AS PREVIOUS ONE?
	JZ	CDLP		IF SO, KEEP DELETING
	POP	D		RESTORE REGISTERS
* INSERT REMAINDER OF LINE
CINS	LDAX	B		GET CHARACTER FROM BUFFER
	CPI	$0D		TEST FOR END OF LINE
	JZ	CEND		IF SO, END IT NOW
	STAX	D		SAVE IN BUFFER
	INX	D		ADVANCE BUFFER DATA POSITION
	INX	B		ADVANCE BUFFER CONTROL POSITION
	JMP	CINS		KEEP INSERTING
*END, COPY REMAINDER OF OLD LINE, REPLACE LINE ETC
CEND	MOV	A,M		GET CHARACTER FROM OLD LINE
	STAX	D		SAVE IN NEW LINE
	INX	H		ADVANCE IN OLD
	INX	D		ADVANCE IN NEW
	CPI	$0D		TEST FOR END OF LINE
	JNZ	CEND		IF NOT, KEEP COPYING
	DCX	D		BACKUP IN LINE
	POP	H		RESTORE TEXT POSITION
	PUSH	D		SAVE BUFER POSITION
	MVI	C,1		DELETE ONE LINE
	CALL	DELL		PERFORM DELETE
	POP	D		RESTORE POSITION
	PUSH	H		SAVE POINTER AGAIN
	CALL	INLN		INSERT LINE
	POP	H		RESTORE POINTER
	JMP	INPT		NEXT COMMAND
*
* DUPLICATE LINE COMMAND
*
DUP	CPI	'+'		TEST FOR DUPLICATE
	JNZ	QUERY		NO, TRY NEXT COMMAND
DU1	PUSH	H		SAVE POINTER
	PUSH	B		SAVE COUNTER
	LXI	D,INBUF		POINT TO INPUT BUFFER
DU2	MOV	A,M		GET CHARACTER FROM LINE
	STAX	D		SAVE IN BUFFER
	INX	D		ADVANCE IN BUFFER
	INX	H		ADVANCE IN LINE
	CPI	$0D		TEST FOR END OF LINE
	JNZ	DU2		COPY ENTIRE LINE
	DCX	D		DECREMENT LINE LENGTH
	CALL	INLN		INSERT LINE
	POP	B		RESTORE COUNTER
	POP	H		RESTORE TEXT POSITION
	DCR	C		REDUCE COUNT
	JNZ	DU1		DO AS MANY AS REQUESTED
	JMP	PRNT		NEW COMMAND
*
* QUERY MEMORY USAGE COMMAND
*
QUERY	CPI	'?'		IS IT QUERY?
	JNZ	DIR		NO, TRY DIRECTORY
	PUSH	H		SAVE TEXT POSITION
	CALL	GEOF		ADVANCE TO END OF FILE
	INX	H		ADVANCE TO INCLUDE
	MOV	B,H		COPY HIGH BYTE
	MOV	C,L		COPY LOW BYTE
	CALL	BCHEX		DISPLAY ADDRESS
	CALL	SPACE		SEPERATOR
	LXI	B,0-TEXT	COMPLEMENT OF TEXT ADDRESS
	DAD	B		CALCULATE LENGTH
	MOV	B,H		COPY HIGH BYTE
	MOV	C,L		COPY LOW BYTE
	CALL	BCHEX		DISPLAY
	CALL	LFCR		NEW LINE
RETSH	POP	H		RESTORE TEXT POSITION
	JMP	PRNT		GET COMMAND
* DISPLAY'S B-C IN HEX
BCHEX	MOV	A,B		GET HIGH BYTE
	CALL	HPR		DISPLAY IN HEX
	MOV	A,C		GET LOW BYTE
* DISPLAY'S ACC IN HEX
HPR	PUSH	PSW		SAVE VALUE
	RRC			SHIFT
	RRC			TOP
	RRC			NIBBLE INTO
	RRC			LOW NIBBLE
	CALL	HOUT		DISPLAY IN HEX
	POP	PSW		RESTORE LOWER NIBBLE
HOUT	ANI	$0F		REMOVE UPPER GARBAGE
	ADI	$30		CONVERT TO ASCII NUMBER
	CPI	$3A		TEST FOR 0-9
	JC	OUT		IF SO, IT'S OK
	ADI	7		CONVERT TO CHARACTER A-F
	JMP	OUT		DISPLAY
*
* DIRECTORY COMMAND
*
DIR	CPI	'*'		IS IT DIRECTORY COMMAND?
	JNZ	LOAD		NO, TRY NEXT COMMAND
	LDA	OUTPUT		GET OUTPUT DEVICE
	MOV	L,A		SAVE OUTPUT DEVICE
	MOV	A,B		GET DRIVE NUMBER
	ANA	A		DID HE SPECIFY DRIVE?
	JNZ	DIROU		YES, USE IT
	LDA	DRIVE		GET DEFAULT DRIVE
DIROU	CALL	DOSDIR		DISPLAY DIRECTORY
	JMP	STRT		NEXT COMMAND
*
* LOAD COMMAND
*
LOAD	CPI	'L'		IS LT LOAD
	JNZ	SAVE		NO, TRY NEXT
GFI1	CALL	DLOOK		LOOK UP IN DIRECTORY
	LHLD	LODADR		GET ADDRESS TO LOAD (NORMALLY TEXT)
	XCHG			SWAP FOR DOS CALL
	MVI	B,1		INDICATE READ
	CALL	DOSDSK		PERFORM DISK READ
	JC	FERR		IF ERROR THEN INDICATE SO
	JMP	STRT		NEXT COMMAND
*
* DIRECTORY LOOKUP SUBROUTINE
*
DLOOK	XCHG			POINT AT INPUT BUFER
	MOV	A,M		GET CHARACTER FOLLOWING COMMAND
	CPI	'F'		IT IT 'F'
	JZ	DZ2		IF SO, IT'S OK
	LXI	H,TEXT		SKIP TO START OF TEXT
*
* ERROR HANDLING ROUTINE
*
ERR	PUSH	H		SAVE TEXT POINTER
	PUSH	PSW		SAVE CHARACTER
	LXI	H,EMSG		POINT AT MESSAGE
	CALL	ERRMSG		DISPLAY MESSAGE
	POP	PSW		RESTORE CHARACTER
	CALL	OUT		DISPLAY
	JMP	XLCR		LFCR, POPH , RETURN
* OK TO PROCEDE WITH FILE LOOKUP
DZ2	INX	H		ADVANCE TO NEXT
	MOV	A,M		GET CHARACTER FROM MEMORY
	CPI	' '		TEST FOR BLANK
	JZ	DZ2		IF SO, IGNORE
GOT	CPI	$0D		IS IT CR
	JZ	FERR		IF SO, ERROR
	LDA	DRIVE		GET DISK DRIVE NUMBER
	CALL	DOSLOK		LOOKUP IN DIRECTORY
	JC	FERR		IF NOT THERE, INDICATE INVALID
	MOV	C,A		SAVE DRIVE NUMBER
	PUSH	H		SAVE BUFFER POSITION
	INX	H		ADVANCE
	INX	H		FOUR SPACES
	INX	H		TO GET TO FILE
	INX	H		TYPE
	LDA	FTYPE		GET DEFAULT FILE TYPE
	CMP	M		RETREIVE FILE TYPE
	JNZ	FERR		IF NOT SAME, EROR
	POP	H		RESTORE BUFFER POINTER
	MOV	E,M		GET LOW ADDRESS
	INX	H		ADVANCE TO NEXT
	MOV	D,M		GET HIGH ADDRESS
	INX	H		ADVANCE TO NEXT
	MOV	A,M		GET LENGTH BYTE
	RET
* FILE ERROR, FILE NOT FOUND OR OF WRONG TYPE
FERR	LXI	H,FMSG		POINT TO MESSAGE
PERR9	CALL	ERRMSG		DISPLAY
	JMP	STRT		NEXT COMMAND
*
* SAVE COMMAND
*
SAVE	CPI	'S'		IS IT SAVE?
	JNZ	GFILE		IF NOT, TRY NEXT COMMAND
	CALL	DLOOK		LOOK UP IN DIRECTORY
	MOV	B,A		SAVE LENGTH
	LXI	H,TEXT		POINT TO TEXT FILE ADDRESS
	CALL	GEOF		FIND END OF FILE
	MOV	A,H		GET HIGH ADDRESS
	SUI	=TEXT		CONVERT TO NUMBER OF SECTORS
	CMP	B		TEST AGAINST FILE SIZE
	JNC	FOVFL		INDICATE SIZE ERROR IS OVER
	INR	A		ADVANCE TO GET NUMBER OF SECTORS TO SAVE
	LXI	H,TEXT		POINT TO FILE ADDRESS
	MVI	B,0		INDICATE WRITE
	XCHG			SWAP FOR DOS CALL
	CALL	DOSDSK		PERFORM WRITE TO DISK
	JC	FERR		IF ERROR, INDICATE SO
	JMP	STRT		NEXT COMMAND
* FILE IS TO BIG TO SAVE IN SPECIFIED FILE
FOVFL	LXI	H,OVFL		POINT AT MESSAGE
	JMP	PERR9		DISPLAY MESSAGE AND EXIT
*
* GET AND APPEND FILE COMMAND
*
GFILE	CPI	'G'		IS IT GETFILE?
	JNZ	AUTO		NO, TRY NEXT COMMAND
	CALL	GEOF		FIND END OF FILE
	SHLD	LODADR		SAVE IN LOAD ADDRESS
	JMP	GFI1		PRETEND IT'S LOAD
*
* SET AUTOMATIC COMMAND
*
AUTO	CPI	'$'		IS IT A SET AUTO COMMAND?
	JNZ	PFORM		NO, TRY NEXT COMMAND
	LXI	B,TBUFF		POINT TO COMMAND BUFFER
LPZ1	LDAX	D		GET CHARACTER FROM INPUT
	STAX	B		SAVE IN COMMAND
	INX	D		ADVANCE IN INPUT
	INX	B		ADVANCE IN COMMAND
	CPI	$0D		TEST FOR END OF LINE
	JNZ	LPZ1		NO, MORE COMMAND TO COPY
	JMP	PRNT		NEXT COMMAND
*
* FORMATTED PRINT COMMAND
*
PFORM	CPI	'P'		IS IT PRINT COMMAND?
	JNZ	SAVRES		NO, TRY NEXT COMMAND
PFLP	DCR	C		REDUCE COUNTER
	JZ	PEND		IF END THEN LAST LINE TO PRINT
	MOV	A,M		GET CONTENTS OF LINE
	ANA	A		TEST FOR END OF FILE
	JM	INPT		IF SO, INDICATE SO
	CALL	FPRNT		DISPLAY LINE
	JMP	PFLP		TRY NEXT
* LAST LINE TO DISPLAY
PEND	MOV	A,M		GET CHARACTER FROM LINE
	ANA	A		TEST FOR END OF FILE
	JM	INPT		IF SO, INDICATE SO
	PUSH	H		SAVE TEXT POINTER
	CALL	FPRNT		DISPLAY FORMATED
	POP	H		RESTORE POINTER
	JMP	PRNT		NEXT COMMAND
*
* SAVE/RESTORE POSITION COMMAND
*
SAVRES	CPI	':'		TEST FOR SAVE/RESTORE COMMAND
	JNZ	SETDV		NO, TRY NEXT COMMAND
	LDAX	D		GET NEXT CHARACTER
	CPI	'S'		IS IT SAVE
	JNZ	TSTR		NO, TRY RESTORE
	SHLD	POINT		SAVE POINTER
	JMP	PRNT		NEXT COMMAND
TSTR	CPI	'R'		IS IT RESTORE
	JNZ	ERR		NO, INDICATE ERROR
	LHLD	POINT		RESTORE POINTER
	JMP	LP2		INSURE WE ARE AT START OF LINE
*
* SET COMMAND
*
SETDV	CPI	'#'		IS IT SET?
	JNZ	XEVAL		NO, TRY NEXT
	LDAX	D		GET OPERAND
	CPI	'O'		SET OUTPUT?
	JNZ	CTYPE		NO, TRY TYPE
	MOV	A,B		GET OPERAND
	STA	OUTPUT		SET OUTPUT DEVICE
	JMP	PRNT		NEXT COMMAND
CTYPE	CPI	'T'		SET TYPE?
	JNZ	CDRIV		NO, TRY DRIVE
	MOV	A,B		GET OPERAND
	STA	FTYPE		SET DEFAULT FILE TYPE
	JMP	PRNT		NEXT COMMAND
CDRIV	CPI	'D'		SET DRIVE?
	JNZ	ERR		NO, ERROR
	MOV	A,C		GET OPERAND (1 MINIMUM)
	STA	DRIVE		SET DRIVE
	JMP	PRNT		NEXT COMMAND
*
* EVALUATE AND DISPLAY EXPRESSION
*
XEVAL	CPI	'X'		EVALUATE EXPRESSION?
	JNZ	ASM		NO, TRY NEXT
	PUSH	H		SAVE HL
	XCHG			POINT TO OPERANDS
	CALL	NCHR		SKIP TO OPERANDS
	CALL	PDXPR		EVALUATE EXPRESSION
	CALL	BCHEX		DISPLAY BC PAIR
XLCR	CALL	LFCR		NEW LINE
	JMP	RETSH		NEW COMMAND
* CALCULATES A HEXIDECIMAL OPERAND
CALH	LDAX	D		GET CHARACTER FROM LINE
	CPI	' '		TEST FOR SPACE
	JNZ	CALZ		IF NOT, START CALCULATEING
	INX	D		ADVANCE TO NEXT
	JMP	CALH		TRY AGAIN
CALZ	LXI	H,0		SART WITH ZERO
	MOV	C,H		SET FLAG
CAL1	LDAX	D		GET CHARACTER FROM SOURCE
	CALL	NUM		TEST FOR VALID
	JNC	COK		IT'S BAD
	CPI	'A'		TEST FOR <A
	JC	BAD		IT'S BAD
	CPI	'G'		TEST FOR <G
	JNC	BAD		IT'S BAD
COK	SUI	$30		CONVERT TO ASCII
	CPI	$0A		TEST FOR OVER LIMIT
	JC	COK1		IT'S OK
	SUI	7		CONVERT TO ASCII
COK1	DAD	H		ROTATE
	DAD	H		NIBBLE
	DAD	H		INTO
	DAD	H		NEXT HIGHER
	MOV	B,A		GET NEW VALUE
	MOV	A,L		GET OLD LOW BYTE
	ORA	B		ADD IN NEW VALUE
	MOV	L,A		RESAVE IN RESULT
	INX	D		ADVANCE TO NEXT CHARACTER
	MVI	C,7		SET FLAG
	JMP	CAL1		TRY AGAIN
BAD	CALL	TVALT		TEST FOR VALID TERMINATOR
	JNZ	BADC		IF NOT, INVALID
	MOV	A,C		GET FLAG
	ANA	A		TEST FOR CHARACTERS RECEIVED
	RNZ			IF SO, WE ARE OK
	STC			INDICATE INVALID
	RET
* CHARACTER WAS BAD, INDICATE SO
BADC	MVI	A,$FF		SET FLAG, INDICATEING INVALID CHARACTER
	STC			INDICATE NO VALUE RECEIVED
	RET
* ABORT BACK TO MONITOR
ABRT	LXI	H,ADERR		POINT TO MESSAGE
	JMP	PERR9		DISPLAY AND EXIT
*
* ASSEMBLE COMMAND
*
ASM	CPI	'A'		IS IT ASSEMBLE?
	JNZ	ERR		NO, ERROR
	LDAX	D		GET OPERAND VALUE
	CPI	'D'		DISPLAY LAST SYMBOL TABLE?
	JZ	STPRT		YES, DO IT
	INX	D		ADVANCE TO SKIP OPERANDS
ASMLP	CALL	CALH		CALCULATE ADDRESS
	JC	ABRT		IF INVALID, ABORT
	PUSH	H		SAVE ADDRESS
	SHLD	LODADR		SET CODE LOAD ADDRESS
	CALL	CALH		TEST FOR ANOTHER OPERAND
	JC	CAXX		IF NOT, KEEP SAME LOAD ADDRESS
	SHLD	LODADR		CHANGE LOAD ADDRESS
CAXX	POP	H		RESTORE ADDRESS
	INR	A		TEST FOR INVALID SECOND OPERAND
	JZ	ABRT		IF SO, ABORT
*
* ASSEMBLER SECTION
*
ASMGO	MVI	A,$80		DISALLOW ERROR MESSAGES
	STA	OUTFLG		SET UP OUTPUT FLAG
	SHLD	ADDR		SAVE ASSEMBLE ADDRESS
* CLEAR SYMBOL TABLE
	PUSH	H		SAVE ASSEMBLE ADDRESS ON STACK
	CALL	CLSTAB		CLEAR SYMBOL TABLE
	POP	B		RESTORE ADDRESS INTO B-C
*
* FIRST PASS, BUILD SYMBOL TABLE
*
PASS1	LXI	H,TEXT		START AT BEGINNING OF FILE
	LXI	D,SYM1		POINT DE AT SYMBOL TABLE
* PROCESS A LINE
LINE1	MOV	A,M		GET CHARACTER FROM START OF LINE
	CPI	'*'		IS IT A COMMENT
	JZ	SKIP1		IF SO, IGNORE
	CPI	' '		IS IT SPACE
	JZ	AINS		IF SO, THERE MUST BE AN INSTRUCTION
	ANA	A		TEST FOR END OF FILE
	JM	PASS2		IF SO, BEGIN SECOND PASS
	PUSH	D		SAVE SYMBOL TABLE POINTER
	LXI	D,SYM1		POINT AT SYMBOL TABLE
	CALL	TABSER		LOOK UP SYMBOL
	JNC	SYMDUP		IF IT IS FOUND, THE IT'S DUPLICATED
	POP	D		RESTORE SYMBOL TABLE POSITION
* SYMBOL IS OK, INSERT INTO SYMBOL TABLE
DUPOK	MOV	A,M		GET CHARACTER FROM SYMBOL
	STAX	D		SAVE IN TABLE
ASAVE	INX	H		ADVANCE IN SOURCE
	INX	D		ADVANCE IN TABLE
	MOV	A,D		GET HIGH ADDRESS OF TABLE POSITION
	CPI	=INBUF		TEST FOR OVERFLOW
	JNZ	SNFUL		IF NOT, CONTINUE
	LXI	H,TABERR	ERROR MESSAGE
	CALL	ERRMSG		DISPLAY ON TERMINAL
	JMP	STRT		REENTER EDITOR
* SYMBOL WAS A DUPLICATE, ISSUE ERROR MESSAGE, BUT CONTINUE
SYMDUP	LXI	D,DUPERR	POINT TO ERROR MESSGE
SYML1	LDAX	D		GET CHARACTER FROM MESSAGE
	INX	D		ADVANCE TO NEXT
	CALL	OUT		DISPLAY
	CPI	7		TEST FOR BELL, END OF MESSAGE
	JNZ	SYML1		NO, KEEP GOING
* DISPLAY SYMBOL NAME
SYML2	MOV	A,M		GET CHARACTER FROM SYMBOL
	CPI	' '		TEST FOR END
	JZ	SYML3		IF SO, THATS IT
	INX	H		ADVANCE TO NEXT
	CPI	13		TEST FOR CARRIAGE RETURN (END OF LINE)
	JZ	SYML3		IF SO, THATS IT
	CALL	OUT		DISPLAY CHARACTER
	JMP	SYML2		KEEP GOING
SYML3	CALL	LFCR		NEW LINE
	POP	D		RESTORE SYMBOL TABLE POSITION
	JMP	LINE1		PROCESS LINE WITHOUT SYMBOL
* SYMBOL WAS OK, INSERT INTO SYMBOL TABLE
SNFUL	MOV	A,M		GET CHARACTER FROM SYMBOL
	STAX	D		SAVE IN TABLE
	CPI	' '		TEST FOR BLANK, END OF SYMBOL
	JNZ	ASAVE		IF NOT, KEEP GOING
	DCX	D		BACKUP TO LAST CHARACTER
	LDAX	D		GET LAST CHARACTER FROM SYMBOL
	ORI	$80		SET HIGH BIT
	STAX	D		RESAVE CHARACTER
	INX	D		ADVANCE TO NEXT
	MOV	A,B		GET HIGH ADDRESS
	STAX	D		SAVE IN TABLE
	INX	D		ADVANCE TO NEXT
	MOV	A,C		GET LOW ADDRESS
	STAX	D		SAVE IN TABLE
	INX	D		ADVANCE TO NEXT
* LOOKUP INSTRUCTION, AND CALCULATE IT'S LENGTH
AINS	CALL	NCHR		ADVANCE TO INSTRUCTION
	CALL	IFIND		LOCATE
	CPI	$C0		IS IT 'END'
	JZ	PASS2		IF SO, START PASS2
	CPI	$D0		IS IT 'STR'
	JNZ	ILSKP		NO, TRY EQUATE
	CALL	NEXTC		SKIP TO OPERAND
	CALL	CLEN		CALCULATE LENGTH
	JMP	NOTEQ+2		ADJUST ADDRESS
ILSKP	CPI	$80		IS IT EQUATE
	JNZ	NOTEQ		NO, INSTRUCTION
	CALL	NEXTC		ADVANCE TO OPERAND
	PUSH	B		SAVE ADDRESS
	SUB	A		GET A ZERO
	STA	OUTFLG		BY ENABLING OUTPUT ROUTINE
	CALL	PDXPR		PROCESS EXPRESSION
	PUSH	D		SAVE POINTER TO SYMBOL TABLE
	DCX	D		BACKUP
	MOV	A,C		SAVE LOW BYTE
	STAX	D		IN SYMBOL TABLE
	DCX	D		BACKUP
	MOV	A,B		SAVE HIGH BYTE
	STAX	D		IN SYMBOL TABLE
	POP	D		RESTORE SYMBOL TABLE POINTER
	POP	B		RESTORE ADDRESS
	MVI	A,$80		GET 'RET' INSTRUCTION
	STA	OUTFLG		DISABLE ERROR MESSAGES
	JMP	SKIP1		PROCESS NEXT
NOTEQ	ANI	$0F		REMOVE TYPE INFORMATION, LEAVING LENGTH
	ADD	C		ADD TO ADDRESS
	MOV	C,A		RESAVE IN REGISTER
	JNC	SKIP1		IF NO OVERFLOW, ADDRESS IS CORRECT
	INR	B		FIX BY INCING HIGH BYTE
* SCAN FOR END OF LINE
SKIP1	MVI	A,$0D		GET CARRIAGE RETURN
SKIP2	CMP	M		TEST AGAINST MEMORY
	INX	H		ADVANCE TO NEXT
	JNZ	SKIP2		IF NOT THERE, KEEP GOING
	JMP	LINE1		PROCESS NEXXT LINE
*
* SUBROUTINE TO CLEAR THE SYMBOL TABLE
*
CLSTAB	LXI	H,SYM1		POINT TO TOP OF SYMBOL TABLE
	MVI	A,=INBUF	CLEAR TO PAGE WITH BUFFER/STACK AND FLAGS
ILOOP	MVI	M,$FF		CLEAR TO $FF
	INX	H		ADVANCE TO NEXT
	CMP	H		TEST FOR AT PAGE
	JNZ	ILOOP		IF NOT, KEEP CLEARING
	RET
*
*  ASSEMBLER ERROR MESSAGES
*
AEMSG	LDA	OUTFLG		GET OUTPUT INHIBIT FLAG
	ANI	$80		TEST FOR ERROR MESSAGES OFF
	RNZ			IF SO, FORGET IT
	STA	OUTFLG		ENABLE OUTPUT
*
* DISPLAYS ERROR MESSAGE
*
ERRMSG	MVI	A,7		GET BELL
	CALL	OUT		DISPLAY
	MVI	A,'?'		PRECEDE WITH QUESTION MARK
	CALL	OUT		DISPLAY
*
* DISPLAYS TEXT (HL) UP TO A CARRIAGE RETURN
*
PRINT	MOV	A,M		GET CHARACTER FROM LINE
	INX	H		ADVANCE TO NEXT
	ANA	A		TEST FOR END OF FILE/UNPRINTABLE
	RM			IF SO, QUIT
	CALL	OUT		DISPLAY MESSAGE
	CPI	$0D		TEST FOR END OFLINE
	JNZ	PRINT		IF NOT, KEEP GOING
*
* SUBROUTINE TO DISPLAY LINE-FEED CARRIAGE RETURN ON TERM
*
LFCR	MVI	A,$0A		GET LINE-FEED
	CALL	OUT		DISPLAY ON TERMINAL
	MVI	A,$0D		GET CARRIAGE-RETURN
	CALL	OUT		DISPLAY ON TERMINAL
	LDA	FLAG		GET STOPPED FLAG
	ANA	A		ARE WE STOPPED
	JNZ	WAIT		IF SO, WAIT FOR START
	CALL	CTRLC		TEST FOR CHARACTER
	JZ	STRT		IF SO, ABORT
	CPI	$0A		TEST FOR LINEFEED
	RNZ			NO, SKIP IT
WAIT	STA	FLAG		SET FLAG, INDICATING STOPPED
WAITL	CALL	IN		GET CHARACTER
	CPI	$0A		LINE FEED?
	RZ			IF SO, ALLOW ONE MORE LINE
	CPI	3		CONTROL-C?
	JZ	STRT		IF SO, ABORT AND START FRESH
	CPI	$0D		IS IT CARRIAGE RETURN?
	JNZ	WAITL		NO, TRY AGAIN
	SUB	A		GET A ZERO
	STA	FLAG		CLEAR THE FLAG
	RET
*
* SKIPS OVER CURRENT WORD, STOPPING AT BEGINNING OF NEXT
*
NEXTC	MOV	A,M		GET CHARACTER FROM MEMORY
	CPI	' '		IS IT A BLANK
	INX	H		ADVANCE TO NEXT
	JNZ	NEXTC		NOIT'S NOT, TRY AGAIN
*
* ADVANCES TO THE NEXT NON-BLANK CHARACTER (HL)
*
NCHR	MOV	A,M		GET CHARACTER
	CPI	' '		TEST FOR SPACE
	RNZ			IF NOT, RETURN
	INX	H		ADVANCE TO NEXT
	JMP	NCHR		TRY AGAIN
*
* LOOKS UP INSTRUCTION (HL) IN THE INSTRUCTION TABLE
*
IFIND	PUSH	D		SAVE DE REGISTERS
	LXI	D,TABLE		POINT TO INSTRUCTION TABLE
	CALL	TABSER		SERACH IN TABLE
	JC	NOINS		NOT FOUND
	LDAX	D		GET OPCODE FROM TABLE
	STA	OPC		SAVE OPCODE FOR LATER REFERENCE
	INX	D		ADVANCE TO DESCRIPTOR
	LDAX	D		GET DESCRIPTOR
	POP	D		RESTORE D-E
	RET
* INSTRUCTION WAS NOT FOUND
NOINS	PUSH	H		SAVE H-L
	LXI	H,INSERR	POINT TO MESSAGE
WRMSG	CALL	AEMSG		DISPLAY ERROR MESSAGE
	POP	H		RESTORE H-L
	SUB	A		SET TYPE/LENGTH TO ZERO
	POP	D		RESTORE D-E
	RET
*
* SEARCHES TABLE POINTED TO BY D-E FOR WORD POINTED TO BY H-L
* ON EXIT, C=0 IS WORD WAS FOUND, D-E POINTS TO ADDRESS FIELD
* FOLLOWING WORD IN TABLE
*
TABSER	LDAX	D		GET CHARACTER FROM TABLE
	INR	A		END OF TABLE?
	STC			SET CARRY, INDICATE FAILURE
	RZ			IF SO, THIS ISN'T IT
* COMPARE THE TWO STRING VALUES UP TO A HIGH BIT SET IN TABLE ENTRY
	PUSH	H		SAVE H-L
CLOOK	LDAX	D		GET CHARACTER FROM TABLE
	ANA	A		TEST FOR HIGH BIT SET
	JM	CFND		THIS COULD BE IT
	CMP	M		SAME AS OTHER STRING?
	INX	H		ADVANCE IN ONE STRING
	INX	D		ADVANCE IN THE OTHER STRING
	JZ	CLOOK		IF SAME, KEEP LOOKING
RTRN	POP	H		RESTORE H-L
* LOOK FOR NEXT WORD IN TABLE
WLOOK	LDAX	D		GET CHARACTER FROM TABLE
	INX	D		ADVANCE TO NEXT
	ANA	A		IS IT END OF WORD
	JP	WLOOK		IF NOT, KEEP LOOKING
	INX	D		SKIP HIGH ADDRESS BYTE
	INX	D		SKIP LOW ADDRESS BYTE
	JMP	TABSER		CHECK THIS ONE
* STRINGS MATCHED UP TO LAST CHARACTER
CFND	ANI	$7F		REMOVE HIGH BIT
	CMP	M		SAME AS DESTINATION?
	JNZ	RTRN		NO, NOT SAME
	INX	H		ADVANCE TO NEXT
	MOV	A,M		GET CHARACTER FROM OTHER STRING
	CALL	TVALT		TEST FOR VALID TERMINATOR
	JNZ	RTRN		IF NOT, GET UPSET
	INX	D		ADVANCE IN THE OTHER STRING
	POP	H		RESTORE H-L
	RET
*
* TEST FOR VALID SYMBOL TERMINATOR
*
TVALT	CPI	' '		SPACE
	RZ
	CPI	$0D		CR
	RZ
	CPI	'+'		PLUS
	RZ
	CPI	'-'		MINUS
	RZ
	CPI	'&'		AND
	RZ
	CPI	'!'		OR
	RET
*
* PROCESS A DOUBLE BYTE EXPRESSION
*
PDXPR	MOV	A,M		GET CHARACTER FROM EXPRESSION
	CPI	'='		TEST FOR HIGH BYTE
	JNZ	GOPROC		IF NOT, CONTINUE
	INX	H		SKIP EQUALS SIGN
	CALL	PDXPR		RECURSE TO GET DEFINITION
	MOV	A,B		SWAP
	MOV	B,C		THE HIGH AND
	MOV	C,A		LOW NIBBLES
	RET
GOPROC	PUSH	D		SAVE D-E
	CPI	$27		IS IT A QUOTE
	JNZ	PHEXC		NO, TRY HEX
	LXI	B,0		SET RESULT TO ZERO
GEQUO	INX	H		ADVANCE TO NEXT
	MOV	A,M		GET CHARACTER
	CPI	$27		TEST FOR CLOSEING QUOTE
	JZ	TQUI		IF SO, GIVE UP
	MOV	B,C		SHIFT NEW
	MOV	C,A		CHARACTER IN
	CPI	$0D		TEST FOR END OF LINE
	JNZ	GEQUO		IF NOT, IT'S OK
	POP	D		GET D-E BACK
	PUSH	B		STACK REGISTERS...
	PUSH	D		FOR CLERR
	JMP	CLERR		IMDICATE ERROR
PHEXC	CPI	'$'		TEST FOR HEX CONSTANT
	JNZ	PSTAR		NO, TRY STAR
	PUSH	B		SAVE B-C
	XCHG			SWAP TEXT POINTER TO D-E
	INX	D		SKIP '$'
	CALL	CALZ		GET VALUE
	POP	B		RESTORE B-C
	XCHG			SWAP POINTERS BACK
	JC	CVERR		IF ERROR, THEN HANDLE
	MOV	B,D		COPY RESULT INTO.
	MOV	C,E		B-C FOR USE LATER
	JMP	PDLP		KEEP GOING
PSTAR	CPI	'*'		IS IT A '*'
	JNZ	PDECI		NO, TRY DECIMAL
TQUI	INX	H		ADVANCE TO NEXT CHARACTER
	JMP	PDLP		CONTINUE PROCESSING
PDECI	CALL	NUM		IS IT A VALID DIGIT
	JNC	PNUM		IF SO, DECIMAL NUMBER
	LXI	D,SYM1		POINT TO SYMBOL TABLE
	CALL	TABSER		LOOK FOR SYMBOL
	JC	LNOTF		NOT FOUND, ERROR
PX1	INX	H		ADVANCE
	CMP	M		ARE WE THERE,
	JNZ	PX1		KEEP LOOKING
	LDAX	D		GET HIGH BYTE
	MOV	B,A		SAVE IN B
	INX	D		ADVANCE TO NEXT
	LDAX	D		GET LOW BYTE
	MOV	C,A		SAVE IN C
	JMP	PDLP		KEEP GOING
* DECIMAL NUMBER
PNUM	INX	H		ADVANCE
	MOV	A,M		GET CHARACTER FROM RAM
	CALL	NUM		IS IT VALID
	JNC	PNUM		IF SO, KEEP LOOKING
	CALL	TVALT		TEST FOR VALID TERMINATOR
	JNZ	CVERR		IF NOT, BAD DATA
	PUSH	H		SAVE H-L
	DCX	H		BACKUP
	XCHG			SWAP
	CALL	EVAL		EVALUATE NUMBER
	POP	H		RESTORE TEXT POINTER
PDLP	POP	D		RESTORE D-E
	MOV	A,M		GET OPERATOR
	CPI	' '		BLANK?
	RZ			IF SO, RETURN
	CPI	$0D		CARIRAGE RETURN?
	RZ			IF SO, RETURN
	PUSH	B		SAVE OLD VALUE
	PUSH	PSW		SAVE OPERATOR
	INX	H		SKIP OPERATOR
	CALL	PDXPR		PROCESS EXPRESSION
	POP	PSW		RESTORE OPERATOR
	XTHL			SAVE H-L, GET OLD OPERATOR
	CPI	'-'		MINUS?
	JNZ	PLUS		NO, TRY ADD
	MOV	A,B		TAKE TWO'S
	CMA			COMPLEMENT
	MOV	B,A		OF THE NEW
	MOV	A,C		VALUE
	CMA			SO WE CAN
	MOV	C,A		SUBTRACT FROM OLD
	INX	B		TO GET RESULT
	MVI	A,'+'		PERFORM ADDITION
PLUS	CPI	'+'		ADD?
	JNZ	LAND		LOGICAL ANDPERHAPS
	DAD	B		GET NEW RESULT
	JMP	LEXT		EXIT
LAND	CPI	'&'		LOGICAL AND
	JNZ	LOR		NO, TRY LOGICAL AND
	MOV	A,H		GET OLD NEW VALUE
	ANA	B		OR WITH OLD
	MOV	B,A		REPLACE
	MOV	A,L		GET LOW BYTE
	ANA	C		OR WITH OLD
	MOV	C,A		REPLACE
	POP	H		RESTORE REGISTER
	RET
LOR	MOV	A,H		GET OLD VALUE
	ORA	B		AND WITH OTHER VALUE
	MOV	H,A		REPLACE
	MOV	A,L		GET LOW VALUE
	ORA	C		AND WITH OTHER
	MOV	L,A		RELPACE
LEXT	MOV	B,H		COPY TO B-C
	MOV	C,L		PAIR FOR RETULT
	POP	H		RESTORE H-L
	RET
* SYMBOL WAS NOT FOUND
LNOTF	PUSH	H
	LXI	H,SYMERR	POINT AT MESSAGE
	JMP	WRMSG		DISPLAY MESSAGE
* CHARACTER ERROR
CVERR	PUSH	H		SAVE REGISTER
	LXI	H,VALERR	POINT TO ERROR MESSAGE
	JMP	WRMSG		DISPLAY
*
* ERROR MESSAGE STRINGS
*
SYMERR	STR	'SYM'
	DB	$0D
TABERR	STR	'FUL'
	DB	$0D
REGERR	STR	'REG'
	DB	$0D
VALERR	STR	'VAL'
	DB	$0D
INSERR	STR	'INS'
	DB	$0D
STRERR	STR	'STR'
	DB	$0D
DUPERR	STR	'?DUP: '
	DB	7
*
* LOOK UP A SINGLE REGISTER OPERAND
*
REGLK	PUSH	D		SAVE D REGISTER
	LXI	D,RTAB-2	POINT TO REGISTER TABLE (-2 BECAUSE WE ADD 2)
RLOOK	INX	D		ADVANCE TO NEXT
	INX	D		ADVANCE TO NEXT
	LDAX	D		GET CHARACTER FROM TABLE
	CPI	$E5		AT END?
	JZ	RNOT		IF SO, INVALID REGISTER
	CMP	M		WHAT WE WANT?
	JNZ	RLOOK		IF NOT, KEEP LOOKING
	INX	D		ADVANCE TO NEXT
	LDAX	D		GET REGISTER BIT MASK
	POP	D		RESTORE D
	RET
* REGISTER BIT MASK TABLE
RTAB	DB	'A'
	DB	$3F
	DB	'B'
	DB	0
	DB	'C'
	DB	$09
	DB	'D'
	DB	$12
	DB	'E'
	DB	$1B
	DB	'H'
	DB	$24
	DB	'L'
	DB	$2D
	DB	'M'
	DB	$36
* REQUESTED REGISTER IS NOT FOUND
RNOT	PUSH	H		SAVE H-L
	LXI	H,REGERR	POINT TO MESSAGE
	JMP	WRMSG		WRITE MESSAGE
*
* LOOK UP A REGISTER PAIR OPERAND
*
RPLOK	PUSH	D		SAVE DE PAIR
	MOV	E,A		COPY MASK TO E
	MOV	A,M		GET REGISTER WE DESIRE
	CALL	RPCHK		CKECK IT
	MOV	A,D		GET MASK BITS
	ORA	E		ADD IN VALUE SPECIFIED
	POP	D		RESTORE D-E
	RET
RPCHK	MVI	D,0		ASSUME MASK OF ZERO
	CPI	'B'		IS IT THE BC PAIR
	RZ			YES, RETURN WITH THE GOODS
	MVI	D,$10		ASSUME MASK OF $10
	CPI	'D'		IS IT THE DE PAIR
	RZ			YES, RETURN
	MVI	D,$20		ASSUME MASK OF $20
	CPI	'H'		IS IT THE HL PAIR
	RZ			YES, RETURN WITH THE GOODS
	MVI	D,$30		ASSUME MASK OF $30
	CPI	'P'		IS IT THE PROGRAM COUNTER
	RZ			IF SO, RETURN
	PUSH	D		SAVE D FOR ERROR ROUTINE
	CPI	'S'		IS IT THE STACK POINTER
	JNZ	RNOT		INDICATE INVALID
	POP	D		RESTORE D
	INX	H		ADVANCE TO NEXT
	MOV	A,M		GET NEXT CHARACTER
	CPI	'P'		'SP'?
	RZ			IF SO, RETURN
	DCX	H		BACKUP
	RET
*
* SECOND PASS, GENERATE LISTING AND CODE
*
PASS2	LHLD	ADDR		GET CODE ADDRESS
	MOV	B,H		COPY INTO...
	MOV	C,L		THE B-C PAIR
	LDA	INBUF+1		GET EXTRA OPERAND
	CPI	'S'		GENERATE SYMBOL TABLE ONLY?
	JZ	STPRT		IF SO, WE HAVE IT, DISPLAY IT
PASK0	LXI	H,TEXT		POINT AT START OF TEXT
	SUB	A		GET A ZERO
	STA	OUTFLG		ENABLE OUTPUT
	CALL	LFCR		DISPLAY A LINEFEED TO INDICATE STARTING PASS2
LINE	LDA	INBUF+1		GET DEFAULT OUTPUT CHARACTER
	SUI	'E'		ERROR OUTPUT ONLY?
	JNZ	NOAE		NO, DON'T ALTER OUTPUT
	INR	A		GET A ONE
	STA	OUTFLG		SET OUTPUT INHIBIT FLAG
NOAE	PUSH	H		SAVE START OF LINE ADDRESS
	MOV	A,M		GET CHARACTER FROM LINE
	ANA	A		END OF FILE ENCOUNTERED?
	JM	STPRT		IF SO, DISPLAY IT
	CPI	'*'		IS IT COMMENT
	MVI	A,$10		IF COMMENT, ASSUME ZERO LENGTH INSTRUCTION
	JZ	PAS2C		AND PROCESS NORMALLY
	CALL	NEXTC		SKIP TO INSTRUCTION
	CALL	IFIND		LOOK UP INSTRUCTION
* WE HAVE INSTRUCTION AND OPCODE, PROCESS
PAS2C	PUSH	PSW		SAVE TYPE/LENGTH BYTE
	PUSH	B		SAVE CODE ADDRESS
	RRC			MOVE TYPE BYTE...
	RRC			INTO THE LOW NIBBLE.
	RRC			SO THAT WE...
	RRC			CAN TEST IT
	ANI	$0F		REMOVE LENGTH BYTE,
	MOV	E,A		SAVE IN REGISTER
	LDA	OPC		GET OPCODE
	MOV	D,A		PLACE IN D ALSO
	DCR	E		TEST FOR TYPE 1 INSTRUCTION
	JNZ	T2		NO, TRY TYPE 2
*
* TYPE ONE INSTRUCTION, SINGLE BYTE, NO OPERANDS. EG 'NOP'
* THIS CODE IS ALSO EXECUTED BY THE OTHER TYPES, AND PRODUCES
* THE FORMATTED LISTING
*
T1	POP	B		RESTORE CODE ADDRESS
	CALL	BCHEX		DISPLAY ADRESS
	CALL	SPACE		SPACE BETWEEN ADDRESS AND DATA
* DISPLAY CODE
	POP	PSW		GET TYPE/LENGTH BYTE BACK
	ANI	$0F		REMOVE TYPE DATA
PTLZ1	MVI	D,3		DISPLAY THREE BYTES MAX
	MOV	E,A		SAVE LENGTH FOR LATER
	LXI	H,OPC		POINT TO OPCODE DATA AREA
PTOP2	DCR	E		REDUCE COUNT
	JM	PTOP0		IF FINISHED, SKIP CODE OUTPUT
	MOV	A,M		GET DATA BYTE
	PUSH	H		SAVE POINTER
	LHLD	LODADR		GET LOAD ADDRESS
	MOV	M,A		SAVE IN MEMORY
	INX	H		ADVANCE TO NEXT
	SHLD	LODADR		RESAVE LOAD ADDRESS
	POP	H		RESTORE OPCODE POINTER
	CALL	HPR		DISPLAY IN HEX
	CALL	SPACE		DISPLAY A SPACE
	INX	B		ADVANCE TO NEXT ADDRESS IN LISTING
	INX	H		ADVANCE TO NEXT OPCODE BYTE
	DCR	D		REDUCE COUNT
	JNZ	PTOP2		IF MORE SPACE, KEEP DISPLAYING
	MOV	A,E		GET LENGTH
	ANA	A		ARE WE DONE?
	JZ	PTOP0		IF SO, FINISH REST OF LISTING
* COPY REMAINDER OF OPCODE(S) INTO MEMORY
PTLP1	MOV	A,M		GET BYTE FROM OPCODE
	PUSH	H		SABE OPCODE POINTER
	LHLD	LODADR		GET LOAD ADDRESS
	MOV	M,A		SAVE IN CODE MEMORY
	INX	H		ADVANCE TO NEXT CODE LOCATION
	SHLD	LODADR		RESAVE CODE POINTER
	POP	H		RESTORE OPCODE POINTER
	INX	B		ADVANCE ADDRES COUNTER
	INX	H		ADVANCE OPCODE POINTER
	DCR	E		REDUCE LENGTH BYTE
	JNZ	PTLP1		IF MORE, THEN KEEP LOOPING
	MVI	A,'+'		INDICATE EXTRA CODE IN LISTING
	CALL	OUT		DISPLAY INDICATOR
	JMP	PTPSK		SKIP SPACE BECAUSE WE USED '+'
* DISPLAY FORMATTED SOURCE LISTNG
PTOP0	CALL	SPACE		SEPERATE CODE FROM SOURCE WITH SPACE
* SPACE OVER TO START OF SOURCE LISTING
PTPSK	INR	D		ADVANCE NUMBER OF FILLER SPACES REQUIRED
PTOP1	MOV	A,D		GET NUMBER OF REMAINING SPACES NEEDED
	ADD	D		X2 AND THEN...
	ADD	D		X3 FOR TWO CHARACTERS AND A SPACE
	MOV	D,A		RESAVE NUMBER OF REQUIRED SPACES
PSPLP	CALL	SPACE		DISPLAY A SPACE
	DCR	D		REDUCE COUNT OF REQUIRED SPACES
	JNZ	PSPLP		IF MORE NEEDED, DISPLAY THEM
	POP	H		RESTORE	SOURCE POSITION
	CALL	FPRNT		DISPLAY FORMATTED SOURCE LISTING
	JMP	LINE		HANDLE NEXT LINE
*
* FORMATTED LINE PRINT ROUTINE, USED BY ASSEMBLER LISTING GENERATOR, AND
* THE EDITOR 'P' COMMAND
*
FPRNT	MOV	A,M		GET FIRST CHARACTER OF LINE
	CPI	'*'		IS IT A COMMENT
	JZ	PRINT		IF SO, DISPLAY IT AS IT IS
	MVI	D,6		LABLE FIELD IS 6 CHARACTERS
	CALL	POUTF		DISPLAY FORMATTED
	MVI	D,4		INSTRUCTION FIELD IS 4 CHARACTERS
	CALL	POUTF		DISPLAY IN FORMATTED FORM
	MVI	D,10		OPERAND FIELD IS 10 CHARACTERS
	CALL	POUTF		DISPLAY FORMATTED
	JMP	PRINT		DISPLAY COMMENT AS IS
* DISPLAY WORD POINTED TO BY H-L IN FIELD WIDTH PASSED IN D
POUTF	MOV	A,M		GET CHARACTER FROM MEMORY
	CPI	$0D		TEST FOR END OF LINE
	RZ			IF SO, QUIT
	INX	H		ADVANCE TO NEXT
	CPI	' '		TEST FOR BLANK
	JZ	EOTF		IF SO, PAD WITH PROPER BLANKS AND QUIT
	CALL	OUT		DISPLAY
	DCR	D		REDUCE COUNT
	CPI	$27		IS IT A QUOTE (SPECIAL CASE)
	JNZ	POUTF		IF NOT, KEEP GOING
* QUOTE WAS ENCOUNTERED, DON'T TERMINATE IS SPACES INSIDE
QFOR	MOV	A,M		GET CHARACTER
	CPI	$0D		END OF LINE
	RZ			IF SO, QUIT
	INX	H		ADVANCE TO NEXT
	CALL	OUT		DISPLAY
	DCR	D		REDUCE COUNT
	CPI	$27		CLOSEING QUOTE?
	JNZ	QFOR		IF NOT, KEEP GOING
	JMP	POUTF		BACK TO NORMAL MODE
* END OF FIELD
EOTF	CALL	SPACE		ADD A SPACE TO THE FIELD
	DCR	D		REDUCE COUNT OF REMAINING CHARACTERS
	JP	EOTF		KEEP GOING TILL WE FINISH
	RET
*
* SUBROUTINE CALCULATES THE LENGTH OF A CHARACTER STRING, PLACEING
* IT'S CODE IN THE 'OPC' OPCODE BUFFER. STRING IS POINTED TO BY H-L
*
CLEN	PUSH	B		SAVE B-C
	PUSH	D		SAVE D-E
	LXI	D,OPC		POINT AT OPCODE SPACE
	MOV	B,M		GET FIRST DELEIMITER FROM STRING
	MVI	C,0		SET LENGTH TO ZERO
CTLP	INX	H		ADVANCE TO NEXT CHARACTER IN STRING
	MOV	A,M		GET CHARACTER FROM STRING
	CMP	B		IF IT A DELIMITER
	JZ	CLOK		OF SO, WE ARE FINISHED
	INR	C		ADVANCE LENGTH
	STAX	D		SAVE IN OPCODE SPACE
	INX	D		ADVANCE TO NEXT OPCODE BYTE
	CPI	$0D		TEST FO END OF LINE
	JNZ	CTLP		IF NOT, KEEP GOING
* NO CLOSEING STRING DELIMITER WAS FOUND
CLERR	MVI	C,0		SET LENGTH TO ZERO
	PUSH	H		SAVE TEXT POINTER
	LXI	H,STRERR	POINT TO MESSAGE
	CALL	AEMSG		DISPLAY ERROR
	POP	H		RESTORE TEXT POINTER
CLOK	MOV	A,C		GET LENGTH IN ACC
	POP	D		RESTORE D-E
	POP	B		RESTORE B-C
	RET
*
* TYPE TWO INSTRUCTION, SINGLE BYTE OF IMMEDIATE DATA, EG: 'CPI $XX'
*
T2	PUSH	PSW		SAVE INSTRUCTION TYPE BYTE
	CALL	NEXTC		ADVANCE TO OPERAND
	POP	PSW		RESTORE TYPE BYTE
	DCR	E		IS IT A TYPE TWO
	JNZ	T3		NO, TRY TYPE 3
	CALL	PDXPR		PROCESS EXPRESSION
	MOV	A,C		GET LOW ORDER BYTE
SO1	STA	OPC+1		SET OPCODE
	JMP	T1		FINISH HANDLEING INSTRUCTION
*
* TYPE THREE INSTRUCTION, SINGLE DESTINATION REGISTER OPERAND, EG: 'INR A'
*
T3	DCR	E		TEST FOR TYPE 3
	JNZ	T4		NO, TRY TYPE 4
	CALL	REGLK		LOOK UP REGISTER
	ANI	$38		MASK OUT SOURCE REGISTER
TOD	ORA	D		ADD TO OPCODE
SO0	STA	OPC		SAVE NEWOPCODE
	JMP	T1		FINISH PROCESSING INSTRUCTION
*
* TYPE FOUR INSTRUCTION, REGISTER PAIR OPERAND. EG: 'INX H'
*
T4	DCR	E		TEST FOR TYPE 4
	JNZ	T5		NO, TRY TYPE 5
	CALL	RPLOK		FIND REGISTER PAIR
	JMP	SO0		FINISH PROCESSING INSTRUCTION
*
* TYPE FIVE INSTRUCTION, TWO REGISER OPERANDS, EG: 'MOV A,B'
*
T5	DCR	E		IS IT TYPE 5
	JNZ	T6		NO, TRY TYPE 6
	CALL	REGLK		FIND FIRST REGISTER
	ANI	$38		MASK OFF DSOURCE REGISTER
	ORA	D		ADD INTO OPCODE
	MOV	D,A		RESAVE OPCODE
	INX	H		ADVANCE PAST REGISTER NAME
	INX	H		ADVANCE PAST ','
DRGSAV	CALL	REGLK		GET SECOND REGISTER
	ANI	$07		MASK OUT DESTINATION REGISTER
	JMP	TOD		REPLACE OPCODE AND CONTINUE
*
* TYPE SIX INSTRUCTION, DESTINATION REGISTER, IMMEDIATE DATA, EG: 'MVI A,$XX'
*
T6	DCR	E		IS IT TYPE 6?
	JNZ	T7		NO, TRY TYPE 7
	CALL	REGLK		CALCULATE REGISTER
	ANI	$38		MASK OUT SOURCE REGISTER
	ORA	D		ADD IN OPCODE
	STA	OPC		REPLACE OPCODE
	INX	H		SKIP REGISTER NAME
	INX	H		SKIP ','
	CALL	PDXPR		EVALUATE EXPRESSION
	MOV	A,C		GET LOW BYTE
	JMP	SO1		FINISH PROCESSING
*
* TYPE SEVEN INSTRUCTION, REGISTER PAIR, IMMEDIATE DATA, EG: ' LXIH,$XXXX'
*
T7	DCR	E		IS IT TYPE SEVEN?
	JNZ	T8		NO, TRY TYPE 8
	CALL	RPLOK		GET REGISTER PAIR
	STA	OPC		RESAVE IN OPCODE
	INX	H		ADVANCE PAST REGISTER
	INX	H		ADVANCE PAST ','
TPD	CALL	PDXPR		EVALUATE EXPRESSION
	MOV	L,C		GET LOW BYTE
	MOV	H,B		GET HIGH BYTE
SH1	SHLD	OPC+1		SET OPCODE OPERANDS
	JMP	T1		FINISH PROCESSING
*
* TYPE EIGHT INSTRUCTION, DOUBLE BYTE IMMEDIATE DATA, EG: 'JMP $XXXX'
*
T8	DCR	E		IS IT TYPE 8?
	JZ	TPD		IF SO, HANDLE IT
*
* TYPE NINE INSTRUCTION, SINGLE DESTINATION REGISTER
*
T9	DCR	E		IS IT TYPE 9?
	JZ	DRGSAV		IF SO, HANDLE IT
*
* TYPE TEN INSTRUCTION, 'DB' ASSEMBLER DIRECTIVE
*
TA	DCR	E		IS IT TYPE 10
	JNZ	TB		NO, TRY TYPE 11
	CALL	PDXPR		EVALUATE EXPRESSION
	MOV	A,C		GET LOW BYTE
	JMP	SO0		SAVE AND FINISH PROCESSING
*
* TYPE ELEVEN INSTRUCTION, 'DW' ASSEMBLER DIRECTIVE
*
TB	DCR	E		IS IT TYPE ELEVEN
	JNZ	TC		NO, TRY TYPE 12
	CALL	PDXPR		EVALUATE EXPRESSION
	MOV	H,B		GET HIGH BYTE
	MOV	L,C		GET LOW BYTE
	SHLD	OPC		SAVE IN OPCODE SPACE
	JMP	T1		FINISH PROCESSING
*
* TYPE TWELVE INSTRUCTION, 'END' ASSEMBLER DIRECTIVE
*
TC	DCR	E
	JZ	STPRT
*
* TYPE THIRTEEN INSTRUCTION, 'STR' ASSEMBLER DIRECTIVE
*
TD	DCR	E		IS IT TYPE THIRTEEN
	JNZ	T1		NO, TRY NEXT
	CALL	CLEN		GET STRING LENGTH AND OPCODES
* DO OUR OWN INTRO, SO WE CAN AVOID GETTING LENGTH TRUNCATED TO $0F
	POP	B		RESTORE REGISTERS
	POP	D		RESTORE REGISTERS
	PUSH	PSW		SAVE LENGTH
	CALL	BCHEX		DISPLAY ADDRESS
	CALL	SPACE		ADD LINE BETWEEN ADDRESS AND DATA
	POP	PSW		RESTORE LENGTH
	JMP	PTLZ1		CONTINUE HANDLEING
*
* ASSEMBLY IS COMPLETE, DISPLAY SYMBOL TALE
*
STPRT	CALL	LFCR		START ON A NEW LINE
	LXI	H,STMSG		POINT AT MESSAGE
	CALL	PRINT		DSPLAY
	LXI	H,SYM1		POINT TO SYMBOL TABLE
	MVI	E,0		AND START AT BEGINNING OF LINE
STTOP	MOV	A,E		GET SYMBOL COUNT
	ANI	3		TEST FOR NEAR END OF LINE
	JNZ	STSKP		IF NOT,NO NEW LINE
	CALL	LFCR		NEW LINE
STSKP	MVI	B,8		8 CHARACTERS/SYMBOL
STLOP	MOV	A,M		GET CHARACTER FROM SYMBOL
	INR	A		TEST FOR END OF TABLE
	JZ	STEXT		IF SO, QUIT
STDSP	MOV	A,M		GET DATA FROM MEMORY
	DCR	B		REDUCE COUNT
	INX	H		ADVANCE TO NEXT
	ANA	A		IS IT LAST CHARACTER
	JP	SYDSP		IF SO, PAD AREA
	ANI	$7F		REOVE HIGH BIT
	CALL	OUT		DISPLAY
	JMP	STFND		KEEP DISPLAYING
SYDSP	CALL	OUT		DISPLAY
	JNZ	STDSP		IF MORE SPACE, KEEP LOOKING
	INR	B		OFFSET TO ONE SPACE
	CALL	NEXTC		SKIP TO END
* PAD WITH BLANKS
STFND	CALL	SPACE		DISPLAY SPACE
	DCR	B		REDUCE COUNT
	JNZ	STFND		KEEP DISPLAYING
	MOV	A,M		GET HIGH ADDRES
	CALL	HPR		DISPLAY
	INX	H		ADVANCE TO NEXT
	MOV	A,M		GET LOW ADDRESS
	CALL	HPR		DISPLAY
	INX	H		ADVANCE TO NEXT
	MVI	B,7		DISPLAY 7 SPACES
STLZ1	CALL	SPACE		DISPLAY ONE SPACE
	DCR	B		REDUCE COUNT
	JNZ	STLZ1		KEEP DISPLAYING
	INR	E		ADVANCE NUMBER OF SYMBOLS ON THIS LINE
	JMP	STTOP		KEEP DISPLAYING
* EXIT AND RETURN TO EDITOR
STEXT	CALL	LFCR		DISPLAY A NEW LINE
	JMP	STRT		RETURN TO EDITOR
STMSG	STR	'SYMBOL TABLE:'
	DB	$0D
*
* INSTRUCTION TABLE, FORMAT IS:
*
* INSTRUCTION, STORED IN ASCII, HIGH BIT SET IN LAST CHARACTER
* NEXT BYTE CONTAINS INSTRUCTION TYPE IN HIGH NIBBLE (1-13),
* AND INSTRUCTION LENGTH (IN BYTES) IN LOW NIBBLE
* LAST BYTE IS INSTRUCTION OPCODE (ANY REGISTER BITS SET TO ZERO)
* TABLE ENDS WITH A BYTE OF $FF
*
TABLE	STR	'MO'		MOV
	DB	'V'+$80
	DW	$5140
	STR	'MV'		MVI
	DB	'I'+$80
	DW	$6206
	STR	'LX'		LXI
	DB	'I'+$80
	DW	$7301
	STR	'IN'
	DB	'R'+$80		INR
	DW	$3104
	STR	'IN'
	DB	'X'+$80		INX
	DW	$4103
	STR	'DC'
	DB	'R'+$80		DCR
	DW	$3105
	STR	'DC'		DCX
	DB	'X'+$80
	DW	$410B
	STR	'JM'		JMP
	DB	'P'+$80
	DW	$83C3
	STR	'JN'		JNZ
	DB	'Z'+$80
	DW	$83C2
	STR	'J'		JZ
	DB	'Z'+$80
	DW	$83CA
	STR	'J'		JC
	DB	'C'+$80
	DW	$83DA
	STR	'JN'		JNC
	DB	'C'+$80
	DW	$83D2
	STR	'J'		JM
	DB	'M'+$80
	DW	$83FA
	STR	'J'		JP
	DB	'P'+$80
	DW	$83F2
	STR	'JP'		JPE
	DB	'E'+$80
	DW	$83EA
	STR	'JP'		JPO
	DB	'O'+$80
	DW	$83E2
	STR	'CAL'		CALL
	DB	'L'+$80
	DW	$83CD
	STR	'CN'		CNZ
	DB	'Z'+$80
	DW	$83C4
	STR	'C'		CZ
	DB	'Z'+$80
	DW	$83CC
	STR	'C'		CC
	DB	'C'+$80
	DW	$83DC
	STR	'CN'		CNC
	DB	'C'+$80
	DW	$83D4
	STR	'C'		CM
	DB	'M'+$80
	DW	$83FC
	STR	'C'		CP
	DB	'P'+$80
	DW	$83F4
	STR	'CP'		CPE
	DB	'E'+$80
	DW	$83EC
	STR	'CP'		CPO
	DB	'O'+$80
	DW	$83E4
	STR	'RE'		RET
	DB	'T'+$80
	DW	$11C9
	STR	'RN'		RNZ
	DB	'Z'+$80
	DW	$11C0
	STR	'R'		RZ
	DB	'Z'+$80
	DW	$11C8
	STR	'R'		RC
	DB	'C'+$80
	DW	$11D8
	STR	'RN'		RNC
	DB	'C'+$80
	DW	$11D0
	STR	'R'		RM
	DB	'M'+$80
	DW	$11F8
	STR	'R'		RP
	DB	'P'+$80
	DW	$11F0
	STR	'RP'		RPE
	DB	'E'+$80
	DW	$11E8
	STR	'RP'		RPO
	DB	'O'+$80
	DW	$11E0
	STR	'CM'		CMP
	DB	'P'+$80
	DW	$91B8
	STR	'CP'		CPI
	DB	'I'+$80
	DW	$22FE
	STR	'PUS'		PUSH
	DB	'H'+$80
	DW	$41C5
	STR	'PO'		POP
	DB	'P'+$80
	DW	$41C1
	STR	'AD'		ADD
	DB	'D'+$80
	DW	$9180
	STR	'AD'		ADC
	DB	'C'+$80
	DW	$9188
	STR	'SU'		SUB
	DB	'B'+$80
	DW	$9190
	STR	'SB'		SBB
	DB	'B'+$80
	DW	$9198
	STR	'AD'		ADI
	DB	'I'+$80
	DW	$22C6
	STR	'AC'		ACI
	DB	'I'+$80
	DW	$22CE
	STR	'SU'		SUI
	DB	'I'+$80
	DW	$22D6
	STR	'SB'		SBI
	DB	'I'+$80
	DW	$22DE
	STR	'AN'		ANA
	DB	'A'+$80
	DW	$91A0
	STR	'AN'		ANI
	DB	'I'+$80
	DW	$22E6
	STR	'XR'		XRA
	DB	'A'+$80
	DW	$91A8
	STR	'XR'		XRI
	DB	'I'+$80
	DW	$22EE
	STR	'OR'		ORA
	DB	'A'+$80
	DW	$91B0
	STR	'OR'		ORI
	DB	'I'+$80
	DW	$22F6
	STR	'LDA'		LDAX
	DB	'X'+$80
	DW	$410A
	STR	'LHL'		LHLD
	DB	'D'+$80
	DW	$832A
	STR	'STA'		STAX
	DB	'X'+$80
	DW	$4102
	STR	'SHL'		SHLD
	DB	'D'+$80
	DW	$8322
	STR	'E'		EI
	DB	'I'+$80
	DW	$11FB
	STR	'D'		DI
	DB	'I'+$80
	DW	$11F3
	STR	'HL'		HLT
	DB	'T'+$80
	DW	$1176
	STR	'I'		IN
	DB	'N'+$80
	DW	$22DB
	STR	'OU'		OUT
	DB	'T'+$80
	DW	$22D3
	STR	'NO'		NOP
	DB	'P'+$80
	DW	$1100
	STR	'PCH'		PCHL
	DB	'L'+$80
	DW	$11E9
	STR	'SPH'		SPHL
	DB	'L'+$80
	DW	$11F9
	STR	'LD'		LDA
	DB	'A'+$80
	DW	$833A
	STR	'ST'		STA
	DB	'A'+$80
	DW	$8332
	STR	'ST'		STC
	DB	'C'+$80
	DW	$1137
	STR	'CM'		CMC
	DB	'C'+$80
	DW	$113F
	STR	'CM'		CMA
	DB	'A'+$80
	DW	$112F
	STR	'XCH'		XCHG
	DB	'G'+$80
	DW	$11EB
	STR	'XTH'		XTHL
	DB	'L'+$80
	DW	$11E3
	STR	'RA'		RAL
	DB	'L'+$80
	DW	$1117
	STR	'RA'		RAR
	DB	'R'+$80
	DW	$111F
	STR	'RR'		RRC
	DB	'C'+$80
	DW	$110F
	STR	'RL'		RLC
	DB	'C'+$80
	DW	$1107
	STR	'DA'		DAD
	DB	'D'+$80
	DW	$4109
	STR	'ST'		STR
	DB	'R'+$80
	DW	$D000
	STR	'EQ'		EQU
	DB	'U'+$80
	DW	$8000
	STR	'D'		DB
	DB	'B'+$80
	DW	$A100
	STR	'D'		DW
	DB	'W'+$80
	DW	$B200
	STR	'EN'		END
	DB	'D'+$80
	DW	$C000
	STR	'DA'		DAA
	DB	'A'+$80
	DW	$1127
	DB	$FF		END OF TABLE
SYM1	EQU	*		SYMBOL TABLE STARTS HERE
