*
* TEST: A RUNTIME DEBUGGER FOR THE 8080.
*
* NOTE: This program is NOT ROMable
*
* North-Star DOS entry points
CTRLC	EQU	$2016	Test for char (return in A), ZF=CTRL-C detected
DOSIN	EQU	$2010	Read a character from device(A) into A
DOSOUT	EQU	$200D	Write character in B to device(A)
DOS	EQU	$2028	Entry point to return to DOS
*
ISTACK	EQU	$2000	Initial stack pointer (for debugger)
IPC	EQU	$2A00	Initial program counter (for debugger)
*
	LXI	H,SRTMSG
	JMP	TEST
	DW	0
ENTRY	SHLD	HL
	XCHG
	SHLD	DE
	POP	H
	DCX	H
	SHLD	PC
	PUSH	B
	POP	H
	SHLD	BC
	PUSH	PSW
	POP	H
	SHLD	PSW
	LXI	H,0
	DAD	SP
	SHLD	SP
	LHLD	PC
	LXI	D,BRKTAB
	MVI	B,$30
TRYFND	LDAX	D
	INX	D
	CMP	H
	LDAX	D
	INX	D
	JNZ	NOTIT
	CMP	L
	JZ	FOUND
NOTIT	INX	D
	INR	B
	MOV	A,B
	CPI	$38
	JC	TRYFND
	JMP	NOBK
FOUND	LXI	H,INTMSG
	CALL	PMSG
	MOV	A,B
	CALL	OUT
	CALL	LFCR
NOBK	LXI	D,BRKTAB
	MVI	B,8
FIXL	LDAX	D
	INX	D
	MOV	H,A
	LDAX	D
	MOV	L,A
	INX	D
	MOV	A,H
	ANA	A
	LDAX	D
	JZ	NOFIX
	MOV	M,A
NOFIX	INX	D
	DCR	B
	JNZ	FIXL
	LDA	AFLAG
	ANA	A
	CNZ	REGDIS
	LDA	TRCFLG
	ANA	A
	JZ	REST
TRTB	LXI	H,TMSG
	CALL	PMSG
TRL	CALL	IN
	CPI	' '
	JZ	NOADR
	CPI	3
	JZ	RECR
	CPI	'R'
	JNZ	TRL
	CALL	REGDIS
	JMP	TRTB
REGDIS	LHLD	BC
	LXI	B,'BC'
	CALL	OUTPT
	LHLD	DE
	LXI	B,'DE'
	CALL	OUTPT
	LHLD	HL
	LXI	B,'HL'
	CALL	OUTPT
	LHLD	SP
	LXI	B,'SP'
	CALL	OUTPT
	LHLD	PC
	LXI	B,'PC'
	CALL	OUTPT
	LXI	H,PSWM
	CALL	PMSG
	LHLD	PSW
	MOV	A,H
	CALL	HPR
	MOV	A,L
	CALL	HPR
	CALL	SPACE
	CALL	SPACE
	LXI	H,FLGM
	CALL	PMSG
	LHLD	PSW
	MVI	B,'S'
	CALL	OUTB
	MVI	B,'Z'
	CALL	OUTB
	DAD	H
	MVI	B,'A'
	CALL	OUTB
	DAD	H
	MVI	B,'P'
	CALL	OUTB
	DAD	H
	MVI	B,'C'
	CALL	OUTB
	JMP	LFCR
OUTPT	CALL	DOUT
	MOV	B,C
	CALL	DOUT
	MVI	B,'='
	CALL	DOUT
	MOV	A,H
	CALL	HPR
	MOV	A,L
	CALL	HPR
	CALL	SPACE
* Display a space on the console
SPACE	MVI	B,' '
	JMP	DOUT
* Display character in 'B' if highest bit in 'L' is set
OUTB	MOV	A,L
	RLC
	MOV	L,A
	JC	DOUT
	RET
* Set breakpoints
SETBRK	CALL	CALC
	JC	DISBRK
	MOV	A,L
	CPI	8
	JNC	ERROR
	LXI	H,BRKTAB-3
	LXI	B,3
SBRLP	DAD	B
	DCR	A
	JP	SBRLP
	PUSH	H
	CALL	CALC
	JC	ERROR
	POP	D
	XCHG
	MOV	M,D
	INX	H
	MOV	M,E
	INX	H
	LDAX	D
	MOV	M,A
	JMP	REST
* Display breakpoints
DISBRK	LXI	D,BRKTAB
	MVI	B,$30
DISLP	MVI	A,'B'
	CALL	OUT
	MOV	A,B
	CALL	OUT
	MVI	A,'='
	CALL	OUT
	LDAX	D
	MOV	H,A
	INX	D
	LDAX	D
	MOV	L,A
	MOV	A,H
	ANA	A
	JZ	NOTSET
	CALL	HLOUT
	JMP	GIVLF
NOTSET	LXI	H,NOSET
	CALL	PMSG
GIVLF	MVI	A,' '
	CALL	OUT
	CALL	OUT
	MOV	A,B
	CPI	$33
	CZ	LFCR
	INX	D
	INX	D
	INR	B
	MOV	A,B
	CPI	$38
	JC	DISLP
	CALL	LFCR
	LXI	H,AUTMSG
	LDA	AFLAG
	CALL	DISON
	LXI	H,SUBMSG
	LDA	SFLAG
	CALL	DISON
	LXI	H,TRCMSG
	LDA	TRCFLG
	CALL	DISON
	CALL	LFCR
	JMP	REST
DISON	PUSH	PSW
	CALL	PMSG
	POP	PSW
	LXI	H,OFF
	ANA	A
	JZ	PMSG
	LXI	H,ON
	JMP	PMSG
* GO: Begin execution
GO	CALL	CALC
	JC	NOHEX
	SHLD	PC
NOHEX	LDA	TRCFLG
	ANA	A
	JNZ	TRTB
NOADR	LXI	H,0
	SHLD	INST
	SHLD	INST+1
	LHLD	PC
	XCHG
	PUSH	D
	CALL	LOOK
	MOV	B,A
	POP	D
	ANI	$03
	MOV	C,A
	LXI	H,INST
GOSET	LDAX	D
	MOV	M,A
	INX	H
	INX	D
	DCR	C
	JNZ	GOSET
	XCHG
	SHLD	JUMP+1
	INX	H
	SHLD	GOADR
	LDA	TRCFLG
	ANA	A
	JZ	NOTRC
	PUSH	B
	LHLD	PC
	XCHG
	CALL	DINST
	LXI	H,FAKE
	POP	B
	SHLD	JUMP+1
	LDA	INST
	CPI	$E9
	JNZ	NOPCHL
	LHLD	HL
	JMP	HLJMP
NOPCHL	MOV	A,B
	CPI	$0B
	JZ	GOJMP
	CPI	$05
	JZ	CALRET
	ANI	$F8
	JZ	NOTRC
	ANI	$08
	LDA	PSW
	JZ	NOCOM
	CMA
NOCOM	MOV	C,A
	MOV	A,B
	RAL
	JC	SIGN
	RAL
	JC	ZERO
	RAL
	JC	PARITY
CARRY	MOV	A,C
	ANI	$1
	JMP	ENFLG
SIGN	MOV	A,C
	ANI	$80
	JMP	ENFLG
ZERO	MOV	A,C
	ANI	$40
	JMP	ENFLG
PARITY	MOV	A,C
	ANI	$04
ENFLG	JZ	NOTRC
	MOV	A,B
	ANI	$04
	JNZ	CALRET
GOJMP	LDA	INST
	CPI	$CD
	JZ	PADR
	ANI	$C7
	CPI	$C4
	JNZ	NOPSH
PADR	LDA	SFLAG
	ANA	A
	JZ	NOTRC
	LHLD	GOADR
	DCX	H
	XCHG
	LHLD	SP
	DCX	H
	MOV	M,D
	DCX	H
	MOV	M,E
	SHLD	SP
NOPSH	LHLD	INST+1
HLJMP	INX	H
	SHLD	GOADR
	JMP	ZINSTR
CALRET	LHLD	SP
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	SHLD	SP
	XCHG
	INX	H
	SHLD	GOADR
ZINSTR	LXI	H,0
	SHLD	INST
	SHLD	INST+1
NOTRC	LXI	D,BRKTAB
	MVI	C,8
RESBP	LDAX	D
	MOV	H,A
	INX	D
	LDAX	D
	MOV	L,A
	INX	D
	MOV	A,H
	ANA	A
	JZ	NORES
	MVI	M,$CF
NORES	INX	D
	DCR	C
	JNZ	RESBP
	LHLD	SP
	SPHL
	LHLD	BC
	PUSH	H
	POP	B
	LHLD	PSW
	PUSH	H
	POP	PSW
	LHLD	DE
	XCHG
	LHLD	HL
INST	DW	0
	DB	0
JUMP	JMP	REST
FAKE	PUSH	H
	LHLD	GOADR
	XTHL
	JMP	ENTRY
GOADR	DW	0
TRCFLG	DB	0
SFLAG	DB	255
AFLAG	DB	255
HL	DW	0
DE	DW	0
BC	DW	0
PSW	DW	0
SP	DW	0
PC	DW	0
BRKTAB	STR	'000'
	STR	'000'
	STR	'000'
	STR	'000'
	STR	'000'
	STR	'000'
	STR	'000'
	STR	'000'
ON	STR	'ON !'
OFF	STR	'OFF!'
AUTMSG	STR	'AUTOREG=!'
SUBMSG	STR	' SUBTRACE=!'
TRCMSG	STR	' TRACE=!'
INTMSG	STR	'**BREAKPOINT !'
NOSET	STR	'****!'
PSWM	STR	' PSW=!'
FLGM	STR	' FLAGS=!'
SRTMSG	STR	'TEST 1.0!'
* Get a character from the console into A
DOUT	MVI	A,0		Use MVI so we can patch device number
	JMP	DOSOUT
* Write a Line-Feed and Carriage-Return to console
LFCR	MVI	A,$0A
	CALL	OUT
	MVI	A,$0D
* Write character in A to console
OUT	PUSH	B
	MOV	B,A
	CALL	DOUT
	POP	B
	RET
* Change register values
CHANGE	INX	D
	LDAX	D
	CPI	' '
	JZ	CHANGE
	MOV	B,A
	INX	D
	LDAX	D
	MOV	C,A
CHL	CPI	' '
	JZ	OKCH
	CPI	$0D
	JZ	ERROR
	INX	D
	LDAX	D
	JMP	CHL
OKCH	PUSH	B
	CALL	CALC
	POP	B
	JC	ERROR
	MOV	A,B
	CPI	'H'
	JNZ	CDE
	SHLD	HL
	JMP	REST
CDE	CPI	'D'
	JNZ	CBC
	SHLD	DE
	JMP	REST
CBC	CPI	'B'
	JNZ	CSP
	SHLD	BC
	JMP	REST
CSP	CPI	'S'
	JNZ	CP
	SHLD	SP
	JMP	REST
CP	CPI	'P'
	JNZ	ERROR
	MOV	A,C
	CPI	'S'
	JNZ	CPC
	SHLD	PSW
	JMP	REST
CPC	CPI	'C'
	JNZ	ERROR
	SHLD	PC
	JMP	REST
ONOFF	INX	D
	LDAX	D
	CPI	' '
	JZ	ONOFF
	CPI	'O'
	JNZ	ERROR
	INX	D
	MVI	B,0
	LDAX	D
	CPI	'F'
	JZ	RETON
	CPI	'N'
	JNZ	ERROR
	MVI	B,$FF
RETON	MOV	A,B
	RET
* Turn automatic register display ON or OFF
AUTO	CALL	ONOFF
	STA	AFLAG
	JMP	REST
* Tuen SUBROUTINE tracing ON or OFF
SUBON	CALL	ONOFF
	STA	SFLAG
	JMP	REST
* Set TRACE mode ON or OFF
TRACE	CALL	ONOFF
	STA	TRCFLG
	JMP	REST
* Edit memory contents
EDIT	CALL	CALC
	JC	ERROR
EDLP	CALL	HLOUT
	CALL	SPACE
	MOV	A,M
	CALL	HPR
	MVI	A,'-'
	CALL	OUT
	PUSH	H
	CALL	INPT
	CPI	'Q'
	JZ	REST
	CPI	'-'
	JZ	EBAC
	DCX	D
	CALL	CALC
	XCHG
	POP	H
	JC	ENXT
	MOV	M,E
ENXT	INX	H
	JMP	EDLP
EBAC	POP	H
	DCX	H
	JMP	EDLP
TEST	CALL	PMSG
	LXI	H,BRKTAB
	MVI	C,24
INIL1	MVI	M,0
	INX	H
	DCR	C
	JNZ	INIL1
	LXI	H,0
	SHLD	BC
	SHLD	DE
	SHLD	HL
	SHLD	PSW
	LXI	H,ISTACK
	SHLD	SP
	LXI	H,IPC
	SHLD	PC
* Newline and prompt for command
RECR	CALL	LFCR
* Prompt for an input command
REST	LXI	SP,ADTAB-2
DISASM	LXI	H,SMSG
PZZZ	CALL	PMSG
PRNT	CALL	INPT
	CPI	'Q'
	JZ	DOS
	CPI	'D'
	JZ	GODIS
	CPI	'M'
	JZ	MEMRY
	CPI	'B'
	JZ	SETBRK
	CPI	'G'
	JZ	GO
	CPI	'R'
	JZ	DISR
	CPI	'C'
	JZ	CHANGE
	CPI	'T'
	JZ	TRACE
	CPI	'E'
	JZ	EDIT
	CPI	'A'
	JZ	AUTO
	CPI	'S'
	JZ	SUBON
	CPI	$0D
	JZ	REST
ERROR	LXI	H,ERR
	CALL	PMSG
	JMP	DISASM
* Display registers
DISR	CALL	REGDIS
	JMP	REST
PMSG	MOV	A,M
	CPI	'!'
	RZ
	CALL	OUT
	INX	H
	JMP	PMSG
* Get HEX operands to command
CALC	LXI	H,0
	MOV	C,H
CLP0	INX	D
	LDAX	D
	CPI	' '
	JZ	CLP0
CAL1	LDAX	D
	CALL	VALHEX
	JC	BAD
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	SUI	$30
	CPI	$0A
	JC	COK
	SUI	7
COK	MOV	B,A
	MOV	A,L
	ANI	$F0
	ORA	B
	MOV	L,A
	INX	D
	MVI	C,7
	JMP	CAL1
BAD	MOV	A,C
	ANA	A
	STC
	RZ
	LDAX	D
	CPI	' '
	RZ
	CPI	$0D
	RZ
	STC
	RET
VALHEX	CPI	'0'
	RC
	CPI	'G'
	CMC
	RC
	CPI	$3A
	CMC
	RNC
	CPI	'A'
	RET
TMSG	STR	'T> !'
SMSG	STR	'C> !'
ERR	STR	'**ERROR**'
	DB	7
	DW	$0D0A
	DB	'!'
INPT	LXI	H,ADTAB
ILP	CALL	IN
	CPI	3
	JZ	RECR
	CPI	$5F
	JNZ	SKIP1
	MVI	A,8
SKIP1	DCX	H
	MOV	B,A
	CALL	DOUT
	CPI	8
	JZ	ILP
	INX	H
	MOV	M,A
	CPI	$0D
	INX	H
	JNZ	ILP
	MOV	M,A
	MVI	B,10
	CALL	DOUT
	LXI	D,ADTAB
	LDAX	D
	RET
HLOUT	MOV	A,H
	CALL	HPR
	MOV	A,L
HPR	PUSH	PSW
	RRC
	RRC
	RRC
	RRC
	CALL	HOUT
	POP	PSW
HOUT	ANI	$0F
	ADI	$30
	CPI	$3A
	JC	HOK
	ADI	7
HOK	JMP	OUT
* Perform disassembly to console
GODIS	CALL	CALC
	JC	ERROR
	PUSH	H
	CALL	CALC
	MOV	A,L
	STA	DOUT+1
	POP	D
	JMP	VLOOP
DINST	PUSH	D
	MOV	A,D
	CALL	HPR
	MOV	A,E
	CALL	HPR
	CALL	SPACE
	CALL	LOOK
	ANI	$03
	PUSH	PSW
	PUSH	H
	MVI	B,4
	MOV	C,A
	DCX	D
VLP1	INX	D
	PUSH	B
	LDAX	D
	CALL	HPR
	CALL	SPACE
	POP	B
	DCR	B
	DCR	C
	JNZ	VLP1
VLP2	PUSH	B
	CALL	SPACE
	CALL	SPACE
	CALL	SPACE
	POP	B
	DCR	B
	JNZ	VLP2
	POP	B
	POP	PSW
	POP	D
	PUSH	D
	PUSH	PSW
	PUSH	B
	MVI	H,8
	ANI	$0F
	MOV	C,A
PCHR	LDAX	D
	INX	D
	CPI	$7F
	JC	PROK
	MVI	A,' '
PROK	CPI	' '
	JNC	LESS
	MVI	A,' '
LESS	MOV	B,A
	CALL	DOUT
	DCR	H
	DCR	C
	JNZ	PCHR
SPLP	CALL	SPACE
	DCR	H
	JNZ	SPLP
	POP	B
	MVI	D,6
VLP3	LDAX	B
	CPI	$DD
	JZ	VOUT1
	PUSH	B
	MOV	B,A
	CALL	DOUT
	POP	B
	INX	B
	DCR	D
	CPI	' '
	JNZ	VLP3
VOUT	DCR	D
	JZ	VLP3
	PUSH	B
	CALL	SPACE
	POP	B
	JMP	VOUT
VOUT1	POP	PSW
	POP	D
	DCR	A
	JNZ	T2
VEXT	MVI	B,$0A
	CALL	DOUT
	MVI	B,$0D
	CALL	DOUT
	INX	D
	RET
VLOOP	CALL	DINST
	LDA	FLAG
	ANA	A
	JNZ	INLP1
	CALL	CTRLC
	JZ	CAN
	CPI	$0A
	JNZ	VLOOP
	MVI	A,$FF
	STA	FLAG
INLP1	CALL	IN
	CPI	$0A
	JZ	VLOOP
	CPI	$0D
	JZ	CR
	CPI	3
	JZ	CAN
	JMP	INLP1
CR	SUB	A
	STA	FLAG
	JMP	VLOOP
CAN	SUB	A
	STA	FLAG
	STA	DOUT+1
	JMP	DISASM
T2	PUSH	PSW
	MVI	B,'$'
	CALL	DOUT
	POP	PSW
	DCR	A
	JNZ	T3
	INX	D
	LDAX	D
	CALL	HPR
	JMP	VEXT
T3	INX	D
	INX	D
	LDAX	D
	CALL	HPR
	DCX	D
	LDAX	D
	CALL	HPR
	INX	D
	JMP	VEXT
* Read a character
IN	SUB	A
	JMP	DOSIN
* Display a block of memory
MEMRY	CALL	CALC
	JC	ERROR
	MVI	C,0
ALOOP	MOV	A,H
	CALL	HPR
	MOV	A,L
	CALL	HPR
	CALL	SPACE
	CALL	SPACE
	MVI	D,16
	PUSH	H
ALP1	MOV	A,M
	CALL	HPR
	CALL	SPACE
	MOV	A,D
	CPI	9
	CZ	SPACE
	MOV	A,D
	ANI	7
	CPI	5
	CZ	SPACE
	INX	H
	DCR	D
	JNZ	ALP1
	MVI	D,4
AL2	CALL	SPACE
	DCR	D
	JNZ	AL2
	MVI	B,'*'
	CALL	DOUT
	POP	H
	MVI	D,16
AL3	MOV	A,M
	CPI	' '
	JC	BLANK
	CPI	$7F
	JNC	BLANK
	MOV	B,A
	CALL	DOUT
RETU	INX	H
	DCR	D
	JNZ	AL3
	MVI	B,'*'
	CALL	DOUT
	MVI	B,$0A
	CALL	DOUT
	MVI	B,$0D
	CALL	DOUT
	MOV	A,C
	ANA	A
	JNZ	WAIT
	CALL	CTRLC
	JZ	REST
	CPI	$0A
	JNZ	ALOOP
WAIT	MVI	C,255
	CALL	IN
	CPI	$0A
	JZ	ALOOP
	MVI	C,0
	CPI	3
	JZ	REST
	CPI	$0D
	JNZ	WAIT
	JMP	ALOOP
BLANK	MVI	B,'.'
	CALL	DOUT
	JMP	RETU
FLAG	DB	0
DB	DCX	D
LOOK	LDAX	D
	MOV	B,A
	LXI	H,TABLE
LOOK1	MVI	A,$DD
L2	CMP	M
	INX	H
	JNZ	L2
	MOV	A,M
	CPI	$DD
	JZ	TMOV
	CMP	B
	JNZ	LOOK1
	INX	H
	MOV	A,M
	INX	H
	RET
TMOV	MOV	A,B
	ANI	$C0
	CPI	$40
	JNZ	TMVI
	CALL	GETB
	STA	SOURCE
	MOV	A,B
	RRC
	RRC
	RRC
	CALL	GETREG
	STA	DEST
	LXI	H,MOVIN
	MVI	A,1
	RET
RTAB	STR	'BCDEHLMA'
MOVIN	STR	'MOV '
DEST	DB	0
	DB	','
SOURCE	DB	0
	DB	$DD
TMVI	MOV	A,B
	ANI	$C7
	CPI	6
	JNZ	TSUB
	MOV	A,B
	RRC
	RRC
	RRC
	CALL	GETREG
	STA	MDST
	LXI	H,MVIIN
	MVI	A,2
	RET
MVIIN	STR	'MVI '
MDST	DB	0
	DB	','
	DB	$DD
GETB	MOV	A,B
GETREG	LXI	H,RTAB
	ANI	7
	ADD	L
	MOV	L,A
	MOV	A,M
	RET
TSUB	MOV	A,B
	ANI	$F8
	CPI	$90
	JNZ	TSBB
	CALL	GETB
	STA	SDDS
	LXI	H,SUBIN
	MVI	A,1
	RET
SUBIN	STR	'SUB '
SDDS	DW	$DD00
TSBB	CPI	$98
	JNZ	TADD
	CALL	GETB
	STA	SBBS
	LXI	H,SBBIN
	MVI	A,1
	RET
SBBIN	STR	'SBB '
SBBS	DW	$DD00
TADD	CPI	$80
	JNZ	TADC
	CALL	GETB
	STA	ADDS
	LXI	H,ADDIN
	MVI	A,1
	RET
ADDIN	STR	'ADD '
ADDS	DW	$DD00
TADC	CPI	$88
	JNZ	TANA
	CALL	GETB
	STA	ADCS
	LXI	H,ADCIN
	MVI	A,1
	RET
ADCIN	STR	'ADC '
ADCS	DW	$DD00
TANA	CPI	$A0
	JNZ	TORA
	CALL	GETB
	STA	ANAS
	LXI	H,ANAIN
	MVI	A,1
	RET
ANAIN	STR	'ANA '
ANAS	DW	$DD00
TORA	CPI	$B0
	JNZ	TXRA
	CALL	GETB
	STA	ORAS
	LXI	H,ORAIN
	MVI	A,1
	RET
ORAIN	STR	'ORA '
ORAS	DW	$DD00
TXRA	CPI	$A8
	JNZ	TCMP
	CALL	GETB
	STA	XRAS
	LXI	H,XRAIN
	MVI	A,1
	RET
XRAIN	STR	'XRA '
XRAS	DW	$DD00
TCMP	CPI	$B8
	JNZ	TINR
	CALL	GETB
	STA	CMPS
	LXI	H,CMPIN
	MVI	A,1
	RET
CMPIN	STR	'CMP '
CMPS	DW	$DD00
TINR	MOV	A,B
	ANI	$C7
	CPI	4
	JNZ	TDCR
	MOV	A,B
	RRC
	RRC
	RRC
	CALL	GETREG
	STA	INRDS
	LXI	H,INRIN
	MVI	A,1
	RET
INRIN	STR	'INR '
INRDS	DW	$DD00
TDCR	CPI	$05
	JNZ	NF
	MOV	A,B
	RRC
	RRC
	RRC
	CALL	GETREG
	STA	DCRDS
	LXI	H,DCRIN
	MVI	A,1
	RET
DCRIN	STR	'DCR '
DCRDS	DW	$DD00
NF	MVI	A,$41
	LXI	H,DBOP
	RET
DBOP	STR	'DB '
	DB	$DD
TABLE	DB	$DD
	DW	$0100
	STR	'NOP'
	DB	$DD
	DW	$0BC3
	STR	'JMP '
	DB	$DD
	DW	$83FA
	STR	'JM '
	DB	$DD
	DW	$8BF2
	STR	'JP '
	DB	$DD
	DW	$2BE2
	STR	'JPO '
	DB	$DD
	DW	$23EA
	STR	'JPE '
	DB	$DD
	DW	$02FE
	STR	'CPI '
	DB	$DD
	DW	$0321
	STR	'LXI H,'
	DB	$DD
	DW	$0311
	STR	'LXI D,'
	DB	$DD
	DW	$0301
	STR	'LXI B,'
	DB	$DD
	DW	$0331
	STR	'LXI S,'
	DB	$DD
	DW	$033A
	STR	'LDA '
	DB	$DD
	DW	$0332
	STR	'STA '
	DB	$DD
	DW	$0322
	STR	'SHLD '
	DB	$DD
	DW	$032A
	STR	'LHLD '
	DB	$DD
	DW	$4BC2
	STR	'JNZ '
	DB	$DD
	DW	$43CA
	STR	'JZ '
	DB	$DD
	DW	$13DA
	STR	'JC '
	DB	$DD
	DW	$1BD2
	STR	'JNC '
	DB	$DD
	DW	$05C9
	STR	'RET'
	DB	$DD
	DW	$15D8
	STR	'RC'
	DB	$DD
	DW	$85F8
	STR	'RM'
	DB	$DD
	DW	$1DD0
	STR	'RNC'
	DB	$DD
	DW	$4DC0
	STR	'RNZ'
	DB	$DD
	DW	$8DF0
	STR	'RP'
	DB	$DD
	DW	$25E8
	STR	'RPE'
	DB	$DD
	DW	$2DE0
	STR	'RPO'
	DB	$DD
	DW	$45C8
	STR	'RZ'
	DB	$DD
	DW	$0BCD
	STR	'CALL '
	DB	$DD
	DW	$43CC
	STR	'CZ '
	DB	$DD
	DW	$4BC4
	STR	'CNZ '
	DB	$DD
	DW	$8BF4
	STR	'CP '
	DB	$DD
	DW	$83FC
	STR	'CM '
	DB	$DD
	DW	$13DC
	STR	'CC '
	DB	$DD
	DW	$1BD4
	STR	'CNC '
	DB	$DD
	DW	$23EC
	STR	'CPE '
	DB	$DD
	DW	$2BE4
	STR	'CPO '
	DB	$DD
	DW	$0109
	STR	'DAD B'
	DB	$DD
	DW	$0119
	STR	'DAD D'
	DB	$DD
	DW	$0129
	STR	'DAD H'
	DB	$DD
	DW	$0139
	STR	'DAD SP'
	DB	$DD
	DW	$01F5
	STR	'PUSH PSW'
	DB	$DD
	DW	$01C5
	STR	'PUSH B'
	DB	$DD
	DW	$01D5
	STR	'PUSH D'
	DB	$DD
	DW	$01E5
	STR	'PUSH H'
	DB	$DD
	DW	$01F1
	STR	'POP PSW'
	DB	$DD
	DW	$01C1
	STR	'POP B'
	DB	$DD
	DW	$01D1
	STR	'POP D'
	DB	$DD
	DW	$01E1
	STR	'POP H'
	DB	$DD
	DW	$0103
	STR	'INX B'
	DB	$DD
	DW	$0113
	STR	'INX D'
	DB	$DD
	DW	$0123
	STR	'INX H'
	DB	$DD
	DW	$0133
	STR	'INX SP'
	DB	$DD
	DW	$010B
	STR	'DCX B'
	DB	$DD
	DW	$011B
	STR	'DCX D'
	DB	$DD
	DW	$012B
	STR	'DCX H'
	DB	$DD
	DW	$013B
	STR	'DCX SP'
	DB	$DD
	DW	$0127
	STR	'DAA'
	DB	$DD
	DW	$0176
	STR	'HLT'
	DB	$DD
	DW	$01FB
	STR	'EI'
	DB	$DD
	DW	$01F3
	STR	'DI'
	DB	$DD
	DW	$0137
	STR	'STC'
	DB	$DD
	DW	$013F
	STR	'CMC'
	DB	$DD
	DW	$01EB
	STR	'XCHG'
	DB	$DD
	DW	$01E3
	STR	'XTHL'
	DB	$DD
	DW	$01F9
	STR	'SPHL'
	DB	$DD
	DW	$01E9
	STR	'PCHL'
	DB	$DD
	DW	$02DB
	STR	'IN '
	DB	$DD
	DW	$02D3
	STR	'OUT '
	DB	$DD
	DW	$0107
	STR	'RLC'
	DB	$DD
	DW	$0117
	STR	'RAL'
	DB	$DD
	DW	$011F
	STR	'RAR'
	DB	$DD
	DW	$010F
	STR	'RRC'
	DB	$DD
	DW	$02CE
	STR	'ACI '
	DB	$DD
	DW	$02C6
	STR	'ADI '
	DB	$DD
	DW	$02E6
	STR	'ANI '
	DB	$DD
	DW	$02F6
	STR	'ORI '
	DB	$DD
	DW	$02EE
	STR	'XRI '
	DB	$DD
	DW	$02D6
	STR	'SUI '
	DB	$DD
	DW	$02DE
	STR	'SBI '
	DB	$DD
	DW	$010A
	STR	'LDAX B'
	DB	$DD
	DW	$011A
	STR	'LDAX D'
	DB	$DD
	DW	$0102
	STR	'STAX B'
	DB	$DD
	DW	$0112
	STR	'STAX D'
	DB	$DD
	DW	$012F
	STR	'CMA'
	DW	$DDDD
ENDIT	EQU	*
ADTAB	EQU	*+100
