*
*   SETUP.ASM - Perform basic initializations, setup AIC chip,
*               provide commonly used defines.
*
AIC_CNTA    .set    01830h  ; filter cutoff approx. 5200 (TA=RA=12)
AIC_CNTB    .set    02c5ah  ; sample rate 18939 (TB=RB=22)
AIC_CTRL    .set    00043h  ; bandpass filter off, unity gain
DRR         .set    0
DXR         .set    1
TIM         .set    2
PRD         .set    3
IMR         .set    4
GREG        .set    5
B2_D        .set    060h
B0_D        .set    0200h
B1_D        .set    0400h
B3_D        .set    0600h
B0_P        .set    0FA00h
B1_P        .set    0FC00h
B3_P        .set    0FE00h

*
*   Secondary interrupt vector table in program RAM
*
        .ps     0fa00h
        B       go          ; reset
        B       go          ; INT0
        B       go          ; INT1
        B       go          ; INT2  (DSKD load ignores INT2 vector)
        B       tint        ; timer interrupt
        B       rint        ; AIC recv interrupt
        B       xint        ; AIC xmit interrupt

*
*                               go
*
*   Initial entry point for DSK audio demos.  Performs various
*   initializations and then jumps to "main"
*
        .ps     0FB00h
        .entry
go:
        ldpk    0           ; data page 0 for mem mapped regs and B2
        conf    1           ; select memory map
        sovm                ; accum saturates on overflow
        fort    0           ; serial port in 16 bit mode
        rtxm                ; external xmit frame sync
        sfsm                ; external recv frame sync
        lack    024h        ; briefly enable xmit interrupt
        eint                ; enable interrupts
        sacl    IMR         ; store at interrupt mode reg
        lalk    AIC_CNTA    ; get word for counter A reg
        call    wr_aic_reg
        lalk    AIC_CNTB    ; get word for counter B reg
        call    wr_aic_reg
        lalk    AIC_CTRL    ; get word for ctrl reg
        call    wr_aic_reg
        dint
        b       main
        
*
*                           wr_aic_reg
*
*   Performs secondary transmit operation to write to config
*   registers at AIC chip.  Passed register value in ACCUM.
*   Xmit interrupts must be enabled before calling.
*
wr_aic_reg:
        idle                ; wait for xmit request
        lark    AR0,3       ; low 2 bits set request secondary xmit
        sar     AR0,DXR 
        idle                ; wait for secondary xmit request
        sacl    DXR         ; write the register
        idle
        zac                 ; low 2 bits clear to go back to normal
        sacl    DXR
        ret
