	TITLE	8080/8085 SYSTEM MONITOR
****************************************************************
*                   8080/8085 SYSTEM MONITOR                   *
*--------------------------------------------------------------*
*  COMMANDS:                                                   *
*    B .................... ENTER RESIDENT BASIC INTERPRETER.  *
*    D .................... DOWNLOAD FROM TERMINAL PORT.       *
*    G <ADR> .............. GO (EXECUTE) AT ADDRESS.           *
*    L .................... LOAD MEMORY FROM TAPE.             *
*    M <ADR>,<ADR> ........ DISPLAY MEMORY IN HEXIDECIMAL.     *
*    R .................... REENTER RESIDENT BASIC.            *
*    S <ADR> [NN]-<BYT> ... SUBSTUTE INTO MEMORY.              *
*    T 'H' OR 'F' ......... TERMINAL EMULATION MODE.           *
*    U <WRD> .............. REINITIALIZE 8251 UART.            *
*    W <ADDR>,<ADDR> ...... WRITE MEMORY TO TAPE.              *
****************************************************************
	PAGE
*
* CONSTANTS AND EQUATES...
*
DEFIO	EQU	3		DEFAULT I/O CONFIGURATION
KEYBRD	EQU	0		KEYBOARD INPUT PORT
UCTL	EQU	2		UART CONTROL/STATUS PORT
UDAT	EQU	1		UART DATA PORT
VIDEO	EQU	$1000		VIDEO DISPLAY RAM ADDRESS
BUFF	EQU	$1400		INPUT BUFFER
IOCON	EQU	BUFF+$FF	I/O CONFIGURATION
USROUT	EQU	IOCON-2		USER OUTPUT ROUTINE VECTOR
CURSOR	EQU	USROUT-2	CURRENT CURSOR POSITION
LSTCHR	EQU	CURSOR-1	CHARACTER UNDER CURSOR
STACK	EQU	LSTCHR		SYSTEM STACK
BASIC	EQU	$400		ADDRESS OF RESIDENT BASIC INTERPRETER
RENTRY	EQU	BASIC+$A3	ADDRESS TO REENTER BASIC
	PAGE
*
* START OF MONITOR, FIRST INITIALIZE THE HARDWARE
*
START	LXI	SP,STACK	INITALIZE STACK
	LXI	H,0		SET USRIO TO ZERO...
	SHLD	USROUT		TO INDICATE IT HASN'T BEEN SET
	MVI	A,DEFIO		DEFAULT I/O CONFIGURATION
	STA	IOCON		SET I/O CONFIGURATION
	LXI	H,$7A37		USART 7 BITS, NO PARITY, HIGH-SPEED
	CALL	SETURT		INITIALIZE 8251
	MVI	A,$0C		CLEAR SCREEN CHARACTER
	CALL	OUT		DISPLAY
	JMP	PRNT		PROMPT FOR COMMAND
* GETS DOUBLE VALUE FOR HL, DE
DGET	CALL	AGET		GET FIRST ADDRESS
	XCHG			SWAP
	MVI	A,','		GET SEPERATOR CHARACTER
	CALL	OUT		DISPLAY
* GETS TWO BYTE VALUE FOR H-L
AGET	CALL	GETHL		GET HEX VALUE
	RC			RETURN IF OK
* INDICATE ERROR WITH '?' ON CONSOLE
ERROR	MVI	A,'?'		ERROR MESSAGE
	CALL	OUT		DISPLAY IT
* RECOVER FROM ERROR, RESET STACK, SHUT TAPE OFF
ABORT	LXI	SP,STACK	FIX UP STACK
	CALL	TOFF		SHUT OFF TAPE
	CALL	NL		NEW LINE ON TERMINAL
* WAIT FOR COMMAND
PRNT	MVI	A,'*'		PROMPT MESSAGE
	CALL	OUT		DISPLAY
	CALL	IN		GET CHARACTER FROM TERMINAL
	CALL	OUT		ECHO
	MOV	B,A		SAVE FOR COMPARISON
	CALL	SPACE		DISPLAY SEPARATER
	LXI	H,CTAB		POINT TO COMMAND TABLE
CLOOK	MOV	A,M		GET CMD FROM TABLE
	INX	H		POINT TO NEXT
	ANA	A		TEST FOR END IF TABLE
	JZ	ERROR		IF SO, INDICATE SO
	MOV	E,M		GET LOW ADDRESS
	INX	H		POINT TO HIGH
	MOV	D,M		GET HIGH ADDRESS
	INX	H		POINT TO NEXT
	CMP	B		TEST FOR ENTERED COMMAND
	JNZ	CLOOK		KEEP LOOKING TILL WE FIND
	LXI	H,ABORT		ADDRESS TO RETURN TO
	PUSH	H		SAVE RETURN ADDRESS
	XCHG			SWAP TO H-L
	PCHL			EXECUTE USER CODE
CTAB	DB	'B'		BASIC COMMAND?
	DW	BASIC		ADDRESS OF BASIC INTERPRETER
	DB	'R'		TEST FOR 'REENTER'
	DW	RENTRY		REENTER BASIC
	DB	'D'		TEST FOR DOWNLOAD
	DW	DNLD		PERFORM DOWNLOAD
	DB	'L'		TEST FOR 'LOAD'
	DW	LOAD		LOAD FROM TAPE
	DB	'U'		TEST FOR 'UART'
	DW	UART		SET UP UART
	DB	'G'		TEST FOR 'GO'
	DW	GO		GO EXECUTE
	DB	'S'		TEST FOR 'SUB'
	DW	SUBST		SUBST. MEMORY
	DB	'W'		TEST FOR 'WRITE'
	DW	DUMP		DUMP SOME OUT
	DB	'M'		TEST FOR 'M'
	DW	MEMRY		MEMORY CODE
	DB	'T'		TERMINAL MODE???
	DW	TMODE		IF SO, ENTER TERMINAL
	DB	0		INDICATE END OF TABLE
*
* DISPLAY MEMORY COMMAND
*
MEMRY	CALL	DGET		GET ADDRESSES
	XCHG			SWAP BACK
MLOOP	CALL	NL		START A NEW LINE
	CALL	HLOUT		DISPLAY ADDRESS
ML1	CALL	SPACE		DISPLAY SPACE
	MOV	A,M		GET CONTENTS
	CALL	HOUT		DISPLAY HEX
	CALL	CHLDE		TEST FOR END
	RNC			IF SO, STOP
	INX	H		NEXT BYTE
	MOV	A,L		GET LOW ADDRESS
	ANI	$0F		TEST FOR END OF LINE
	JNZ	ML1		IF NOT, KEEP GOING
	CALL	CTRLC		TEST FOR USER ABORT
	JNZ	MLOOP		IF NOT, KEEP DISPLAYING
	RET
*
* GO COMMAND
*
GO	CALL	AGET		GET ADDRESS TO 'GO' AT
	PCHL			SET PROGRAM COUNTER
*
* SUBSTUTUTE COMMAND
*
SUBST	CALL	AGET		GET ADDRESS
SUB0	CALL	NL		START ON A NEW LINE
	CALL	HLOUT		DISPLAY ADDRESS
	MVI	D,8		EIGHT BYTES/LINE
SUB1	CALL	SPACE		SKIP A SPACE
	MOV	A,M		GET CONTENTS
	CALL	HOUT		DISPLAY
	MVI	A,'-'		PROMPT WITH '-'
	CALL	OUT		DISPLAY
	CALL	GETBYT		GET BYTE
	JC	SUB3		IF OK, SUBSTUTE
	CPI	$0D		TEST FOR ABORT
	RZ			IF SO, BACK FOR COMMAND
	CALL	SPACE		OTHERWISE, PRINT.
	CALL	SPACE		TWO SPACES (SAME SPACE AS HEX DIGITS)
	MOV	A,M		GET OLD BYTE BACK
SUB3	MOV	M,A		REPLACE MEMORY CONTENTS
SNXT	INX	H		NEXT LOCATION IN MEMORY
	DCR	D		REDUCE COUNT OF BYTES/LINE
	JNZ	SUB1		IF OK, STAY ON SAME LINE
	JMP	SUB0		OTHERWISE GO TO NEW LINE
*
* DUMP COMMAND
*
DUMP	CALL	DGET		GET ADDRESSES
* DE=START ADDRESS, H-L=END ADDRESS
DUMP1	INX	H		ADVANCE BY ONE BYTE
	MOV	A,H		TEST FOR SPECIAL CASE
	ANA	A		IF ZERO PAGE
	JZ	LBOT		IF SO, SPECIAL CASE
	PUSH	H		SAVE ENDING VALUE
	LXI	B,$FF01		GET VALUE TO SUBTRACT
	DAD	B		SUBTRACT FROM ENDING ADDRESS
	XCHG			SWAP BACK
	CALL	TON		START TAPE DRIVE
DRECL	CALL	CHLDE		SEE IF WE HAVE FINISHED YET
	JNC	LREC		IF SO, LAST RECORD
	MVI	A,$FF		OTHERWISE, RECORD LENGTH IS 255
	CALL	DUMPR		DUMP OUT RECORD
	JMP	DRECL		KEEP GOING TILL LAST RECORD
LREC	POP	D		GET ADDRES BACK
	XCHG			SWAP
LBOT	PUSH	D		GET ADDRESS BACK
	MOV	A,D		TAKE.
	CMA			TWO'S.
	MOV	D,A		COMPLEMENT.
	MOV	A,E		SO WE CAN.
	CMA			SUBTRACT.
	MOV	E,A		FROM THE
	INX	D		ORIGIONAL ADDRESS
	DAD	D		SUBTRACT
	MOV	A,L		GET LENGTH
	POP	H		GET ADDRESS BACK
	CALL	DUMPR		DUMP LAST RECORD
	SUB	A		END OF FILE INDICATOR
*
* DUMPS A RECORD IN INTEL HEX FORMAT
*
DUMPR	MOV	B,A		SAVE LENGTH IN B
	MVI	A,4		SET FOR UART OUTPUT
	STA	IOCON		SET I/O CONF
	CALL	NL		DISPLAY LF CR TO TAPE
	MVI	A,':'		START OF RECORD
	CALL	OUT		WRITE TO TABE
	MOV	A,B		GET LENGTH
	MOV	C,A		START CHECKSUM
	CALL	HOUT		WRITE LENGTH TO TAPE
	MOV	A,B		GET LENGTH BACK
	ANA	A		TEST FOR END OF FILE
	JZ	ENDMP		IF SO, STOP
	CALL	HLOUT		WRITE ADDRESS TO TAPE
	MOV	A,C		GET CHECKSUM
	ADD	H		ADD HIGH ADDRESS
	ADD	L		ADD LOW ADDRESS
	MOV	C,A		RESAVE CHECKSUM
	SUB	A		DATA TYPE ZERO
	CALL	HOUT		WRITE TO TAPE
MHEX	MOV	A,M		GET BYTE OF DATA TO DUMP
	CALL	HOUT		WRITE TO TAPE
	MOV	A,M		GET DATA BACK
	ADD	C		ADD TO CHECKSUM
	MOV	C,A		RESAVE CHECKSUM
	INX	H		NEXT MEMORY LOCATION
	DCR	B		REDUCE LENGTH
	JNZ	MHEX		IF NOT END, KEEP DUMPING
	CMA			INVERT TO MAKE.
	INR	A		TWO'S COMPLEMENT CHECKSUM
	CALL	HOUT		WRITE CHECKSUM TO TAPE
ENDMP	MVI	A,DEFIO		GET DEFAULT I/O CONF
	STA	IOCON		RESET I/O CONFIGURATION
	RET
*
* COMPARE'S H-L WITH D-E
*
CHLDE	MOV	A,H		GET HIGH IF HL
	CMP	D		TEST WITH HIGH OF DE
	RNZ			IF NOT SAME, PROBLEM SOLVED
	MOV	A,L		GET LOW HL
	CMP	E		SET FLAGS FOR COMPARE WITH LOW DE
	RET
* DISPLAYS A SPACE ON THE TERMINAL
SPACE	MVI	A,' '		GET A SPACE
	JMP	OUT		DISPLAY
*
* DISPLAYS 16 BIT VALUE OF H-L ON THE TERMINAL
*
HLOUT	MOV	A,H		GET H
	CALL	HOUT		DISPLAY H IN HEX
	MOV	A,L		GET L
* DISPLYS 8 BIT VALUE OF ACC IN HEX
HOUT	PUSH	PSW		SAVE LOW DIGIT
	RRC			MAKE HIGH.
	RRC			DIGIT.
	RRC			INTO.
	RRC			LOW DIGIT.
	CALL	HXOUT		PRINT HIGH DIGIT
	POP	PSW		GET LOW DIGIT BACK
HXOUT	ANI	$0F		GET RID OF EXCESS BAGGAGE
	ADI	$30		CONVERT TO ASCII NUMBER
	CPI	$3A		TEST FOR ALPHA CHARACTER
	JC	OUT		IF NOT, WE ARE OK
	ADI	7		CONVERT TO CHARACTER
*
* OUTPUT ROUTINE, DISPLAYS CONTENTS OF ACC ON ALL ENABLED
* OUTPUT DEVICES
*
OUT	PUSH	B		SAVE B-C PAIR
	PUSH	D		SAVE D-E PAIR
	PUSH	H		SAVE H-L PAIR
	MOV	B,A		SAVE CHARACTER IN B
	LDA	IOCON		GET I/O CONFIGURATION
	MOV	C,A		SAVE IN C
	ANI	$40		TEST FOR OUTPUT DISABLED
	JNZ	OEXIT		IF SO, ABORT
	MOV	A,C		GET CONFIGURATION BACK
	ANI	2		TEST FOR VIDEO DISPLAY ENABLED
	JZ	OURT		NO, TRY UART
* OUTPUT TO VIDEO DISPLAY
OVID	LHLD	CURSOR		GET CURSOR POSITION
	LDA	LSTCHR		GET CHARACTER UNDER CURSOR
	MOV	M,A		REPLACE CURSOR
	MOV	A,B		GET CHARACTER TO PRINT
	CPI	13		TEST FOR CR
	JZ	CR		ADVANCE TO NEXT LINE
	CPI	10		TEST FOR LINE-FEED
	JZ	LF		ADVANCE TO NEXT LINE
	CPI	8		TEST FOR BACKSPACE
	JZ	BS		BACK UP
	CPI	14		TEST FOR SHIFT-IN
	JZ	SI		ENABLE EIGHTH BIT
	CPI	15		TEST FOR SHIFT-OUT
	JZ	SO		DISABLE EIGHTH BIT
	CPI	$0C		TEST FOR CLEAR SCREEN
	JZ	CLRSCR		CLEAR THE SCREEN
	CPI	$0B		TEST FOR HOME CHARACTER
	JZ	HOME		HOME THE CURSOR
	MOV	A,C		GET I/O CONFIGURATION
	ANI	$80		ELIMINATE ALL BUT SPECIAL EFFECTS BIT
	ORA	B		OR IN CHARACTER TO BE PRINTED
	MOV	M,A		DISPLAY ON SCREEN
	INX	H		ADVANCE TO NEXT POSITION ON SCREEN
	MOV	A,H		GET HIGH ADDRESS
	CPI	=VIDEO+1024	TEST FOR OFF SCREEN
	JNZ	VEND		IF NOT, WE ARE OK
	CALL	ROLL		SCROLL THE SCREEN
	LXI	H,VIDEO+960	POSITION TO FIRST POSITION OF LAST LINE
VEND	MOV	A,M		GET CHARACTER UNDER CURSOR
	STA	LSTCHR		SAVE IN MEMORY
	MVI	M,$7F		PLACE CURSOR ON SCREEN
	SHLD	CURSOR		SAVE CURSOR POSITION
	JMP	OURT		TEST FOR UART OUTPUT
* DISPLAY CARRIAGE RETURN ON TERMINAL
CR	MOV	A,L		GET LOW SCREEN ADDRESS
	ANI	$C0		BACK UP TO FIRST POS. IN LINE
	MOV	L,A		REPLACE IN ADDRESS
	JMP	VEND		TERMINATE
* LINE-FEED
LF	XCHG			SWAP POSITION TO D-E
	LXI	H,64		ADD 64 TO IT
	DAD	D		GO DOWN ONE LINE
	MOV	A,H		GET HIGH ADDRESS
	CPI	=VIDEO+1024	TEST FOR BEYOND END
	JNZ	VEND		IF NOT, WE ARE OK
	XCHG			GET ADDRESS BACK
	CALL	ROLL		SCROLL SCREEN
	JMP	VEND		TERMINALE
* BACK SPACE
BS	DCX	H		BACK UP POSITION
	MOV	A,H		GET HIGH ADDRESS
	CPI	=VIDEO-1	TEST FOR BEFORE SCREEN
	JNZ	VEND		IF NOT, WE ARE OK
	INX	H		ADVANCE BACK TO VIDEO SCREEN
	JMP	VEND		TERMINATE
* SHIFT OUT, DISABLE EXTRA BIT
SO	MOV	A,C		GET I/O CONFIGURATION
	ANI	$7F		REMOVE EXTRA BIT
SAVIO	STA	IOCON		RESAVE
	JMP	VEND		TERMINATE
* SHIFT IN, ENABLE SPECIAL CHARACTERS
SI	MOV	A,C		GET I/O CONFIG
	ORI	$80		ENABLE EXTRA BIT
	JMP	SAVIO		SAVE AND TERMINATE
* ROLLS SCREEN
ROLL	PUSH	H		SAVE H-L
	LXI	H,VIDEO		GET VIDEO ADDRESS
	LXI	D,VIDEO+64	SECOND LINE ON SCREEN
RLP1	LDAX	D		GET CHARACTER FROM LINE
	MOV	M,A		STORE ONE LINE BACK
	INX	H		ADVANCE POSITION
	INX	D		ADVANCE POSITION
	MOV	A,D		GET ADDRESS
	CPI	=VIDEO+1024	TEST FOR END OF SCREEN
	JNZ	RLP1		IF NOT, KEEP GOING
* CLEAR LAST LINE
RLP2	MVI	M,' '		CLEAR ONE CHARACTER
	INX	H		POINT TO CHARACTER
	CMP	H		TEST FOR END OF SCREEN
	JNZ	RLP2		IF NOT, KEEP GOING
	POP	H		RESTORE H-L
	RET
* CLEAR SCREEN
CLRSCR	MVI	A,=VIDEO+1024	ADDRESS OF END OF SCREEN
	LXI	H,VIDEO		STARTING ADDRESS
CLR1	MVI	M,' '		CLEAR ONE CHARACTER
	INX	H		POINT TO NEXT CHARACTER
	CMP	H		TEST FOR OVER END
	JNZ	CLR1		IF NOT, KEEP GOING
* HOME CURSOR
HOME	LXI	H,VIDEO		SET CURSOR ADDRESS TO TOP LEFT HAND
	JMP	VEND		TERMINATE
* TEST FOR UART OUTPUT
OURT	MOV	A,C		GET I/O CONFIGURATION
	ANI	4		TEST FOR UART ENABLED
	JZ	OUSR		IF NOT, TRY USER SUPPLIED ROUTINE
ULP1	IN	UCTL		GET UART STATUS
	RRC			TEST FOR XMIT READY
	JNC	ULP1		IF NOT, KEEP TRYING
	MOV	A,B		GET CHARACTER
	OUT	UDAT		OUTPUT TO UART
* USER SUPLIED OUTPUT DEVICE
OUSR	MOV	A,C		GET I/O CONFIGURATION
	ANI	$08		TEST FOR USER DEVICE ENABLED
	JZ	OEXIT		IF NOT, EXIT
	LXI	H,OEXIT		ADDRESS TO RETURN TO
	PUSH	H		SAVE ON STACK
	LHLD	USROUT		ADDRESS TO JUMP TO
	PCHL			CALL HIS ROUTINE
OEXIT	POP	H		RESTORE H-L
	POP	D		RESTORE D-E
	MOV	A,B		CHARACTER IS IN A
	POP	B		RESTORE B-C
	RET
*
* INPUT ROUTINE, INPUTS FROM SELECTED DEVICE
*
IN	PUSH	B		SAVE B-C PAIR
INS1	LDA	IOCON		GET INPUT/OUTPUT CONFIGURATION
	MOV	B,A		SAVE COPY IN B FOR FAST REFERENCE
	RRC			TEST FOR INPUT FROM KEYBOARD
	JC	KBD		IF SO, GET CHARACTER FROM KBD
* READ FROM UART
UIN	IN	UCTL		GET UART STATUS
	ANI	2		TEST FOR RECEIVED CHARACTER
	JZ	UIN		IF NOT, WAIT FOR IT
	IN	UDAT		GET DATA FROM UART
	JMP	INEND		PROCESS
* READ FROM KEYBOARD
KBD	IN	KEYBRD		GET KEYBOARD DATA
	RLC			TEST FOR KEY ALREADY PRESSED
	JC	KBD		IF SO, WAIT FOR RELEASE
KBD1	IN	KEYBRD		GET KEYBOARD DATA
	XRI	$80		TEST FOR AND REMOVE STROBE
	JM	KBD1		IF NOT, WAIT FOR A KEY
* PROCESS CHARACTER JUST READ, ACCORDING TO DEFAULTS
INEND	MOV	C,A		SAVE CHARACTER
	CPI	3		TEST FOR CONTROL-C
	MOV	A,B		GET IO CONFIGURATION
	JZ	CTLC		IF CTRL-C, SPECIAL CASE
	ANI	$10		TEST FOR UPPER CASE CONVERSIN
	MOV	A,C		GET CHARACTER BACK
	POP	B		RESTORE B-C PAIR
	RNZ			IF UPPER CASE DISABLED, THEN DON'T CHANGE
	CPI	$61		TEST FOR < LOWER CASE 'A'
	RC			IF SO,  THEN DON'T CHANGE
	CPI	$7B		TEST FOR > LOWER CASE 'Z'
	RNC			IF SO, DON'T CHANGE
	ANI	$5F		CONVERT TO UPPER CASE
	RET
* CONTROL-C, DON'T PASS ON IF CTRL-C IS DISABLED
CTLC	ANI	$20		TEST FOR CONTROL-C DISABLED
	JNZ	INS1		IF SO, GET NEXT CHARACTER
	MOV	A,C		GET CHARACTER BACK
	POP	B		RESTORE B-C
	RET
*
* TEST FOR CTRL-C FROM KEYBOARD. ALSO, IF LINE-FEED IS PRESSED,
* THEN WAIT TILL IT IS RELEASED
*
CTRLC	IN	KEYBRD		GET KEYBOARD DATA
	XRI	$80		TEST AND REMOVE STROBE
	RM			IF NO KEY, QUIT
	CPI	$0A		TEST FOR LINE-FEED
	JZ	CTRLC		IF SO, WAIT TILL RELEASED
	CPI	3		TEST FOR CONTROL-C
	RNZ			IF NOT, DON'T PROCESS
	LDA	IOCON		GET I/O CONFIGURATION
	ANI	$20		TEST FOR CONTROL-C INHIBIT. (Z=0 IF NOT)
	RET
* SET UART COMMAND
UART	CALL	AGET		GET 16 BIT VALUE
*
* INITIALIZES 8251 USART TO VALUE PASSED IN H-L
*
SETURT	MVI	A,3		VALUE TO RESET UART
	OUT	UCTL		MAKE SURE.
	OUT	UCTL		UART IS RESET
	MVI	A,$77		VALUE TO ENTER COMMAND MODE
	OUT	UCTL		ENTER COMMAND MODE
	MOV	A,H		GET HIGH BYTE OF NEW COMMAND WORD
	OUT	UCTL		WRITE TO CONTROL PORT
	MOV	A,L		GET LOW BYTE OF NEW COMMAND WORD
	OUT	UCTL		WRITE TO CONTROL PORT
	RET
* GET'S A 16 BIT VALUE FOR H-L, CY=1 IF EVERYTHING OK
GETHL	CALL	GETBYT		GET FIRST BYTE
	RNC			IF BAD, DON'T WAIT FOR SECOND
	MOV	H,A		SAVE IN HIGH BYTE OF RESULT
	CALL	GETBYT		GET SECOND BYTE
	MOV	L,A		SAVE IN LOW BYTE OF RESULT
	RET
* GETS A BYTE FOR ACC FROM TERMINAL, CY=0 IF FAILS
GETBYT	PUSH	B		SAVE B-C PAIR
	CALL	GETNIB		GEET FIRST NIBBLE
	JNC	RETGB		IF BAD, DON'T WAIT FOR MORE
	RLC			SHIFT INTO.
	RLC			UPPER NIBBLE.
	RLC			OF RESULT.
	RLC			SO WE CAN INSERT LOWER NIBBLE
	MOV	B,A		KEEP HIGH DIGIT IN B
	CALL	GETNIB		GET SECOND DIGIT
	JNC	RETGB		IF BAD, INDICATE SO
	ORA	B		INSERT HIGH DIGIT
	STC			INDICATE SUCESS
RETGB	POP	B		RESTORE B-C PAIR
	RET
* GETS A NIBBLE FROM THE TERMINAL (IN ASCII HEX)
GETNIB	CALL	IN		GET A CHARACTER
	CPI	' '		TEST FOR BLANK (ABORT1)
	RZ			IF SO, RETURN INDICATING BAD (CY=0)
	CPI	$0D		TEST FOR <CR> (ABORT2)
	RZ			IF SO, RETURN INDICATING BAD
	CPI	'0'		TEST FOR INVALID (BELOW '0')
	JC	GETNIB		IF SO, WAIT FOR MORE
	CPI	'G'		TEST FOR INVALID (GREATER THAN 'F')
	JNC	GETNIB		IF SO, IGNORE
	CALL	OUT		DISPLAY CHARACTER
	CPI	$3A		TEST FOR INVALID
	JC	NUMH		IF OK, WE ARE IN
	CPI	'A'		TEST FOR INVALID
	JC	GETNIB		IF BAD, IGNORE
	SUI	7		CONVERT TO DIGIT
NUMH	SUI	$30		CONVERT TO BINARY
	STC			INDICATE SUCESS
	RET
* LOADS A RECORD IN INTEL HEX FORMAT
GETR	MVI	A,$42		INHIBIT OUTPUT, ENABLE UART
	STA	IOCON		SET I/O CONF
	MVI	A,' '		CLEAR VIDEO FLAG
	STA	VIDEO+63	SO WE CAN FLASH A STAR
GET1	CALL	IN		GET CHARACTER FROM TAPE
	CPI	':'		TEST FOR START OF RECORD
	JNZ	GET1		IF NOT, IGNORE
	LDA	VIDEO+63	GET VIDEO SCREEN CONTENTS
	XRI	$0A		CONVERT TO/FROM A STAR
	STA	VIDEO+63	RESAVE VIDEO CONTENTS
	CALL	GETBYT		GET LENGTH
	ANA	A		TEST FOR END OF FILE
	JZ	RSET		IF SO, PROCESS
	MOV	C,A		START CHECKSUM
	MOV	B,A		REMEBMER LENGTH
	CALL	GETHL		GET ADDRESS
	MOV	A,C		GET CHECKSUM
	ADD	H		ADD HIGH BYTE OF ADDRESS
	ADD	L		ADD LOW BYTE OF ADDRESS
	MOV	C,A		RESAVE CHECKSUM
	CALL	GETBYT		GET TYPE BYTE
	ADD	C		ADD TO CHECKSUM
	MOV	C,A		RESAVE CHECKSUM
NEOR	CALL	GETBYT		GET DATA BYTE
	MOV	M,A		SAVE IN MEMORY
	INX	H		POINT TO NEXT LOCATION
	ADD	C		ADD TO CHECKSUM
	MOV	C,A		RESAVE CHECKSUM
	DCR	B		REDUCE COUNT OF REMAINING DATA BYTES
	JNZ	NEOR		IF MORE, KEEP LOADING
	CALL	GETBYT		GET CHECKSUM. (FROM TAPE)
	ADD	C		ADD TO COMPUTED CHECKSUM
	JZ	EIPL		IF OK, END THIS RECORD
	CALL	RSET		CLEAR FLAGS
	LXI	H,ERRMSG	ADDRESS OF '?I/O ERROR' MESSAGE
	CALL	PMSG		PRINT MESSAGE
	ANA	A		INDICATE END OF LOAD
	RET
* INDICATE END OF RECORD, MORE DATA TO FOLLOW (CY=1)
EIPL	CALL	RSET		RESET DEFAULT I/0
	STC			INDICATE MORE DATA
	RET
* RESET I/O CONFIGURATION
RSET	MVI	A,DEFIO		SET TO DEFAULT I/O
	STA	IOCON		SAVE IN I/O CONF
	ANA	A		INDICATE DONE
	RET
ERRMSG	STR	'?I/O ERROR'	ERROR MESSAGE
	DB	$0D
* DISPLAYS MESSAGE ON DISPLAY UP TO A CARRIAGE-RETURN. OR ZERO
PMSG	MOV	A,M		GET CHARACTER FROM MESSAGE
	ANA	A		END OF MESSAGE?
	RZ			IF SO, RETURN
	CALL	OUT		DISPLAY IT
	INX	H		POINT TO NEXT CHAR. IN MESSAGE
	CPI	$0D		TEST FOR CARRIAGE RETURN
	JNZ	PMSG		IF NOT, KEEP DISPLAYING
* DISPLAYS A LINE-FEED, CARRIAGE-RETURN PAIR ON THE VIDEO DISPLAY
NL	MVI	A,$0A		GET LINE-FEED
	CALL	OUT		DISPLAY
	MVI	A,$0D		GET CARRIAGE RETURN
	JMP	OUT		DISPLAY AND RETURN
* LOAD COMMAND
LOAD	CALL	TON		TURN TAPE ON
* DOWNLOAD COMMAND
DNLD	MVI	D,$FF		SET NUMBER OF RECORDS DUMPED TO 255
	CALL	NL		ADVANCE TO A NEW LINE
LODLP	INR	D		ADVANCE NUMBER OF RECORDS DUMPED
	MOV	A,D		GET NUMBER OF RECORDS DUMPED
	CALL	HOUT		DISPLAY ON TERMINAL
	CALL	GETR		GET NEXT RECORD
	RNC			IF END, GET NEXT COMMAND
	MVI	A,$0D		GET CARRIAGE RETURN
	CALL	OUT		BACK UP TO START OF LINE
	JMP	LODLP		GET NEXT RECORD
* POSITIONS CURSOR TO POSITION PASSED IN H-L
CURPOS	PUSH	D		SAVE D-E
	XCHG			SWAP TO D-E
	LHLD	CURSOR		GET OLD CURSOR POSITION
	LDA	LSTCHR		GET LAST CHARACTER
	MOV	M,A		REPLACE IN SCREEN MEMORY
	LXI	H,VIDEO		START OF VIDEO DISPLAY
	DAD	D		OFFSET INTO DISPLAY
	MOV	A,M		GET CHARACTER UNDER NEW CURSOR
	STA	LSTCHR		SAVE IN MEMORY
	MVI	M,$7F		PUT CURSOR ON SCREEN
	SHLD	CURSOR		RESAVE CURSOR POSITION
	POP	D		RESTORE D-E
	RET
* START TAPE DRIVE, AND WAIT
TON	MVI	A,$35		SET FOR TAPE ON
	OUT	UCTL		WRITE TO UART CONTROL
* DELAY, WAITS A FINITE TIME INTERVAL
DELAY	PUSH	H		SAVE H-L
	LXI	H,0		START COUNTING FROM ZERO
DEL1	DCX	H		REDUCE COUNT
	MOV	A,H		GET HIGH VALUE
	ORA	L		TEST FOR ZERO WITH LOW VALUE
	JNZ	DEL1		IF NOT, KEEP COUNTING
	POP	H		RESTORE H-L
	RET
* SHUT'S OFF TAPE DRIVE
TOFF	IN	UCTL		GET UART DATA
	RRC			WAIT FOR XMIT READY
	JNC	TOFF		TO WE DON'T CLOBBER LAST CHAR SENT
	MVI	A,' '		GET A BLANK
	STA	VIDEO+63	INSURE DISPLAYED '*' IS OFF
	MVI	A,$37		SHUT OFF TAPE DRIVE
	OUT	UCTL		TURN IT OFF
	RET
*
* TERMINAL MODE.... SIMULATES A DUMB ASCII TERMNAL
*
TMODE	CALL	IN		GET DATA CHARACTER
	MOV	B,A		SAVE IN B FOR LATER REF
* READ/WRITE TERMINAL AND UART
TWAIT	CALL	CRCVR		TEST UART RECEIVER
	IN	KEYBRD		GET KEYBOARD DATA
	RLC			TEST FOR KEY PRESSED
	JC	TWAIT		IF SO, WAIT TILL RELEASED
KEYIN	CALL	CRCVR		TEST FOR UART DATA RECEIVED
	IN	KEYBRD		GET KEYBOARD DATA
	XRI	$80		TEST AND REMOVE STROBE
	JM	KEYIN		IF NO DATA, WAIT FOR SOME
	RZ			IF NULL (CTRL-@) RETURN TO MONITOR
	OUT	UDAT		WRITE TO UART DATA PORT
	MOV	C,A		SAVE FOR REFERENCE
	MOV	A,B		GET DUPLEX INDICATOR
	CPI	'H'		TEST FOR HALF DUPLEX
	MOV	A,C		GET CHARACTER BACK
	CZ	PCHRS		IF HALD DUP, DISPLAY CHAR
	JMP	TWAIT		WAIT FOR KEY RELEASE
* TEST UART AND DISPLAY AND DATA RECEIVED
CRCVR	IN	UCTL		GET UART STATUS
	ANI	2		TEST FOR RX READY
	RZ			IF NOT, FORGET IT
	IN	UDAT		GET UART DATA
PCHRS	CPI	$0D		TEST FOR CARRIAGE RETURN
	JZ	OUT		OK TO DISPLAY
	CPI	$0A		TEST FOR LINE-FEED
	JZ	OUT		OK TO DISPLAY
	CPI	$08		TEST FOR BACK-SPACE
	JZ	OUT		OK TO DISPLAY
	CPI	$7F		TEST FOR DELETE CHARACTER
	RZ			NOT OK TO DISPLAY
	CPI	' '		TEST FOR CONTROL CHARACTERS
	JNC	OUT		ONLY DISPLAY DISPLAYABLE CHARACTERS
	RET
