
/************************************************************************
 *																								*
 *		D51 8051/52 Disassembler - Copyright (C) 1995-1996 by					*
 *		Jeffery L. Post																	*
 *		22726 Benner Ave.																	*
 *		Torrance, CA  90505																*
 *																								*
 *		D51.H - Header File																*
 *																								*
 *		Version 2.4 - 08/18/96															*
 *																								*
 *	This program is free software; you can redistribute it and/or modify	*
 *	it under the terms of the GNU General Public License as published by	*
 *	the Free Software Foundation; either version 2 of the License, or		*
 *	(at your option) any later version.												*
 *																								*
 *	This program is distributed in the hope that it will be useful,		*
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of			*
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *	GNU General Public License for more details.									*
 *																								*
 *	You should have received a copy of the GNU General Public License		*
 *	along with this program; if not, write to the Free Software				*
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.				*
 *																								*
 ************************************************************************/

#define	MSDOS		/* Uncomment this for machines with segmented CPU
							architectures. For intelligently designed CPUs,
							we can use malloc instead of farmalloc for 64K
							byte arrays. */

/*#define	LINUX*/		/* Linux has no stricmp library function, must use
							strcasecmp instead. */

/*-----------------------------------------------------------------------

  Command line options:

	D - Generate comment field with address and data values.

	B - Force binary source file.

	H - Force hex source file.

	S - Change 'db' and 'dw' strings to 'defb' and 'defw'

	X - Add hexadecimal constant to program addresses.

	A - Change db/defb to ascii macro for text

-------------------------------------------------------------------------

  Control codes allowed in the CTL file:

	A - Address			Specifies that the word entry is the address of
							something for which a label should be generated.

	B - Byte binary	Eight bit binary data (db).

	C - Code				Executable code.

	F - SFR label		Specify name for SFR.

	I - Ignore			Treat as uninitialized space. Will not be dis-
							assembled as code or anything else.

	K - SFR bit			Specify name for SFR bit.

	L - Label			Generate a label for an address.

	R - Register		Specify name for register (instead of rb2r5 for example).

	S - Symbol			Generate a symbol for a value.

	T - Text				ASCII text (db or ascii macro).

	W - Word binary	Sixteen bit binary data (dw).

	The difference between labels and symbols is that a label refers
	to a referenced address, whereas a symbol may be used for 8 or 16
	bit immediate data. For some opcodes (eg: mov r2,#xx) only the symbol
	table will be searched. Other opcodes (eg: mov dptr,#) will search
	the label table first and then search the symbol table only if the
	value is not found in the label table.

-------------------------------------------------------------------------

  Exit codes:

	0 - No error (good disassembly)

	1 - Insufficient memory

	2 - File error (source file not found, or disk full)

	3 - Error in control file

-------------------------------------------------------------------------

	Definition of pflg bits:	pflg = 0xff if not initialized.
										pflg = 0 when initialized by input file.

	bit 7		set if uninitialized space.
	bit 6		address data
	bit 5		word binary data
	bit 4		byte binary data
	bit 3		clear if address is referenced (see bit 0)
	bit 2		ascii text
	bit 1		set if split opcode
	bit 0		set if address is referenced (see bit 3)

	Two bits (3 and 0) are needed to flag a referenced address because
		such a reference could be to initialized or uninitialized code
		space. If we used a single bit, we could not distinguish between
		a reference and uninitialized space. Bit 3 set with bit 0 clear
		indicates that the control file has specified this area as code.

-------------------------------------------------------------------------

	Definition of option table bits:

	bit 7		unconditional transfer instruction (jmp, ret, etc)
	bit 6		11 bit addressing mode
	bit 5		relative addressing mode
	bit 4		bit addressing mode
	bit 3		direct addressing mode
	bit 2		immediate data
	bit 1		3 byte instruction
	bit 0		2 byte instruction

	option table entry = 0 if single byte opcode with no options.

-------------------------------------------------------------------------*/

#define	VERNO		2
#define	REVNO		4

#define	byte		unsigned char
#define	word		unsigned short

#define	TSTOP		32								/* tab stop */
#define	ASTOP		56								/* ascii stop */
#define	XSTOP		49								/* hex stop */

#define	PMEMSIZE	((unsigned long) 65536)	/* code space for 8051/2 */

#define	EITHERFILE	0
#define	HEXFILE		1
#define	BINFILE		2

#define	GOOD_EXIT	0
#define	MEM_ERROR	1
#define	FILE_ERROR	2
#define	USER_ERROR	3

#define	SYMBOL		0
#define	LABEL			1

#define	ASCLINE		32		/* max length of ascii defb line		*/
#define	ASCLIMIT		512	/* size of ascii buffer					*/
#define	BYTELINE		8		/* max length of binary defb line	*/
#define	BYTELIMIT	512	/* size of byte binary buffer			*/
#define	WORDLINE		6		/* max length of defw line				*/
#define	WORDLIMIT	512	/* size of word binary buffer			*/
#define	NO_DATA		0xff	/* pmem uninitialized value			*/

/* pflg bits: */

#define	PF_INIT		0xff	/* initial value					*/
#define	PF_DATA		0x00	/* data valid from file			*/
#define	PF_NOINIT	0x80	/* set if uninitialized space	*/
#define	PF_ADRS		0x40	/* address data					*/
#define	PF_WORD		0x20	/* word binary data				*/
#define	PF_BYTE		0x10	/* byte binary data				*/
#define	PF_CLREF		0x08	/* clear if referenced			*/
#define	PF_ASCII		0x04	/* ascii text						*/
#define	PF_SPLIT		0x02	/* set if split opcode			*/
#define	PF_REF		0x01	/* set if referenced				*/

/* opttbl bits: */

#define	OPT_XFER		0x80	/* unconditional transfer		*/
#define	OPT_11		0x40	/* 11 bit addressing				*/
#define	OPT_REL		0x20	/* relative addressing			*/
#define	OPT_BIT		0x10	/* bit addressing					*/
#define	OPT_DIR		0x08	/* direct addressing				*/
#define	OPT_IMM		0x04	/* immediate data					*/
#define	OPT_3			0x02	/* 3 byte instruction			*/
#define	OPT_2			0x01	/* 2 byte instruction			*/

#define	OPT_MASK	(~OPT_XFER)				/* options mask					*/
#define	OPT_NONE	0							/* single byte, no options		*/
#define	OPT_SIZE	(OPT_3   | OPT_2)		/* additional byte count		*/
#define	OPT_LREF	(OPT_IMM | OPT_3)		/* ljmp, lcall or mov dptr		*/
#define	OPT_IMM2	(OPT_IMM | OPT_2)		/* 2 byte immediate data		*/
#define	OPT_DIR2	(OPT_DIR | OPT_2)		/* 2 byte direct adrs			*/
#define	OPT_DIR3	(OPT_DIR | OPT_3)		/* 3 byte direct adrs			*/
#define	OPT_DMM3	(OPT_DIR | OPT_IMM | OPT_3)	/* 3 byte dir & imm	*/
#define	OPT_BIT2	(OPT_BIT | OPT_2)		/* 2 byte bit adrs				*/
#define	OPT_REL2	(OPT_REL | OPT_2)		/* 2 byte relative adrs			*/
#define	OPT_IR3	(OPT_REL | OPT_IMM | OPT_3)	/* 3 byte rel & imm	*/
#define	OPT_DR3	(OPT_REL | OPT_DIR | OPT_3)	/* 3 byte rel & dir	*/
#define	OPT_RELB	(OPT_REL | OPT_BIT | OPT_3)	/* 3 byte rel & bit	*/
#define	OPT_112	(OPT_11  | OPT_2)		/* 2 byte 11 bit adrs			*/

/* symbol table and label table entries */

struct sym {
	struct sym	*next;
	word			val;
	byte			used;
	char			name[1];
};

typedef	struct sym *	SYM_PTR;

/* mnemonic table entries */

struct mnementry {
   char mcode[16];
};

/* special function register name entries */

struct sfrent {
   char dent[8];
};

/* end of d51.h */

