
/************************************************************
 *																				*
 *								SRCCAPS.C									*
 *																				*
 *		Utility to convert assembly source code to all caps	*
 *																				*
 ************************************************************/

#include	<stdio.h>
#include	<ctype.h>

#define	comment	';'

FILE	*fpi;
FILE	*fpo;
char	bfr[256];

main(int argc, char *argv[])
{
	int	i;

	if(argc < 3)
	{
		printf("\nUsage: srccaps file.in file.out\n");
		exit(1);
	}
	fpi = fopen(argv[1], "rt");
	if (fpi == NULL)
	{
		printf("Can't open '%s'\n", argv[1]);
		exit(1);
	}
	fpo = fopen(argv[2], "wt");
	if (fpi == NULL)
	{
		printf("Can't open '%s'\n", argv[2]);
		exit(1);
	}
	while (fgets(bfr, 255, fpi))
	{
		i = 0;
		while (bfr[i])
		{
			if (bfr[i] == comment)
				break;
			if (islower(bfr[i]))
				bfr[i] = toupper(bfr[i]);
			i++;
		}
		fputs(bfr, fpo);
	}
	fclose(fpi);
	fclose(fpo);
}

/* end of srccaps.c */

