/*
 * General purpose user interface shell which supports both
 * command line and interactive execution modes.
 *
 * Copyright 1991-1997 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc shell -fop
 */
#include <stdio.h>

#define	ARG_NUM		50		/* Maximum number of command arguments */
#define	ARG_POOL	500		/* Memory reserved for prompt strings */

/* Table of command names */
char *commands[] = {
	"quit", "help"
	/* Add additional command names here */
	};

/* Help display text */
char *help[] = {
	"SHELL commands:\n"
	/* Add HELP text here */
	};

/* Command shell internal variables */
	int argc, argt;
	char *argv[ARG_NUM], argp[ARG_POOL], *optr;
	
/*
 * Process command from operand or command line
 */
main(ac, av)
	int ac;
	int *av[];
{
	int i;
	char cmdline[100];

	if(!ac)
		abort("Use: shell <options>\n");

	argc = 0;
	for(i=1; i < ac; ++i) switch(*av[i]) {
/*** Parse main program command line options here ***/
		default: argv[argc++] = av[i]; }

	if(argc)				/* Command line mode */
		command();
	else for(;;) {			/* Interactive mode */
		fputs("SHELL> ", stdout);
		fflush(stdout);
		if(!fgets(optr = cmdline, sizeof(cmdline)-1, stdin))
			exit(0);
		argc = 0;
		while(skip_blank()) {
			argv[argc++] = optr;
			while(*optr && !isspace(*optr))
				++optr;
			if(*optr)
				*optr++ = 0; }
		if(!argc)
			continue;
		command(); }
}

/* Skip to next non-blank */
skip_blank()
{ while(isspace(*optr)) ++optr; return *optr; }

/* Match partial string */
match(s1, s2) char *s1, *s2;
{ do if(!*s2) return -1; while(*s1++ == *s2++); return 0; }

/* Get argument 'n'. If argument does not exist, issue prompt */
/* Return with 0 if no entry. */
getarg(n, prompt)
	int n;
	char *prompt;
{
	char buffer[50];

	if(!argv[n]) {
		argv[n] = &argp[argt];
		fprintf(stdout,"%s? ", prompt);
		fflush(stdout);
		if(!fgets(optr = buffer, sizeof(buffer)-1, stdin))
			exit(0);
		if(!skip_blank())
			return -1;
		do
			argp[argt++] = *optr;
		while(*optr++); }
	return 0;
}

/*
 * User program command processor
 */
command()
{
	int i, j;

	j = -1;
	for(i=argc; i < ARG_NUM; ++i)			/* Zero remaining arguments */
		argv[i] = 0;
	for(argt=i=0; i < sizeof(commands)/2; ++i)	/* Lookup command in table */
		if(match(commands[i], *argv)) {
			if(j != -1) {
				fputs("SHELL: Ambiguous command.\n", stderr);
				return; }
			j = i; }
	switch(j) {								/* Execute command */
		case 0 : exit(0);					/* Exit */
		case 1 :							/* Help */
			for(i=0; i < sizeof(help)/2; ++i)
				fprintf(stdout,"%s\n", help[i]);
			break;
/** Insert additional command handlers here ***/
		default: fputs("SHELL: Unknown command.\n", stderr); }
}
