/*
 * Simple utility to redirect stderr to a file while running a command.
 *
 * Copyright 1995-1997 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted to use for personal (non-commercial) use only.
 *
 * Compile command: cc rerror -pof
 */
#include <stdio.h>
#include <file.h>

char help_message[] = { "\n\
Use: rerror filename command...\n\n\
Redirects the DOS standard error device to the indicated file while\n\
the command runs, effectively capturing any error output from the\n\
command to the file.\n\n\
Copyright 1995-1997 Dave Dunfield\n\
All rights reserved.\n" };

main(int argc, char *argv[])
{
	int i;
	char command[256], *ptr;
	HANDLE fh1, fh2;

	/* Test for filename and at least one command argument */
	if(argc < 3)
		abort(help_message);

	/* Open the output file - report error if failure */
	if(!(fh1 = open(argv[1], F_WRITE)))
		abort("\nRERROR: Unable to open output file\n");

	/* Concatinate multiple arguments into a single command line */
	ptr = stpcpy(command, argv[i = 2]);
	while(++i < argc) {
		*ptr++ = ' ';
		ptr = stpcpy(ptr, argv[i]); }

	fh2 = dup(stderr.FILE_handle);		/* Make copy of stderr */
	dup2(fh1, stderr.FILE_handle);		/* Redirect stderr to file */
	system(command);					/* Execute a command */
	dup2(fh2, stderr.FILE_handle);		/* Restore original stderr file */
	close(fh1);							/* Close output file */
	close(fh2);							/* Close duplicate handle */
}
