/*
 * Program to display a file assuming tab stops are at 4 character
 * Intervals. By redirecting the output from this program to the
 * printer, you may properly print the MICRO-C listings.
 *
 * In MICRO-C, the operation "a && b" is defined as returning zero
 * without evaluating "b" if "a" evaluates to zero, otherwise "b"
 * is evaluated and returned.
 *
 * The statement "j = (chr != '\n') && j+1" shows how && (or ||) may
 * be used to create a very efficent conditional expression in MICRO-C.
 * NOTE that this is not "standard", and is NOT PORTABLE. The more
 * conventional equivalent is: "j = (chr != '\n') ? j+1 : 0"
 *
 * Copyright 1989-1997 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc type4 -fop
 */
#include <stdio.h>

#define TAB_SIZE	4		/* tab spacing */

main(argc, argv)
	int argc;
	char *argv[];
{
	int i, j, chr;
	FILE *fp;

	if(argc < 2)
		abort("\nUse: type4 <filename*>\n");

/* Set output to buffered for higher speed */
	stdout = setbuf(stdout, 512);

	for(i=1; i < argc; ++i) {
		if(fp = fopen(argv[i], "rv")) {
			j = 0;
			while((chr = getc(fp)) != EOF) {
				if(chr == '\t') {			/* tab */
					do
						putc(' ', stdout);
					while(++j % TAB_SIZE); }
				else {						/* not a tab */
					j = (chr != '\n') && j+1;	/* see opening comment */
					putc(chr, stdout); } }
			fclose(fp); } }
	fflush(stdout);
}
