/*
 * Removes IBM/PC ASCII-Graphics characters, and substitutes standard
 * ASCII characters in their place.
 *
 * Copyright 1992-1997 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted to use for personal (non-commercial) use only.
 *
 * Compile command: cc ungraph -pof
 */
#include <stdio.h>

main(int argc, char *argv[])
{
	int c;
	FILE *fpi, *fpo;

	if(argc < 3)
		abort("\nUse: ungraph old new\n\nCopyright 1992-1997 Dave Dunfield\nAll rights reserved.\n");

	fpi = fopen(argv[1], "rvqb");
	fpo = fopen(argv[2], "wvqb");

	for(;;) {
		switch(c = getc(fpi)) {
			case EOF :
				fclose(fpi);
				fclose(fpo);
				return;
			case 0xB3 :	// Single vertical bar
			case 0xBA :	// Double vertical bar
				c = '|';
				break;
			case 0xC4 : // Single horizontal bar
			case 0xCD :	// Double horizontal bar
				c = '-';
				break;
			default:
				if((c >= 0xB3) && (c <= 0xDA))
					c = '+'; }
		putc(c, fpo); }
}
