/*
 * Kids Menu EDITor
 *
 * Copyright 1993-1997 Dave Dunfield
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc kmedit -fop
 */
#include <stdio.h>
#include <window.h>

#define	MAXPACK	27

unsigned active = 0;

unsigned char itext[8][6], iattr[8][6], idir[50], icmd[50], attr = 07;

unsigned char Itext[MAXPACK][8][6], Iattr[MAXPACK][8][6],
	Idir[MAXPACK][50], Icmd[MAXPACK][50], ifile[50];

char *form1[] = {
	70<<8|6,
	"\x01\x01\x31Directory:",
	"\x01\x02\x31Command  :",
	0 };

char *form2[] = {
	40<<8|5,
	"\x01\x01\x82Entry number:",
	0 };

char *keytext[] = {
	"F1   - Select  graphic character",
	"F2   - Insert last  graphic char",
	"F3   - 'pick up'  a graphic char",
	"F4   - Set new directory/command",
	"F5   - Select new attribute",
	"F6   - Change attribute at cursor",
	"F7   - 'pick up' an attribute",
	"F8   - Change ALL attributes",
	"F9   - Select entry by number",
	"F10  - Copy another entry",
	"Home - Arrange positions",
	"ESC  - Exit program",
	"PgUp - Select next entry",
	"PgDn - Select previous entry",
	0 };

char htext[] = {
"Kids Menu EDITor - Copyright 1993-1997 Dave Dunfield, Freely distributable.\n\n\
Use: KMEDIT [file]\n\n\
for Bethany and Michael.\n" };

struct WINDOW *MAIN, *ICON;

/*
 * Main program
 */
main(argc, argv)
	int argc;
	char *argv[];
{
	unsigned c, l, x, y;
	char *ptr;
	FILE *fp;

	get_name(ifile, (argc > 1) ? argv[1] : "KIDSMENU", ".DAT");

	memset(Itext, ' ', sizeof(Itext));
	memset(Iattr, attr = NORMAL, sizeof(Iattr));
	memset(Idir, 0, sizeof(Idir));
	memset(Icmd, 0, sizeof(Icmd));

	if(fp = fopen(ifile, "rvb")) {
		x = 0;
		do {
			y =  fget(Itext[x], sizeof(itext), fp);
			y += fget(Iattr[x], sizeof(iattr), fp);
			y += fget(Idir[x] , sizeof(idir ), fp);
			y += fget(Icmd[x] , sizeof(icmd ), fp);
			++x; }
		while(y == (sizeof(itext)+sizeof(iattr)+sizeof(idir)+sizeof(icmd)));
		fclose(fp); }

	MAIN = wopen(0, 0, 80, 25, WSAVE|WCOPEN|WBOX1|NORMAL);
	for(x=0; ptr = keytext[x]; ++x) {
		wgotoxy(34, x+5);
		wputs(ptr); }

	ICON = wopen(10, 6, 14, 10, WBOX1|WCOPEN|NORMAL);

load:
	load_icon(active);

	x = y = 0;

newtext:
	w_gotoxy(5, 1, MAIN);
	w_printf(MAIN, "Number   : %-5u", active+1);
	w_gotoxy(5, 2, MAIN);
	w_printf(MAIN, "Directory: %-50s", idir);
	w_gotoxy(5, 3, MAIN);
	w_printf(MAIN, "Command  : %-50s", icmd);
	w_gotoxy(12, 18, MAIN);
	*MAIN = attr;
	w_puts("* TEST *", MAIN);
	*MAIN = NORMAL;
	for(;;) {
		draw_icon(2, 1, itext, iattr);
		wgotoxy(x+2, y+1);
		switch(c = wgetc()) {
			case _KUA :	y = y ? y-1 : 5;		break;
			case _KDA :	y = (y < 5) ? y+1 : 0;	break;
			default :
				itext[x][y] = c;
				iattr[x][y] = attr;
			case _KRA :	x = (x < 7) ? x+1 : 0;	break;
			case _KLA :	x = x ? x-1 : 7;		break;
			case _K5  :	
				if(get_attr())
					iattr[x][y] = attr;			goto newtext;
			case _K6  :	iattr[x][y] = attr;		break;
			case _K7  :	attr = iattr[x][y];		goto newtext;
			case _K3  :	l = itext[x][y];		break;
			case _K8  :
				memset(iattr, attr, sizeof(iattr));
				break;
			case _K4  :
				wform(5, 10, WSAVE|WBOX2|WCOPEN|REVERSE, form1, idir, icmd);
				goto newtext;
			case _K1 :
				if((c = get_char()) & 0xFF00)
					break;
				goto plunk;
			case _K2 :
				c = l;
			plunk:
				itext[x][y] = l = c;
				iattr[x][y] = attr;
				break;
			case _K9 :
				save_icon(active);
				c = active + 1;
				wform(10, 10, WSAVE|WCOPEN|WBOX2|REVERSE, form2, &c);
				if(--c < MAXPACK)
					active = c;
				goto load;
			case _K10 :
				save_icon(active);
				c = 0;
				wform(10, 10, WSAVE|WCOPEN|WBOX2|REVERSE, form2, &c);
				if(--c < MAXPACK)
					load_icon(c);
				break;
			case _KPU :
				save_icon(active);
				active = (active < (MAXPACK-1)) ? active + 1 : 0;
				goto load;
			case _KPD :
				save_icon(active);
				active = active ? active - 1 : MAXPACK - 1;
				goto load;
			case _KHO :
				save_icon(active);
				arrange();
				goto load;
			case 0x1B :
				save_icon(active);
				if(yesno("Save file")) {
					fp = fopen(ifile, "wvqb");
					for(x = 0; x < MAXPACK; ++x) {
						if(test_icon(x)) {
							fput(Itext[x], sizeof(itext), fp);
							fput(Iattr[x], sizeof(iattr), fp);
							fput(Idir [x], sizeof(idir ), fp);
							fput(Icmd [x], sizeof(icmd ), fp); } }
					fclose(fp); }
				if(yesno("Exit Program")) {
					wclose();
					wclose();
					fputs(htext, stdout);
					return; } } }
}

/*
 * Load a saved ICON
 */
load_icon(inum)
	int inum;
{
	memcpy(itext, Itext[inum], sizeof(itext));
	memcpy(iattr, Iattr[inum], sizeof(iattr));
	memcpy(idir , Idir [inum], sizeof(idir ));
	memcpy(icmd , Icmd [inum], sizeof(icmd ));
}

/*
 * Save the ICON permanenthy
 */
save_icon(inum)
	int inum;
{
	memcpy(Itext[inum], itext, sizeof(itext));
	memcpy(Iattr[inum], iattr, sizeof(iattr));
	memcpy(Idir [inum], idir , sizeof(idir ));
	memcpy(Icmd [inum], icmd , sizeof(icmd ));
}

/*
 * Test to see if an ICON is blank
 */
test_icon(inum)
	int inum;
{
	int i;
	char *ptr;
	if(*Idir[inum] || *Icmd[inum])
		return -1;
	ptr = Itext[inum];
	for(i=0; i < sizeof(itext); ++i)
		if(*ptr++ != ' ')
			return -1;
	return 0;
}

/*
 * Display the ICON
 */
draw_icon(x, y, text, attr)
	unsigned x, y;
	unsigned char text[8][6], attr[8][6];
{
	int x1, y1;

	for(y1=0; y1 < 6; ++y1) {
		wgotoxy(x, y+y1);
		for(x1 = 0; x1 < 8; ++x1) {
			*W_OPEN = attr[x1][y1];
			wputc((unsigned)text[x1][y1] | 0x0100); } }
}

/*
 * Get forground\background color
 */
get_attr()
{
	int c, f, b;
	b = attr >> 4;
	f = attr & 0x0F;

	for(;;) {
		wopen(7, 17, 20, 5, WSAVE|WCOPEN|WBOX2|NORMAL);
		wprintf("Forground: %u\nBackground: %u\n", f, b);
		*W_OPEN = (b << 4) | f;
		wputs(" * TEST * ");
		c = wgetc();
		wclose();
		switch(c) {
			case _KUA :
				f = (f < 15) ? f+1 : 0;
				break;
			case _KDA :
				f = f ? f-1 : 15;
				break;
			case _KRA :
				b = (b < 15) ? b+1 : 0;
				break;
			case _KLA :
				b = b ? b-1 : 15;
				break;
			case '\n' :
				attr = (b << 4) | f;
				return -1;
			case 0x1B :
				return 0; } }
}

/*
 * Choose character
 */
get_char()
{
	unsigned char i;
	static unsigned char ch = 0;

	wopen(50, 1, 9, 23, WSAVE|WCOPEN|WBOX3|NORMAL);

	for(;;) {
		for(i=0; i < 21; ++i) {
			wgotoxy(0, i);
			*W_OPEN = (i == 10) ? REVERSE : NORMAL;
			wprintf(" %02x -", i + ch);
			*W_OPEN = NORMAL;
			wputc(' ');
			if(i == 10)
				*W_OPEN = attr;
			wputc((unsigned)(i+ch) | 0x0100); }
		switch(wgetc()) {
			case _KUA :	--ch;		break;
			case _KDA : ++ch;		break;
			case _KPU :	ch -= 20;	break;
			case _KPD :	ch += 20;	break;
			case _KHO :	ch = -10;	break;
			case _KEN :	ch = 0x76;	break;
			case 0x1B :
				wclose();
				return -1;
			case '\n' :
				wclose();
				return ch+10; } }
}

/*
 * Prompt for YES/NO response
 */
yesno(ptr)
	char *ptr;
{
	int i;

	i = strlen(ptr)+6;
	wopen((80-i)/2, 10, i, 3, WSAVE|WBOX3|WCOPEN|REVERSE);
	wprintf("%s ? Y", ptr);
	for(;;) switch(toupper(wgetc())) {
		case 'N' :
		case 0x1B :
			wclose();
			return 0;
		case '\n' :
		case 'Y' :
			wclose();
			return 1; }
}

/*
 * Arrange the ICON's
 */
arrange()
{
	int i, x, y, max_icon;
	unsigned v1, v2;

	for(max_icon = 0; (max_icon < MAXPACK) && test_icon(max_icon); ++max_icon);
	for(i = max_icon+1; i < MAXPACK; ++i) {
		if(test_icon(i)) {
			load_icon(i);
			save_icon(max_icon++); } }
		
	wopen(0, 0, 80, 25, WSAVE|WCOPEN|NORMAL);
	wcursor_off();
	wgotoxy(0, 24);
	wprintf("nn SPACE nn ENTER to exchange, ESC to exit.");

redraw:
	/* Draw the ICONs */
	for(i=x=y=0; i < max_icon; ++i) {
		draw_icon(x, y, Itext[i], Iattr[i]);
		*W_OPEN = NORMAL;
		wgotoxy(x+3, y+6);
		wprintf("%2u", i+1);
		if((x += 9) > 79) {
			x = 0;
			y += 8; } }

	v1 = v2 = 0;
	for(;;) {
		wgotoxy(77, 24);
		wprintf("%-2u", v1);
		switch(i = wgetc()) {
			case 0x1B :
				wclose();
				return;
			case '\n' :
				if(v1 && v2) {
					if((v1 - 1) >= max_icon)
						break;
					--v2;
					load_icon(--v1);
					memcpy(Itext[v1], Itext[v2], sizeof(itext));
					memcpy(Iattr[v1], Iattr[v2], sizeof(iattr));
					memcpy(Idir [v1], Idir [v2], sizeof(idir ));
					memcpy(Icmd [v1], Icmd [v2], sizeof(icmd ));
					save_icon(v2); }
				v1 = v2 = 0;
				wclwin();
				goto redraw;
			case '0' :
			case '1' :
			case '2' :
			case '3' :
			case '4' :
			case '5' :
			case '6' :
			case '7' :
			case '8' :
			case '9' :
				v1 = ((v1 % 10) * 10) + (i - '0');
				break;
			case ' ' :
				if((v1 - 1) < max_icon) {
					wgotoxy(77-16, 24);
					wprintf("Exchange %-2u and ", v2 = v1);
					v1 = 0; } } }
}

/*
 * Get a filename with extension only if necessary
 */
get_name(dest, name, ext)
	char *dest, *name, *ext;
{
	char c, flag;

	flag = -1;
	while(*dest = c = *name++) {
		++dest;
		if(c == '.')
			flag = 0; }

	if(flag)
		while(*dest++ = *ext++);
}
