DECLARE SUB LoadBin (Chan%, Which%, BufSize%)
DEFINT A-Z

' PP.BAS : Serial mode PIC16C84 Programmer
'
' 16C84 programmer written in QBasic.  The program prompts for
' all input (defaults can be taken by typing ENTER).  Don't
' be alarmed if your PC makes a noise when programming; this
' is a consequence of the loopy way the programming delay
' is produced.  This program is more or less based on pp.c V-0.3.
' See the C source for more details.
'
' Copyright (C) 1994 David Tait.
' This program is free software.  Permission is granted to use,
' copy, or redistribute this program so long as it is not sold
' for profit.
'
' THIS PROGRAM IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
' EXPRESSED OR IMPLIED.

DECLARE SUB AskFuses ()
DECLARE SUB GetInput (Query$, DefVal$, a$)
DECLARE FUNCTION Yes% (a$)
DECLARE SUB Setup ()
DECLARE SUB LoadHex (Chan%, Which%, BufSize%)
'DECLARE SUB LoadBin (Chan%, Which%, BufSize%)
DECLARE FUNCTION HexByte% (Chan%)
DECLARE FUNCTION HexDigit% (Chan%)
DECLARE SUB OpenHex (Chan%, File$)
DECLARE FUNCTION HexWord% (Chan%)
DECLARE SUB PrgDly ()
DECLARE SUB VppDly ()
DECLARE FUNCTION LptAddr% (LptNum%)
DECLARE SUB ProgramAll ()
DECLARE SUB Quit (ErrNum%, Wanted%, Got%, Addr%)
DECLARE SUB OutWord (word%)
DECLARE FUNCTION InWord% ()
DECLARE SUB ProgMode ()
DECLARE SUB Command (Cmd%)
DECLARE SUB UserInput ()
DECLARE SUB EraseAll ()
DECLARE SUB Program (Which%)
DECLARE SUB Verify (Which%)
DECLARE SUB Config ()
DECLARE SUB IdleMode ()

CONST TRUE = -1, FALSE = 0

CONST Bcolor = 9, Fcolor = 7, Scolor = 0
' This is OK for Mono screens.
' CONST Bcolor = 0, Fcolor = 7, Scolor = 0

' LPT port bit assignments

CONST DataIn = 64

' ONLY use these if H/W uses 74xx07 and 4066 replaced with NPN

CONST DataInv = 0
CONST VppOn = 0, VppOff = 8, VddOn = 0, VddOff = 4
CONST ClkHi = 2, ClkLo = 0, OutHi = 1, OutLo = 0

' ONLY use these if H/W uses 74xx07

' CONST DataInv = 0
' CONST VppOn = 8, VppOff = 0, VddOn = 4, VddOff = 0
' CONST ClkHi = 2, ClkLo = 0, OutHi = 1, OutLo = 0

' ONLY use these if H/W uses 74xx06

' CONST DataInv = DataIn
' CONST VppOn = 0, VppOff = 8, VddOn = 0, VddOff = 4
' CONST ClkHi = 0, ClkLo = 2, OutHi = 0, OutLo = 1

CONST p0000 = VppOff + VddOff + ClkLo + OutLo
CONST p0100 = VppOff + VddOn + ClkLo + OutLo
CONST p0101 = VppOff + VddOn + ClkLo + OutHi
CONST p1100 = VppOn + VddOn + ClkLo + OutLo
CONST p1101 = VppOn + VddOn + ClkLo + OutHi
CONST p1110 = VppOn + VddOn + ClkHi + OutLo
CONST p1111 = VppOn + VddOn + ClkHi + OutHi

' 16C84 serial programming commands

CONST LdConf = 0, LdProg = 2, RdProg = 4, IncAdd = 6
CONST BegPrg = 8, LdData = 3, RdData = 5

CONST Progmem = 0, DataMem = 1, ProgSize = 1024, DataSize = 64

CONST CP = 16, PWRTE = 8, WDTE = 4
CONST RC = 3, HS = 2, XT = 1, LP = 0

CONST INHX16 = 16, INHX8M = 8

CONST ProgName = "PIC16C84 Programmer"
CONST Version = "1.00"  ' i.e. based on pp.bas V-0.3
CONST Date = "04-Maj-1995"
CONST Copyright = "Copyright (C) 1995 Keld Damsbo."
CONST Email = "keld.damsbo@xxx.xx.dk"

CONST ERRPRG = 0, ERRVER = 1, ERRLPT = 2, ERRFSE = 3, ERRHEX = 4
CONST ERRFIL = 5, ERRNOF = 6, ERRHWF = 7

' Global variables

DIM SHARED ProgBuf(0 TO ProgSize - 1)
DIM SHARED DataBuf(0 TO DataSize - 1)

DIM SHARED LptPort, Check, hextype, Fuses
DIM SHARED ProgLoaded, DataLoaded


Main:

  Fuses = 0
  Check = 0
  hextype = INHX16
  ProgLoaded = FALSE
  DataLoaded = FALSE

  UserInput
  ProgramAll
  END


TrapFile:
  IF ERR = 53 THEN Quit ERRFIL, 0, 0, 0
  RESUME NEXT

TrapOverflow:
  IF ERR = 6 THEN Quit ERRHEX, 0, 0, 0
  RESUME NEXT

SUB AskFuses
  Fuses = 0
  GetInput "Osc: LP, XT, HS or RC            ", "HS", a$
  SELECT CASE a$
    CASE "LP", "lp": Osc = LP
    CASE "XT", "xt": Osc = XT
    CASE "HS", "hs": Osc = HS
    CASE "RC", "rc": Osc = RC
    CASE ELSE: Osc = HS
  END SELECT
  Fuses = Osc + CP
  GetInput "Enable watchdog timer (Y/N)       ", "N", a$
  IF Yes(a$) THEN Fuses = Fuses + WDTE
  GetInput "Enable power-up timer (Y/N)       ", "N", a$
  IF Yes(a$) THEN Fuses = Fuses + PWRTE
  GetInput "Enable Code Protection (Y/N)      ", "N", a$
  IF Yes(a$) THEN Fuses = Fuses - CP
END SUB

SUB Command (Cmd%)
   OUT LptPort, p1100 'VppOn + VddOn + ClkLo + OutLo
   BitPos = 1
   DO WHILE BitPos <= 32
     IF (Cmd AND BitPos) THEN
       OUT LptPort, p1111 'VppOn + VddOn + ClkHi + OutHi
       OUT LptPort, p1101 'VppOn + VddOn + ClkLo + OutHi
     ELSE
       OUT LptPort, p1110 'VppOn + VddOn + ClkHi + OutLo
       OUT LptPort, p1100 'VppOn + VddOn + ClkLo + OutLo
     END IF
     BitPos = BitPos * 2
   LOOP
   OUT LptPort, p1101 'VppOn + VddOn + ClkLo + OutHi
END SUB

SUB Config
  ProgMode
  Command LdConf
  OutWord Fuses
  FOR i = 1 TO 7
    Command IncAdd
  NEXT i
  Command LdProg
  OutWord Fuses
  Command BegPrg
  PrgDly
  Command RdProg
  f = InWord% AND &H1F
  IF Fuses <> f THEN Quit ERRFSE, Fuses, f, 0
END SUB

SUB EraseAll
  ProgMode
  Command LdConf
  OutWord &H3FFF
  FOR i = 0 TO 6
    Command IncAdd
  NEXT i
  Command 1
  Command 7
  Command BegPrg
  PrgDly
  Command 1
  Command 7
END SUB

SUB GetInput (Query$, DefVal$, a$)
  PRINT Query$; " ("; DefVal$; ") ";
  INPUT a$
  IF LEN(a$) = 0 THEN a$ = DefVal$
END SUB

FUNCTION HexByte% (Chan)
  b = HexDigit%(Chan)
  b = 16 * b + HexDigit%(Chan)
  Check = Check + b
  HexByte% = b
END FUNCTION

FUNCTION HexDigit% (Chan%)
  d = ASC(INPUT$(1, #Chan))
  IF d > ASC("9") THEN d = d - ASC("A") + 10 ELSE d = d - ASC("0")
  IF (d < 0) OR (d > 15) THEN Quit ERRHEX, 0, 0, 0
  HexDigit% = d
END FUNCTION

FUNCTION HexWord% (Chan)
  w = HexByte%(Chan)
  w = 256 * w + HexByte%(Chan)
  HexWord% = w
END FUNCTION

SUB IdleMode
  OUT LptPort, p0100 'VppOff + VddOn + ClkLo + OutLo
  VppDly
  OUT LptPort, p0000 'VppOff + VddOff + ClkLo + OutLo
END SUB

FUNCTION InWord%
  OUT LptPort, p1111 'VppOn + VddOn + ClkHi + OutHi
  OUT LptPort, p1101 'VppOn + VddOn + ClkLo + OutHi
  word = 0
  BitPos = 1
  DO WHILE BitPos <= 8192
    OUT LptPort, p1111 'VppOn + VddOn + ClkHi + OutHi
    OUT LptPort, p1101 'VppOn + VddOn + ClkLo + OutHi
    Bit = (INP(LptPort + 1) AND DataIn) XOR DataInv
    IF Bit THEN word = word + BitPos
    BitPos = BitPos * 2
  LOOP
  OUT LptPort, p1111 'VppOn + VddOn + ClkHi + OutHi
  OUT LptPort, p1101 'VppOn + VddOn + ClkLo + OutHi
  InWord% = word
END FUNCTION

SUB LoadBin (Chan%, Which%, BufSize%)
  ON ERROR GOTO TrapOverflow
  OPEN "12476589.tmp" FOR OUTPUT AS Tmpfil
  address = -16
  sizecount = LOF(Chan) + 16
nextline:
  address = address + 16
  sizecount = sizecount - 16
  IF sizecount <= 0 THEN GOTO lastbytes
  PRINT Tmpfil, ":";
  IF sizecount >= 16 THEN PRINT Tmpfil, "10";  ELSE PRINT Tmpfil, "0"; HEX$(sizecount);
  IF sizecount >= 16 THEN linecheck = address + 16 ELSE linecheck = address + sizecount
  SELECT CASE address
          CASE IS <= 15
                  PRINT Tmpfil, "000"; HEX$(address);
          CASE 16 TO 255
                  PRINT Tmpfil, "00"; HEX$(address);
          CASE 256 TO 4192
                  PRINT Tmpfil, "0"; HEX$(address);
          CASE IS > 4192
                  PRINT Tmpfil, HEX$(address);
  END SELECT
  PRINT Tmpfil, "00";
  IF sizecount >= 16 THEN nbytes = 16 ELSE nbytes = sizecount
  FOR i% = 1 TO nbytes
          word = ASC(INPUT$(1, Chan))
          linecheck = linecheck + word
          SELECT CASE word
                  CASE IS <= 15
                          PRINT Tmpfil, "0"; HEX$(word);
                  CASE IS > 15
                          PRINT Tmpfil, HEX$(word);
          END SELECT
  NEXT i%
  PRINT Tmpfil, RIGHT$(HEX$(1 + NOT (linecheck)), 2)
  GOTO nextline
lastbytes:
  PRINT Tmpfil, ":00000001FF"
  CLOSE Chan
  Chan% = Tmpfil
  LoadHex 1, Progmem, ProgSize
END SUB

'
' This is very slow.  I expect it could be speeded up
' by making better use of QBasic's string operators.
'
SUB LoadHex (Chan%, Which%, BufSize%)
  ON ERROR GOTO TrapOverflow
  RecType = 0
  DO WHILE RecType <> 1
EXTADDOK:
    IF INPUT$(1, #Chan) <> ":" THEN Quit ERRHEX, 0, 0, 0
    Check = 0
    w = HexByte%(Chan)
    IF hextype = INHX16 THEN NWords = w ELSE NWords = w \ 2
    w = HexWord%(Chan)
    IF hextype = INHX16 THEN address = w ELSE address = w \ 2
    RecType = HexByte%(Chan)
    IF RecType <> 2 THEN GOTO NOEXTADD
    w = HexWord%(Chan)
    address = address + w
    w = HexByte%(Chan)
    Eol$ = INPUT$(2, #Chan)
    Check = Check AND &HFF
    IF Check THEN Quit ERRHEX, 0, 0, 0
    GOTO EXTADDOK
NOEXTADD:
    FOR i = 1 TO NWords
'      IF Address >= BufSize THEN Quit ERRHEX, 0, 0, 0
      wHi = HexByte%(Chan)
      wLo = HexByte%(Chan)
      IF hextype = INHX16 THEN w = 256 * wHi + wLo ELSE w = 256 * wLo + wHi
'1 new line and next line 2 spaces in
      IF address < BufSize THEN
        IF Which = Progmem THEN ProgBuf(address) = w ELSE DataBuf(address) = w
      END IF
      address = address + 1
    NEXT i
    w = HexByte%(Chan)
    Eol$ = INPUT$(2, #Chan)
    Check = Check AND &HFF
    IF Check THEN Quit ERRHEX, 0, 0, 0
  LOOP
  ON ERROR GOTO 0
END SUB

FUNCTION LptAddr% (LptNum%)
   IF (LptNum < 0) OR (LptNum > 3) THEN Quit ERRLPT, 0, 0, 0
   TablePtr = &H408 + 2 * (LptNum - 1)
   DEF SEG = 0
   Addr = PEEK(TablePtr) + 256 * PEEK(TablePtr + 1)
   DEF SEG
   SELECT CASE Addr
     CASE &H3BC, &H278, &H378
     CASE ELSE
       Quit ERRLPT, 0, Addr, 0
   END SELECT
   LptAddr% = Addr
END FUNCTION

SUB OpenHex (Chan%, File$)
  ON ERROR GOTO TrapFile
  IF hextype = CODE10 THEN OPEN File$ FOR BINARY AS Chan ELSE OPEN File$ FOR INPUT AS Chan
  ON ERROR GOTO 0
END SUB

SUB OutWord (word%)
  OUT LptPort, p1110 'VppOn + VddOn + ClkHi + OutLo
  OUT LptPort, p1100 'VppOn + VddOn + ClkLo + OutLo
  BitPos = 1
  DO WHILE BitPos <= 8192
    IF word AND BitPos THEN
      OUT LptPort, p1111 'VppOn + VddOn + ClkHi + OutHi
      OUT LptPort, p1101 'VppOn + VddOn + ClkLo + OutHi
    ELSE
      OUT LptPort, p1110 'VppOn + VddOn + ClkHi + OutLo
      OUT LptPort, p1100 'VppOn + VddOn + ClkHi + OutLo
    END IF
    BitPos = BitPos * 2
  LOOP
  OUT LptPort, p1110 'VppOn + VddOn + ClkHi + OutLo
  OUT LptPort, p1100 'VppOn + VddOn + ClkLo + OutLo
END SUB

'
' I found it tricky to get a machine independent small delay
' in QBasic, but perhaps I am missing something.  I guess
' machine code should be used, but that defeats the object.
'
' This is a kludge, but it gives better accuracy than using TIMER.
' An annoying (or perhaps useful) side effect is that the
' PC purrs during programming.
'
SUB PrgDly
  PLAY "MBT240L64N0"           'Should play for about 15ms
  DO WHILE PLAY(0) > 0: LOOP
END SUB

SUB ProgMode
  OUT LptPort, p0100 'VppOff + VddOn + ClkLo + OutLo
  VppDly
  OUT LptPort, p1100 'VppOn + VddOn + ClkLo + OutLo
END SUB

SUB Program (Which)
  IF Which = Progmem THEN
    n = ProgSize
    Mask = &H3FFF
    LdCmd = LdProg
    RdCmd = RdProg
  ELSE
    n = DataSize
    Mask = &HFF
    LdCmd = LdData
    RdCmd = RdData
  END IF

  ProgMode
  FOR i = 0 TO n - 1
    Command LdCmd
    IF Which = Progmem THEN v = ProgBuf(i) ELSE v = DataBuf(i)
    OutWord v
    Command BegPrg
    PrgDly
    Command RdCmd
    w = InWord% AND Mask
    IF v <> w THEN Quit ERRPRG, v, w, i
    Command IncAdd
  NEXT i
END SUB

SUB ProgramAll
  PRINT
  t& = TIMER
  EraseAll
  PRINT "Programming ..."
  Program Progmem
  IF DataLoaded THEN Program DataMem
  PRINT "Verifying ..."
  Verify Progmem
  IF DataLoaded THEN Verify DataMem
  PRINT "Blowing Fuses to 0x"; HEX$(Fuses); " ..."
  Config
  IdleMode
  t& = TIMER - t&
  COLOR Bcolor, Fcolor
  PRINT "Total time"; t&; "secs."
  COLOR Fcolor, Bcolor
END SUB

SUB Quit (ErrNum%, Wanted%, Got%, Addr%)
   a$ = HEX$(Addr) + ": " + HEX$(Wanted) + " " + HEX$(Got)
   COLOR Bcolor, Fcolor
   SELECT CASE ErrNum
     CASE ERRPRG:  PRINT "Programming Failed "; a$
     CASE ERRVER:  PRINT "Verify Failed "; a$
     CASE ERRLPT:  PRINT "Unlikely LPT port "; HEX$(Got%)
     CASE ERRFSE:  PRINT "Fuse Failure "; a$
     CASE ERRFIL:  PRINT "Can't open Hex file"
     CASE ERRHEX:  PRINT "Bad Hex file"
     CASE ERRNOF:  PRINT "Nothing to Do"
     CASE ERRHWF:  PRINT "Hardware Fault - check power, connections and port"
   END SELECT
   IdleMode
   BEEP
   LOCATE 22, 1
   COLOR Fcolor, Bcolor
   GetInput "Start over (Y/N)", "N", a$
   IF Yes(a$) THEN RUN
   END
END SUB

SUB Setup
  OUT LptPort, p0101  ' VddOn
  VppDly
  BitHi = (INP(LptPort + 1) AND DataIn) XOR DataInv
  OUT LptPort, p0000
  BitLo = (INP(LptPort + 1) AND DataIn) XOR DataInv
  IF (BitHi <> DataIn) OR (BitLo <> 0) THEN Quit ERRHWF, 0, 0, 0
  FOR i = 0 TO ProgSize - 1
    ProgBuf(i) = &H3FFF
  NEXT i
  FOR i = 0 TO DataSize - 1
    DataBuf(i) = &HFF
  NEXT i
END SUB

'
' This is an embarrassingly crude driver program. I will
' improve it when I have the time.  Simply take the default,
' if any, for bad or invalid input.
'
SUB UserInput
  COLOR Scolor, Scolor
  CLS
  COLOR Bcolor, Fcolor
  PRINT "  "; ProgName$; "       Version "; Version$; "       "; Copyright$; "  "
  COLOR Fcolor, Bcolor
  PRINT
  ProgLoaded = FALSE
  DataLoaded = FALSE
 
  GetInput "LPT port                   (1/2/3)", "1", a$
  LptPort = LptAddr%(VAL(a$))
  Setup
  PRINT
  PRINT "File type's : INHX8M                   (8)"
  PRINT "              INHX16                  (16)"
  PRINT "              Intel Intellec 8/MDS    (83)"
  PRINT "              Intel MCS-86 Hex Object (88)"
  PRINT "              Binary                  (10)"
  PRINT
  GetInput "Select File type   (8/16/83/88/10)", "8", a$
  SELECT CASE a$
    CASE "8": hextype = INHX8M
    CASE "16": hextype = INHX16
    CASE "83": hextype = CODE83
    CASE "88": hextype = CODE88
    CASE "10": hextype = CODE10
    CASE ELSE: hextype = INHX8M
  END SELECT

  PRINT
  INPUT "Program File name       (xxxxxxxx.yyy) "; a$
  IF LEN(a$) > 0 THEN
    OpenHex 1, a$
    IF hextype <> CODE10 THEN LoadHex 1, Progmem, ProgSize ELSE LoadBin 1, Progmem, ProgSize
    ProgLoaded = TRUE
  ELSE
    Quit ERRNOF, 0, 0, 0
  END IF

  INPUT "Data File Name          (xxxxxxxx.yyy) "; a$
  IF LEN(a$) > 0 THEN
    OpenHex 2, a$
    IF hextype <> CODE10 THEN LoadHex 2, DataMem, DataSize ELSE LoadBin 2, Datamen, Datesize
    DataLoaded = TRUE
  END IF
 
  AskFuses

END SUB

SUB Verify (Which)
  IF Which = Progmem THEN
    n = ProgSize
    Mask = &H3FFF
    RdCmd = RdProg
  ELSE
    n = DataSize
    Mask = &HFF
    RdCmd = RdData
  END IF

  ProgMode
  FOR i = 0 TO n - 1
    IF Which = Progmem THEN v = ProgBuf(i) ELSE v = DataBuf(i)
    Command RdCmd
    w = InWord% AND Mask
    IF v <> w THEN Quit ERRVER, v, w, i
    Command IncAdd
  NEXT i
END SUB

'
'  About 100ms delay
'
SUB VppDly
  t! = TIMER
  tplus! = t! + .1
  DO UNTIL t! > tplus!
    t! = TIMER
  LOOP
END SUB

FUNCTION Yes% (a$)
  IF (a$ = "Y") OR (a$ = "y") THEN y = TRUE ELSE y = FALSE
  Yes% = y
END FUNCTION

