	page	66,132
	page

;---- args.asm ----------------------------------------------------------
; This file contains both an argument grabber and a simple heap.
;
; Args parses the command line into a unix-style parameter array.
; To use it, you should be a .COM program: that is,
; you must start your program as follows:
;	code	segment public 'CODE'
;	assume	CS:code,DS:code,ES:code
;	extrn	_args:near,argc:word,argv:word		;argc & argv in CS:
;
; and end the file as follows:
;	code	ends
;	end
; Link to your program with LINK YOURFILE,args; then EXE2BIN YOURFILE.
; Your program should start with an ORG 100H statement, and should
; CALL _ARGS to have it parse the cmdline.
; Argc and Argv are just as in C; argc = # of params on cmd line,
; argv is an array of pointers to strings (null terminated, of course). 
; Because MS-DOS doesn't pass us the name used to invoke the program,
; argv[0] always points to a null string.
; _SHIFT updates ARGC.
;
; See the file \bin\asm\exist.asm for an example.
; Do not call NEW before calling _ARGS.
;
; Changes:
;   16 July 1984   DRK    Copy args out of default location; fixed argv[0].
;   1 Aug 1984     DRK    Added _SHIFT. 
;   16 Oct 1984    MCN    _SHIFT updates argc
;   21 Mar 1985    DRK    oh yeah?
;--------------------------------------------------------------------------

	PUBLIC	_ARGS,ARGC,ARGV,_SHIFT, new, dispose

; Predeclared file handles
stdin	equ	0
stdout	equ	1
stderr	equ	2
stdsio	equ	3
stdprn	equ	4

; Maximum number of parameters
maxparms	equ	32

; Declarations for accessing command line
nchar	equ	80h		; address of number of chars in argument line
params	equ	81h		; address of argument line

;---- code starts here --------------------------------------------------------
code	segment	public	'CODE'
assume cs:code,ds:code

_args	proc	near
	call	near ptr newinit

	; initialize
	cld			; clear decrement mode
	mov	bx, 2		; argc = 0 (will sub 2 from bx at end)
	mov	argv[0], offset null	; prog name unknown; set to null.
	mov	si, params	; i = 0
	mov	di, nchar	; fuck this assembler -- won't mov cl,[81h]
	mov	cl, [di]	; cx = # of chars in command line
	mov	ch, 0
	jcxz	done		; no arg chars -> we're done.

	; Allocate room for arguments; returns pointer in BX.
	push	bx
	push	cx
	mov	cx, 128		; worst case
	call	new
	mov	di, bx
	pop	cx
	pop	bx

	; Move arguments out of default DTA.
	push	cx
	push	di
	rep	movsb
	pop	si
	pop	cx

	; Big loop- find arguments...
parml:
	; Little loop #1: strip leading blanks from argument.
	; while (i<nchar && params[i] = ' ') do i++;
stripl:	lodsb			; al = [si++]
	cmp	al, ' '		; space?
	loopz	stripl		; if so, keep skipping.
	jne	gotone		; If we found a nonblank, skip zero test.
	jcxz	done		; found no unblank chars -> we're done.

gotone:	dec	si		; bump SI back to start of nonblank. 
	inc	cx
	mov	argv[bx],si	; save pointer to this string

	; Little loop #2: skip nonblank chars.
	; while (i<nchar && params[i] <> ' ') do i++;
skipl:	lodsb
	cmp	al, ' '
	loopnz	skipl
	jz	oky
		; Last char of line was not blank.
		inc	si	; make next statement put null AFTER arg.
oky:
	mov	byte ptr [si][-1], 0	; put null at end of arg
	add	bx,2		; argc++;

	jcxz	done		; if we ran off end of cmdline, no more args.

	cmp	bx, maxparms*2
	jb	parml		; loop if argc < maxparms.

done:	; All done finding parms; now share argc with caller.
	sub	bx, 2
	shr	bx, 1
	mov	argc, bx
	ret

_args	endp

;---- _Shift: --------------------------------------------
; Shifts %2 to %1, %3 to %2, etc.  Leaves %0 alone.
; Works by shuffling argv[*].
_shift	proc	near
	cld
	mov	si, offset argv[4]
	mov	di, offset argv[2]
	mov	cx, maxparms
	rep	movsw
; wrongo!  Caller should do this...	sub argc, 1		; there is now one less argument
	ret
_shift	endp


;----- Newinit- initialize heap

newinit	proc	near
	mov	CS:firstfree, offset lastcode
	ret
newinit	endp

; Given length in CX, returns pointer in BX.
; Does not affect CX.
new	proc	near
	push	cx
	mov	bx, cs:firstfree
	add	cx, cs:firstfree
	mov	cs:firstfree, cx
	cmp	sp, cx
	pop	cx

	jbe	newerror
	ret

stackmsg:	db	'?New: heap overflow', 7, 13, 10
newerror:
sml	equ	newerror - stackmsg
	push	cs
	pop	ds
	mov	dx, offset stackmsg
	mov	cx, sml
	mov	bx, stderr
	mov	ah, 40h
	int	21h
	mov	ax, 4c02h		; terminate- error code 2
	int	21h

new	endp

;---- Call Dispose with ptr in BX, length in CX.
dispose	proc	near
	ret
dispose	endp

;------ Heap variables ------
firstfree	dw	?

;---- parameter count, array ---------------------------------------------------
; Pointers to up to maxparms parameter strings are held here.

null	dw	0		; the null string
argc	dw	?
argv	dw	maxparms dup (?)

lastcode	label	near

code	ends

	end


