page 66, 132
;---------- cat.com ------------
; Copies the named files to stdout.
; If no files named, uses stdout.
; Wildcards okay.
; Ensures that resulting file has no EOF marks.
; Complains if file not found.


; uses args
	extrn	_args:near,	_shift:near
	extrn	argc:word,	argv:word

; uses ffind
	extrn	ffirst:near,	fnext:near
	extrn	fnam:byte

; uses fio
	extrn	f_io_init:near
	extrn	f_ihand:word,	f_ohand:word
	extrn	f_ibuf:word,	f_obuf:word
	extrn	f_ilen:word,	f_olen:word
	extrn	f_ibufend:word,	f_obufend:word
	extrn	f_imore:near,	f_omore:near
	extrn	f_getc:near,	f_putc:near

dos	macro	fn
	mov	ah, fn
	int	21h
	endm

stdin	equ	0
stdout	equ	1
stderr	equ	2

code	segment para public 'CODE'
assume cs:code,ds:code

	org	100h
main	proc
	jmp	cat
main	endp


;----------------------------------------------

	db	27
	db	'[2J cat (C) 1984 Yoyodyne, Inc- a growing excited company', 26

errs		dw	null		; error zero- no error
		dw	null, filenotfound, pathnotfound, nohand, access
		dw	null, null, null, null, null
		dw	null, null, null, null, baddrive
		dw	null, null

null		db	'?dos err', 0
filenotfound	db	'File not found', 0
pathnotfound	db	'Path not found', 0
nohand		db	'No handles left', 0
access		db	'Access denied', 0
baddrive	db	'Invalid drive specification', 0

trueargc	dw	?

;--- strlen ---
; Returns length of ES:DI in CX, points to null with DI.

strlen	proc	near
	cld
	push	ax
	mov	cx, -1
	mov	al, 0
	repnz	scasb
	not	cx
	pop	ax
	ret
strlen	endp

dos_err	proc	near
	mov	bx, ax
	add	bx, ax
	mov	di, errs[bx]
	push	di
	call	strlen
	pop	dx
	mov	bx, stderr
	DOS	40h
	ret
dos_err	endp

open_err	proc	near
	call	dos_err
	mov	al, 1
	DOS	4ch
open_err	endp

;-------------------------------------------------

cat	proc	near

	call	_args

	; Initialize the buffers...
	mov	f_ilen, 16384
	mov	f_olen, 16384
	call	f_io_init

	; Get them args...
	mov	ax, argc
	mov	trueargc, ax	; save for end of repeat loop
	or	ax, ax
	jnz	while_loop
		; If no arguments, use stdin.
		mov	argc, 1
		mov	bx, stdin
		DOS	45h		; get another handle to stdin
		jc	open_err
		mov	f_ihand, ax
		jmp	short gothandle

	;----- Main Loop -------
	; do {
	;   find_first_matching(argv[2]);
	;   repeat
	;       copy file to stdout;
	;       until not find_next;
	;   shift;
	;   } while (argc > 0);

while_loop:
	mov	dx, argv[2]
	mov	cx, 0
	call	ffirst
	jnc	rept_loop
	call	notfound
	jmp	rept_done	; go on to next argument

rept_loop:
	mov	dx, offset fnam
	mov	al, 0		; open for read access
	dos	3dh
	jc	open_err

gothandle:
	mov	f_ihand, ax
	mov	f_ohand, stdout

	; SI & DI are used by getc & putc.
	mov	si, f_ibuf
	mov	f_ibufend, si
	mov	di, f_obuf

moreclp:
	call	f_getc
	jz	morecx
	cmp	al, 26
	jz	morecx	
	call	f_putc
	jmp	moreclp

morecx:	call	f_omore		; flush output buffer

	mov	bx, f_ihand
	DOS	3Eh		; close input file

	;       until (not find_next);
	cmp	trueargc, 0	; no searching to do at all in this case
	jz	while_done

	call	fnext
	jc	rept_done
	jmp	rept_loop
rept_done:
	;   shift;
	call	_shift
	dec	argc
	cmp	argc, 0
	jz	while_done
	jmp	while_loop

while_done:
	;mov	bx, f_ohand
	;DOS	3eh		; close output file (don't close stdout?)

	mov	al, 0		; no error
exit:
	mov	ah, 4ch
	int	21h		; terminate process, return status in AL.

notfound:
	mov	dx, offset cantfind
	DOS	9

	mov	di, argv[2]	; get pointer to string
	push	di
	call	strlen
	pop	dx
	mov	bx, stdout
	mov	ah, 40h
	int	21h		; print

	mov	dx, offset couldntfind
	DOS	9
	ret
cat	endp
cantfind:	db	"?cat: can't open $"
couldntfind:	db	"."
		db	0dh, 0ah
		db	"$"
code	ends

	end	main



 
