	page	66,132
	page

;---- df.com ---------------------------------------------------------------
; Usage: df {-option} {drive}
; Gives free space left on given drive.
; Option: -nnn where nnn is a decimal number < 65536
;	Errorlevel is set to zero if free space > nnn kilobytes, two otherwise.
; If no drive is given, defaults to current drive.
; If invalid drive, errorlevel set to one.
; DRK 16 July 84
; Rev 15 Aug 84
;------------------------------------------------------------------------------

stdout	equ	1
stderr	equ	2

	extrn	_args:near, _shift:near, argc:word, argv:word
	extrn	new:near

	extrn	sprintf:near


code	segment	public 'CODE'
assume cs:code,ds:code

	org	100h

main	proc
	jmp	df
main	endp


	db	27, "[2J"
usagem	db	"df	- show disk free space", 13, 10
	db	"Usage: df {-nnnn} {drive:}", 13, 10
	db	"Options: -nnnn: if (kilobytes_free < nnnn) errorlevel=2."
	db	13, 10
usagelen	equ	$-usagem
	db	26			; eof mark for the casual typist
			
threshold	dw	?		; value of -nnn
bufptr		dw	?		; where to store strings

dfmsg	db	'%ld bytes free.\n', 0
bdmsg	db	'? df: bad drivespec %s.\n', 0


;---- df ---------------------------------------------------------------------

df	proc	near

	call	_args

	mov	cx, 100		; init printf
	call	new
	mov	bufptr, bx


	mov	threshold, 0

argl:	mov	dl, 0		; 0 = default drive
	cmp	argc, 0
	jz	got_args

	mov	si, argv[2]	; get ptr to first arg
	lodsb
	cmp	al, '-'		; is it an option?
	jnz	no_option
		call	dec2w	; read argument into AX
		mov	threshold, ax
		call	_shift
		dec	argc
		jmp	argl
no_option:
	; Then it was a drive code.
	mov	dl, al
	lodsb
	cmp	al, ':'
	jnz	usage

	and	dl, 0DFh		; convert to uppercase
	sub	dl, '@'			; convert to drive code
got_args:
	mov	ah, 36h
	int	21h			; get disk space
	inc	ax
	jz	baddrive		; ax = -1 -> bad drive number
	dec	ax

	mul	cx			; ax = bytes/cluster
	mul	bx			; dx:ax = bytes free

	push	dx
	push	ax			; save total bytes free for comparison

	mov	ax, offset dfmsg
	push	ax
	mov	bx, stdout
	call	fdprintf
	add	sp, 2

	pop	ax			; recover disk free space
	pop	dx

	mov	cx, 10
shloop:	shr	dx,1
	rcr	ax,1
	loop	shloop			; convert to kilobytes

	or	dx, dx
	jnz	muchroom

	cmp	ax, threshold
	ja	muchroom
		mov	al, 2
		jmp	short exit	; below threshold- set errorlevel
muchroom:
	mov	al, 0

exit:	mov	ah,4ch
	int	21h			; terminate, return status in AL.

df	endp


;---- usage ------------------------------------------------------------
; Print the usage admonishment to stderr.
usage:
	mov	bx, stderr
	mov	cx, usagelen
	mov	dx, offset usagem
	mov	ah, 40h
	int	21h
	mov	al, 1
	jmp	exit


baddrive:
	push	argv[2]
	mov	ax, offset bdmsg
	push	ax
	mov	bx, stderr
	call	fdprintf
	mov	al, 1
	jmp	exit

printf_rtn	dw	?
printf_hand	dw	?

;---- fdprintf ------------------------------------------------------------
; Print a formatted string to handle in bx.
fdprintf	proc	near
	mov	printf_hand,bx
	pop	printf_rtn
	push	bufptr
	call	sprintf
	add	sp, 2
	mov	dx, bufptr
	mov	cx, di
	sub	cx, dx
	dec	cx
	mov	bx, printf_hand
	mov	ah, 40h
	int	21h
	jmp	word ptr printf_rtn
fdprintf	endp


;----- dec2w ---------------------------------------------------------
; converts ascii decimal string @DS:SI++ to AX.
; (String must be null-terminated.)
dec2w	proc	near
	mov	cx, 0
	mov	bx, 10

dloop:	; 1. Terminate if digit is a null.
	lodsb
	or	al, al
	jz	ddone

	; 2. Multiply older digits by ten.
	xchg	ax, cx
	mul	bx
	xchg	cx, ax

	; 3. Add current digit.
	sub	al, '0'
	cbw			; never signed
	add	cx, ax

	jmp	dloop

ddone:	xchg	ax, cx
	ret

dec2w	endp

code	ends

	end	main

