	page	66,132
	page

;---- Exist.com ---------------------------------------------------------------
; Usage: exist filespec
; Sets errorlevel = {0 if file exists; 1 if file doesn't exist}
; Wildcards allowed in filename; forward or backslashes allowed in pathspec.
; DRK 30 June 84
; 
; Example of use inside batch file:
;   exist /bin/%1
;   if errorlevel 1 goto nofile
; Note: remember that "errorlevel 0" is (errlev >= 0), a tautology.
;------------------------------------------------------------------------------
	extrn	_args:near,argc:word,argv:word

stderr	equ	2


code	segment	public 'CODE'
assume cs:code,ds:code

	org	100h

; This is a .COM program.
; It takes one argument- the name of a file (wildcards ok).
; If the file exists, ERRORLEVEL is set to zero; otherwise to one.
; 
; The argument is the first nonblank string of chars.
; Either backslashes or forward slashes may be used in a pathname.

exist	proc	near

	; Get arguments.
	call	_args

	; Check # of arguments- if not exactly one, send usage message.
	cmp	argc,1
	jnz	usage

	; call DOS to see if file exists.
	mov	dx, argv[2]	; get pointer to first argument.
	mov	ah, 4eh
	mov	cx, 0		; no special attribute bits set
	int	21h		; call DOS

	jc	nofile		; if carry set, no file found.
exok:	mov	al,0		; errorlevel= 0 => file found
	jmp	short exit
nofile:	mov	al,1		; errorlevel = 1 => no file found
exit:	mov	ah,4ch
	int	21h		; terminate process, return status in AL.

ulen	= 0
ulen	=	uend-uoff

usage:	mov	bx, stderr	; write to error device...
	mov	cx, ulen
	mov	dx, offset umsg
	mov	ah, 40h
	int	21h
	mov	al, 2		; error2 = syntax error
	jmp	exit

exist	endp
                    
umsg	db	'Usage: exist filespec', 13, 10
bugo	db	?
uoff	equ	offset umsg
uend	equ	offset bugo

code	ends

	end	exist
