page 66,132
;compressed mode on prn.
page


;---- Ffind.obj ------------------------------------------------
; For those of you who like to use wildcards:
; allows pathnames for find first.  Makes FIND NEXT again wonderful.
;
; MCN  3 July 84
; To use these routines, include the following lise in caller's file:
;	EXTRN	FFIRST:NEAR,FNEXT:NEAR,FNAM:BYTE
; To call, load registers as for DOS function calls 4EH and 4FH, and
;	CALL	FFIRST		( or FNEXT )
; And then to actually use the found filespec, (e.g. open that file):
;	LEA	DX, FNAM	; get ptr to found filespec
;	MOV	AH, 3DH		; DOS for OPEN FILE
;	MOV	AL, 0		; open for, say, read access
;	INT	21H
; Further examples can be found in \bin\asm\TOUCH.ASM etc.
;---------------------------------------------------------------

public	ffirst, fnext, fnam, finder
extrn	new:near

ffnam	equ	30		; filename goes to dta + 30d

code	segment	public 'CODE'
assume cs:code,ds:code,es:code

;---- Ffirst: --------------------------------------------------------------
; Finds first file with filespec pointed to by DS:DX, attribs in CX.
; Just like DOS fn 4EH, but also returns full filespec in buffer FNAM.
; Either backslashes or forward slashes may be used in a pathname.
; All registers preserved.

ffirst proc	near

	push	ax
	push	bx
	push	si
	push	di
	push	es

	push	cx		; allocate room for our finder
	push	dx
	mov	cx, 44
	call	new
	mov	finder, bx
	mov	ah, 1ah
	mov	dx, bx
	int	21H		; set DTA
	pop	dx
	pop	cx

	; Now copy the goddamned drive and path.  Of course,
	; we don't know yet how much is path and how much is
	; filename. So, we will copy the whole filespec, and
	; just remember the last char in the set [:,/,\], the
	; default memory being of childhood.

	; Pointer to text in DS:DX.  Put it in SI; 
	; put pointer to our buffer in DI.
	mov	si,dx
	lea	di,fnam

	mov	fnf, di		; save offset of beginning of filename
	dec	fnf

	; copy until we find a null; remember location of any [:,/,\].
copyem:
		lodsb
		cmp	al,':'
		jz	foundone
		cmp	al,'/'
		jz	foundone
		cmp	al,'\'
		jnz	nope
foundone:
		mov	fnf,di
nope:
		stosb
		or	al,al		; copy until null...
		jnz	copyem
	inc	fnf		; point to region AFTER last metachar.

	; Whee, that was fun.  Now call DOS to find first.
	; Find first requires pointer to filespec in DX. Fortumately, s'there.
	mov	ah, 4eh
	int	21h		; call DOS
	jc	nofile		; if carry set, no file found.

	; Following a FIND, we must copy the found whizdoodle to 
	; *fnf.
	jmp	short copynam

ffirst	endp


;--- Fnext: -----------------------------------------------------------
; Fnext is called just like the DOS function FIND NEXT, but it
; places the path and filename in the read-only buffer FNAM.
; Don't need to set AH.
; All registers preserved.

fnext	proc	near

	push	ax
	push	bx
	push	si
	push	di
	push	es

	mov	ah, 4fh		;ask DOS for the next file
	int	21h
	jc	nofile

copynam:
	; 1. Get DTA into ES:BX.
	mov	ah, 2fh
	int	21h

	; 2. SI= ES ptr to what FIND returns, at DTA + FFNAM.
	mov	si, bx
	add	si, ffnam

	; 3. DI= DS ptr to old pathspec, at *fnf.
	mov	di, fnf		; ptr to end of pathspec

	; 4. Append the file name to the pathspec.
	; What should be a Move String is horribly complicated.
	; We need to swap segment registers....
	push	ds
	push	es
	pop	ds
	pop	es

copyl:
		lods	byte ptr [SI]	; (Default seg reg is DS.)
		or	al,al
		stos	byte ptr [DI]	; (Default seg reg is ES.)

		jnz	copyl

	push	es
	pop	ds
	; Don't need to restore DTA's ES, as we don't need it anymore.

	clc			; return "no errors"
nofile:
	pop	es
	pop	di
	pop	si
	pop	bx
	pop	ax
	ret
fnext	endp

;------- Data area ------------------
fnf	dw	?		; points to file name field in filespec below
finder	dw	?		; points to DTA we set up.

fnam	db	90 dup (?)
code	ends
	end
