page 66, 132
;   Narrow on printer
page

;---- fio.asm -------------------------------------------------------------
; Buffered I/O for lazy programmers.
; Expects user to set these provided variables:
;	f_ihand, f_ohand: handles of input & output files, respectively
;       f_ibuf, f_obuf  : word pointers to buffer areas;
;	f_ilen, f_olen  : word lengths of buffer areas;
; Provides:
;       f_ibufend, f_obufend: word ptrs to current ends of buffer areas;
;       f_imore, f_omore    : routines to flush input & output buffers;
;       f_getc, f_putc      : Get/put al; flags same as imore & omore.
;	f_io_init           : Given f_ilen & f_olen, calls new & sets up.
;
; All these routines reserve SI and DI for their io pointers.
; Getc and imore detect physical EOF; you'll have to compare with
; ^Z yourself if you need logical EOF.
;
; Version of 23 Aug 1984; DRK.


	extrn	new: near;

	public	f_ihand, f_ohand, f_ibuf, f_obuf, f_ilen, f_olen;
	public	f_ibufend, f_obufend, f_imore, f_omore;
	public	f_getc, f_putc;
	public	f_io_init


dos	macro	fn
	mov	ah, fn
	int	21h
	endm

code	segment para public 'CODE'
assume cs:code,ds:code

f_ihand		dw	?
f_ohand		dw	?

f_ibuf		dw	?	; where input buffer starts
f_ibufend	dw	?	; points to just past last byte
f_ilen		dw	?
f_obuf		dw	?	; where output buffer starts
f_obufend	dw	?
f_olen		dw	?

;-- f_io_init -----------
f_io_init	proc	near
	mov	cx, f_ilen
	call	new
	mov	f_ibuf, bx
	mov	f_ibufend, bx
	mov	si, bx

	mov	cx, f_olen
	call	new
	mov	f_obuf, bx
	mov	di, bx
	add	bx, cx
	mov	f_obufend, bx

	ret
f_io_init	endp


;-- f_imore -----------------------------------------------
; Reads from file into f_ibuf.
; Resets f_ibufend.
; Loads SI with new f_ibufptr.
; Returns Z=true if at EOF, CY=true if error reading file.

f_imore	proc	near

	mov	bx, f_ihand
	mov	cx, f_ilen
	mov	dx, f_ibuf
	DOS	3fh		; read from file
	jc	rerr

	mov	si, dx
	add	dx, ax
	mov	f_ibufend, dx

	or	ax, ax		; check physical EOF
	clc

rerr:	ret

f_imore	endp

;-----------------------------------

;-- f_omore ---------------------------------------
; Expects DI to have f_obufptr.
; Writes f_obuffer to output file.
; Resets f_obufend
; Loads DI with new f_obufptr.

f_omore	proc	near

	mov	dx, f_obuf
	mov	bx, f_ohand
	mov	cx, di
	sub	cx, dx
	
	DOS	40H		; write to file
	jc	werr
	sub	cx, ax
	jz	afinished
	dec	cx
	mov	ax, -1
	jnz	werr		; account for WIERDNESS in DOS:
				; when writing to device, the ^Z is not
				; transferred.  Ignore error if all but one
				; char was written.
afinished:
	mov	di, dx
	clc

wdone:	ret

werr:	stc
	jmp	wdone

f_omore	endp


;-----------------------------------
f_getc	proc	near
	cmp	si, f_ibufend
	jnz	f_gcok
		call	f_imore
f_gcok:	lodsb
	ret
f_getc	endp


f_putc	proc	near
	cmp	di, f_obufend
	jnz	pok
		push	ax
		call	f_omore
		pop	ax
pok:	stosb
	ret
f_putc	endp



code	ends

	end


 
