page 66,132
;compressed mode on prn.

;---- rm.com ---------------------------------------------------
; Usage: rm filespec
; Deletes filespec
; Wildcards allowed in filename 
; Uses standard DRK args, ffind
; MCN  16 Oct 84
; DRK  7 May 86 (yikes!) Added no-unix-wildcard check, cleaned up, added eputs
;---------------------------------------------------------------
	extrn	_args:near,argc:word,argv:word,_shift:near
	extrn	ffirst:near,fnext:near,fnam:byte,finder:word
	extrn	strlen:near

stderr	equ	2

code	segment	public 'CODE'
assume cs:code,ds:code,es:code

f_attrib	equ	21		; offset from DTA of file attrib

	org	100h

origin	proc	near
	jmp	main
origin	endp

	db	27, '[2J'
	db	'rm, May 1986, from Yoyodyne Aerospace (where the future',13,10
	db	'begins Real Soon Now)', 13, 10
umsg	db	'Usage: rm filespec [filespec ...]', 13, 10, 0
	db	26		; eof mark after hello and usage message

;--- Error strings ---
modname	db	"rm: '",0
nommsg	db	"': no match", 13, 10, 0
amsg	db	"': access denied", 13, 10, 0
nadmsg	db	"': unable to remove", 13, 10, 0	; shouldn't happen
wcmsg	db	"': bad wildcarding", 13, 10, 0

;--- eputs -----
; Print string at DX to stderr.
; Preserves DX.
eputs	proc	near
	mov	di, dx
	call	strlen
	mov	bx, stderr
	mov	ah, 40h
	int	21h
	ret
eputs	endp

;--- prname ---
; Print rm:
; Preserves SI,DX.
prname	proc	near
	push	si
	push	dx
	mov	dx, offset modname
	call	eputs
	pop	dx
	pop	si
	ret
prname	endp

;--- Complain ----
; Filename in si has an invalid wildcard sequence;
; print an error message.
complain	proc	near
	call	prname
	mov	dx, si
	call	eputs
	mov	dx, offset wcmsg
	call	eputs
	ret	
complain	endp

;--- Denied ----
; Filename in DX was un-removable; print "Access denied."
; (Error code in AX; if not "access denied", print something else.)
denied	proc	near
	call	prname
	call	eputs		; print filename
	mov	dx, offset amsg
	cmp	ax, 5
	jne	nfw		; not access denied
	mov	dx, offset nadmsg
nfw:	call	eputs
	ret
denied	endp

;--- Star_no_dot ---
; Checks filename in SI for occurrence of * followed by anything but
; a null or a period.
star_no_dot	proc	near
	cld	
snd_lp:		lodsb
		or	al, al
		jz	snd_ex
		cmp	al, '*'
		jnz	snd_lp
		; Found a *; is next char a 0 or '.'?
		lodsb
		or	al, al
		jz	snd_ex
		cmp	al, '.'
		jz	snd_lp
		; fall thru to exit with NZ = error
snd_ex:	ret
		
star_no_dot	endp

;--- main -------
main	proc	near
	; Get arguments.
	call	_args

	; Check # of arguments- if none, send usage message.
	cmp	argc, 0
	jnz	arglp
		mov	dx, offset umsg
		call	eputs
		mov	al, 1
		jmp	exit
					
arglp:	; Make sure file isn't a Unix wildcard with something following a *.
	mov	si, argv[2]
	call	star_no_dot	; returns NZ if error
	jz	argok
		mov	si, argv[2]
		call	complain	; bad filespec in si
		jmp	narg		; and onwards

argok:
	; call DOS to see if file exists.
	mov	dx, argv[2]	; get pointer to first argument.
	mov	cx, 0		; no special attribute bits set
	call	ffirst		; FIND FIRST
	jnc	doit		; if carry set, no file found.
		call	prname
		mov	dx, argv[2]
		call	eputs
		mov	dx, offset nommsg
		call	eputs
		jmp	narg

	; Inner loop
doit:		lea	dx, fnam
		mov	ah, 41h		; unlink file
		int	21h
		jnc	next
			lea	dx, fnam
			call	denied	; give whimpy access denied message
next:		call	fnext		; FIND NEXT
		jnc	doit		; again

narg:	call	_shift		; more arguments?
	dec	argc
	jnz	arglp		; nope

	mov	al, 0		; errorlevel=0; ok.
exit:	mov	ah, 4ch
	int	21h		; terminate process, return status in AL.

main	endp

code	ends

	end	origin
