	page	66,132
	;  narrow print
	page

;---- popdir.com ---------------------------------------------------------------
; Usage: popdir
; DRK 30 June 84
; Sets current directory to that in the file %1.
;------------------------------------------------------------------------------

	extrn	_args:near,argc:word,argv:word

stderr	equ	2
envadr	equ	2ch

code	segment	public 'CODE'
assume cs:code,ds:code

	org	100h

; This is a .COM program.
;
;
; procedure Popdir;
; begin
;	get command line;
;	if (argc <> 1) error;
;	if not fopen(olddir, %1) error;
;	chdir(readln(olddir));
;	end;
;

ulen	=	fmsg - umsg
flen	=	bmsg - fmsg
blen	=	zmsg - bmsg
odlen	equ	7		; note: if this is placed AFTER its use,
				; assembler generates NOP after inst using it!

popd	proc	near
	; Get arguments.
	call	_args

	; Check # of arguments- if not exactly zero, send usage message.
	mov	cx, ulen
	lea	dx, umsg
	cmp	argc,1
	jnz	error

	; Locate the file.
	mov	ax, 3d00h		; open it for reading
	mov	dx, argv[2]
	int	21h
	mov	cx, flen
	lea	dx, fmsg
	jc	error			; file not found- return error msg.

	; Search succeeded.  AX contains the file's handle.
	; Set the directory according to the file contents.
	mov	bx,ax			; want handle in BX
	mov	ah, 3fh
	mov	cx, 64			; don't want > 64 char
	mov	dx, 80h			; put data on top of args for now
	int	21h			; do the read
	mov	cx,flen
	mov	dx,offset fmsg
	jc	error

	; Turn carriage return into null (assume file created by CD > file.)
	mov	si, 80h
	mov	cx, ax		; ax is # of bytes read in above fn call
loopc:	lodsb
	cmp	al, 13
	loopnz	loopc		; it must happen before end of data read in...

	mov	byte ptr [si-1], 0	; put null on top of carriage return

	; Finally, set the directory.
	mov	dx, 80h
	mov	ah, 3bh		; CHDIR
	int	21h
	mov	cx, blen
	lea	dx, bmsg
	jc	error

	; We're done.  Set errorlevel to zero.
	mov	al, 0

exit:	mov	ah, 4ch			; terminate process
	int	21h

error:	; Jump here with ptr to string in DX, length of string in CX.
	; String will be printed to screen (even if output is redirected!)
	push	cs
	pop	ds

	mov	bx, stderr	; write to error device...
	mov	ah, 40h
	int	21h
	mov	al, 1		; some sorta problem here, guys.
	jmp	exit

popd	endp
                    
umsg	db	'Usage: setdir filespec', 13, 10
fmsg	db	'?Setdir: couldnt open file', 13, 10
bmsg	db	'?Setdir: file contained invalid directory name', 13, 10
zmsg	db	?

code	ends

	end	popd

