;----- strings.asm ------------
; A set of string functions like those in c's stdio library, but
; which use register to pass arguments and results.
;
; int cx = strlen(es:di);
; Returns cx = length of null-terminated string at es:di.
;
; char *si=rindex(ds:si, al)
; Returns si = pointer to last occurrence of char al in string si.
; If no occurrence, returns zero.
; Alters AX, SI; all others preserved.
;
; flags strcmp(ds:si, es:di)
; Compares two null-terminated strings for equality.
; Preserves all registers other than si and di.

	public rindex, strcmp, strlen

code	segment para public 'CODE'
assume cs:code

;---- strlen ----
; input: es:di points to string
; output: cx is string length
; Uses ax

strlen	proc	near
	mov	cx, 65535
	mov	al, 0	
	repnz	scasb
	neg	cx
	dec	cx
	dec	cx
	ret
strlen	endp

rindex	proc	near
	push	bx
	cld
	mov	ah, al
	mov	bx, 1
rloop:
	lodsb
	or	al, al
	jz	rdone
	cmp	al, ah
	jnz	rloop
	mov	bx, si
	jmp	rloop
rdone:	mov	si, bx
	pop	bx
	dec	si
	ret
rindex	endp

;----- strcmp -----------------------------------------------------
; Compares two null-terminated strings for equality; results returned in flags.
; Uses SI and DI, preserves all others.

strcmp	proc	near
	cld
	push	ax
sloop:
	cmpsb
	jnz	sdone
	dec	si
	lodsb
	or	al, al
	jnz	sloop
sdone:
	pop	ax
	ret
strcmp	endp

code	ends

	end
