page 66,132
;compressed mode on prn.

;---- touch.com ---------------------------------------------------
; Usage: touch file [file...]
; Sets creation time of file to now
; Wildcards allowed in filename 
; Patterned after rm by MCN
; DRK 30 Oct 85
;---------------------------------------------------------------
	extrn	_args:near,argc:word,argv:word,_shift:near
	extrn	ffirst:near,fnext:near,fnam:byte,finder:word

stderr	equ	2

code	segment	public 'CODE'
assume cs:code,ds:code,es:code

f_attrib	equ	21		; offset from DTA of file attrib

	org	100h

; This is a .COM program.
; It takes one or more arguments - the names of files (wildcards ok).
; 
; The argument is the first nonblank string of chars.
; Either backslashes or forward slashes may be used in a pathname.

exist	proc	near

	; Get arguments.
	call	_args

	; Check # of arguments- if none, send usage message.
	cmp	argc, 0
	jnz	arglp
		jmp	usage

					
	; call DOS to see if file exists.
arglp:	mov	dx, argv[2]	; get pointer to first argument.
	mov	cx, 0		; no special attribute bits set
	call	ffirst		; FIND FIRST
	jc	nofile		; if carry set, no file found.

doit: 

	mov	ah, 3dh		; open file for writing
	mov	al, 1
	lea	dx, fnam	; 
	int	21h
	jnc	changem
		call	denied		; give whimpy access denied message
		jmp	short next
changem:
	xchg	ax, bx

	; Get current date/time
	cli			; stop system chronograph (no rollover, please)
	mov	ah, 2ch
	int	21h		; hour=ch, min=cl, sec=dh
	push	cx
	push	dx
	mov	ah, 2ah
	int	21h		; cx=year(1980..), dh=month(1-12), dl=day(1-31)
	sti			; restart chronograph, hope no serial I/O lost

	; Convert to file timestamp format
	; dx=yyyyyyy mmmm ddddd (yyyyyyy = year-1980, mmmm=1..12, dddd=1..31)
	sub	cx, 1980
	shl	dh, 1
	shl	dh, 1
	shl	dh, 1
	shl	dh, 1
	shl	dh, 1		; dh = mmm00000
	rcl	cl, 1		; cl = yyyyyyym
	or	dl, dh		; dl = mmmddddd
	mov	dh, cl		; dx = yyyyyyym mmmddddd
	
	; cx=hhhhh mmmmmm sssss (sssss = seconds/2)
	pop	ax		; sec = ah
	pop	cx		; hour = ch, min=cl
	shr	ah, 1		; ah = 000sssss
	shl	cl, 1
	shl	cl, 1		; cx = 000hhhhh mmmmmm00
	shl	cx, 1
	shl	cx, 1
	shl	cx, 1
	or	cl, ah		; cx = hhhhhmmm mmmsssss

	; Set file creation date/time
	mov	ax, 5701h	; cx=time, dx=date
	int	21h
	jnc	closem
		call	denied		; give whimpy access denied message
		jmp	short next
closem:
	; Close file
	mov	ah, 3eh
	int	21h

next:	mov	bx, finder
	call	fnext		; FIND NEXT
	jnc	doit		; again
	
narg:	call	_shift		; more arguments?
	dec	argc
	jnz	arglp		; nope

	mov	al, 0		; errorlevel= 0 => file found
	jmp	short exit

nlen	= 0
nlen	= nend-noff

nofile:	mov	bx, stderr 	; error device
	mov	cx,	nlen
	mov	dx,	offset nmsg
	mov	ah, 40h
	int	21h
	mov	al, 1		; file not found error
	jmp	short narg

	
	

exit:	mov	ah, 4ch
	int	21h		; terminate process, return status in AL.

ulen	= 0
ulen	=	uend-uoff

usage:	mov	bx, stderr	; write to error device...
	mov	cx, ulen
	mov	dx, offset umsg
	mov	ah, 40h
	int	21h
	mov	al, 2		; error2 = syntax error
	jmp	short exit

alen	= 0
alen	=	aend-aoff

denied: cmp	ax, 5
	jne	nfw		; not access denied
	mov	bx, stderr	; error device
	mov	cx, alen
	mov	dx, offset amsg
	mov	ah, 40h		; write message
	int	21h
	mov	al, 1
	ret

nfw:
	mov	bx, stderr 	; error device
	mov	cx,	nlen
	mov	dx,	offset nmsg
	mov	ah, 40h
	int	21h
	mov	al, 0ffh		; file whiz error
	jmp	short exit

exist	endp


handle	dw	?
	
umsg	db	'Usage: touch filespec [filespec ...]', 13, 10
bugo	db	?
uoff	equ	offset umsg
uend	equ	offset bugo

nmsg	db	"touch: Couldn't touch.", 13, 10
nugo	db	?
noff	equ	offset nmsg
nend	equ	offset nugo

amsg	db	'touch: access denied', 13, 10
augo	db	?
aoff	equ	offset amsg
aend	equ	offset augo


code	ends

	end	exist
