comment #

   Copyright (c) 1992  Thomas G. Hanlin III
   MPRTSC.ASM, assembled with MASM 6.0

   v1.0, 03/16/92: initial version
   have PrtSc copy the color display to the mono display (for dual monitors)

#



ResLength equ (Install - Main + 100h + 0Fh) shr 4



Sseg          segment byte stack 'prog'    ; dummy stack segment
Sseg          ends



Cseg          segment byte public 'prog'
              assume  cs:Cseg, ds:Cseg, ss:Sseg

              org     100h



Main          proc           far
              jmp            Install
Main          endp



; ---------------------- INT 5 (PrtSc vector) --------------------------------



PrtSc         proc           far
              sti                           ;
              push           cx             ;
              push           si             ;
              push           di             ;
              push           ds             ;
              push           es             ;
              mov            cx,0B800h      ;
              mov            ds,cx          ;
              mov            ch,0B0h        ;
              mov            es,cx          ;
              mov            ch,cl          ;
              mov            si,cx          ;
              mov            di,cx          ;
              mov            cx,80*25       ;
              cld                           ;
              rep            movsw          ;
              pop            es             ;
              pop            ds             ;
              pop            di             ;
              pop            si             ;
              pop            cx             ;
              iret                          ; return

OldPrtSc   dw ?,?



; ------------------ INT 2Fh (multiplex interrupt) ---------------------------



MuxHandler:   cmp            ah,0D9h        ; is it for us?
              je             OurMux         ;   yep, go process it
NormMux:      db 0EAh      ; *** self-modifying code: JMP FAR PTR xxxx:yyyy
    MOFS      dw ?         ; original INT 2Fh vector
    MSEG      dw ?

OurMux:       or             al,al          ; status request?
              jnz            OM1            ;   no, skip
              dec            al             ; AL=0FFh to show we're here
              iret                          ;   go directly home
OM1:          cmp            al,1           ; "remove self" request?
              jne            OM9            ;   no, exit
              xor            ax,ax
              mov            es,ax
              cli                           ; interrupts off
              mov            ax,cs:OldPrtSc ; restore old INT 5 vector
              mov            es:[0014h],ax
              mov            ax,cs:OldPrtSc+2
              mov            es:[0016h],ax
              mov            ax,cs:MOFS     ; restore old INT 2Fh vector
              mov            es:[00BCh],ax
              mov            ax,cs:MSEG
              mov            es:[00BEh],ax
              push           cs
              pop            es             ; put current segment in ES
OM9:          iret                          ; return



PrtSc         endp



; ------------------ INSTALLATION routine ---------------------------------



Install       proc           near
              mov            dx,offset HeaderMsg
              mov            ah,9
              int            21h            ; display copyright/header message
              mov            ax,0D900h      ; query status of our handler
              int            2Fh            ; ...on the multiplex interrupt
              mov            INSTALLED,al   ; save results for later
              xor            ax,ax
              mov            es,ax
              mov            ch,ah
              mov            cl,ds:[0080h]  ; get command line length
              or             cx,cx          ;
              jz             Inform         ;   if null, tell 'em about us
              cld
              mov            si,0081h       ; ptr to command line
Parse:        lodsb                         ; get a chr
              cmp            al,"/"         ; slash?
              je             ParseNext      ;   yes, ignore
              cmp            al,"-"         ; hyphen?
              je             ParseNext      ;   yes, ignore
              cmp            al," "         ; space or control?
              jbe            ParseNext      ;   yes, ignore
              cmp            al,"z"         ; alpha chr?
              ja             Inform         ;   no, bad parm
              cmp            al,"a"         ; alpha chr?
              jb             Parse1         ;   no, skip
              xor            al,32          ; convert to lowercase
              jmp            Parse2
Parse1:       cmp            al,"Z"         ; alpha chr?
              ja             Inform         ;   no, bad parm
              cmp            al,"A"         ; alpha chr?
              jb             Inform         ;   no, bad parm
Parse2:       cmp            al,"I"         ; install tsr?
              jne            Parse2d        ;   no
              mov            PINSTALL,1
              jmp            ParseNext
Parse2d:      cmp            al,"R"         ; remove tsr?
              jne            Inform         ;   no
              mov            PREMOVE,1
              jmp            ParseNext
ParseNext:    loop           Parse

SetupDone:    cmp            PREMOVE,0      ; remove clock?
              jne            Remover        ;   yes
              cmp            PINSTALL,0     ; install clock?
              jne            Installer      ;   yes
              jmp            Inform         ;   go tell 'em about us

Remover:      mov            dx,offset NotHereMsg
              cmp            INSTALLED,0    ; is the tsr installed?
              jz             Done           ;   no, done!
              mov            ax,0D901h      ; tell tsr to remove itself
              int            2Fh            ; (returns tsr seg in ES)
              mov            ah,49h         ; free up our memory
              int            21h
              mov            dx,offset RemoveMsg
Done:         mov            ah,9
              int            21h            ; display message
              mov            ax,4C00h       ; terminate with no error code
              int            21h

Installer:    cmp            INSTALLED,0    ; is the tsr installed?
              jz             InstallOk      ;   no, go ahead
              mov            dx,offset AlreadyMsg
              jmp            Done

InstallOk:    mov            es,ds:[002Ch]
              mov            ah,49h         ; release our copy of environment
              int            21h
              xor            ax,ax          ; point to BIOS data area
              mov            es,ax
              mov            cx,ax
              cli                           ; interrupts off
              mov            ax,es:[0014h]  ; get & save the old INT 5 vector
              mov            cs:OldPrtSc,ax
              mov            ax,es:[0016h]
              mov            cs:OldPrtSc+2,ax
              mov            ax,es:[00BCh]  ; get & save the old INT 2Fh vector
              mov            cs:MOFS,ax
              mov            ax,es:[00BEh]
              mov            cs:MSEG,ax
              mov            es:[0016h],cs  ; install new INT 5 handler
              mov word ptr   es:[0014h],offset cs:PrtSc
              mov            es:[00BEh],cs  ; install new INT 2Fh handler
              mov word ptr   es:[00BCh],offset cs:MuxHandler
              sti                           ; interrupts on
              mov            dx,offset InstallMsg
              mov            ah,9
              int            21h            ; display installation message
              mov            dx,ResLength   ; size of interrupt handler (parag)
              mov            ax,3100h       ; terminate and stay resident
              int            21h

Inform:       mov            dx,offset InformMsg
              mov            ah,9
              int            21h            ; display information message
              mov            ax,4C00h       ; exit with error code
              int            21h
Install       endp



; --------------- DATA used only by installation routine ------------------



PINSTALL   db 0               ; whether to install ourselves
PREMOVE    db 0               ; whether to remove ourselves
INSTALLED  db 0               ; whether we're already installed

InstallMsg db 13,10,"MPRTSC installed.",13,10,"$"
RemoveMsg  db 13,10,"MPRTSC removed.",13,10,"$"

AlreadyMsg db 13,10,"Error: a 2MON utility is already installed.",13,10,"$"
MissMsg    db 13,10,"Error: Missing parameter.",13,10,"$"
NotHereMsg db 13,10,"Error: MPRTSC was not installed.",13,10,"$"

HeaderMsg  db "Copyright (c) 1992  Thomas G. Hanlin III",13,10
           db "MPrtSc 1.0: Copy color display to mono display (for dual-monitor systems)",13,10
           db 13,10,"$"

InformMsg  db 13,10
           db "This utility changes the function of the PrtSc (PrintScrn) key.  When it is",13,10
           db "installed, pressing PrtSc copies the color display to the mono display.",13,10
           db 13,10
           db "MPrtSc options:",13,10
           db 13,10
           db "/I        install the TSR",13,10
           db "/R        remove the TSR",13,10
           db "$"



Cseg          ends
              end            Main
