;     (C) Copyright Microsoft Corp. 1991.  All rights reserved.
;
;     You have a royalty-free right to use, modify, reproduce and 
;     distribute the Sample Files (and/or any modified version) in 
;     any way you find useful, provided that you agree that 
;     Microsoft has no warranty obligations or liability for any 
;     Sample Application Files which are modified. 

;*--------------------------------------------------------------------------*
;*                                                                          *
;*  BOOL IsCDROMDrive(int iDrive)                                           *
;*                                                                          *
;*  Determine if passed drive is a CDROM drive controlled by MSCDEX.        *
;*  iDrive = drive index (0=A, 1=B, ...).                                   *
;*                                                                          *
;*  Return boolean.                                                         *
;*                                                                          *
;*--------------------------------------------------------------------------*

cProc IsCDROMDrive, <FAR, PUBLIC>

ParmW iDrive

cBegin
            mov     ax,150Bh        ; MSCDEX driver check API
            xor     bx,bx
            mov     cx,iDrive
            int     2Fh
            cmp     bx,0ADADh       ; was MSCDEX the int 2F guy?
            je      @f              ;    yes, AX != 0 if drive is a CDROM
            xor     ax,ax           ;    no, can't be an MSCDEX CDROM drive
@@:
cEnd

