/*
Fast blit functions
Make 32bit ops in 16bit code
It is safe if your running a 386 or above

Compiled with watcom c++ 10.6
Can be compiled with djgpp v2.
Do not compile with 16bit compilers

Add this to your 16bit code:

void blit(char color)
{__asm{
 push ds
 les di,video_buffer
 lds si,double_buffer
 mov al,color
 mov cx,16000
 db 'blitfunc_1234567890_1'
}}

The above will be like below when your finished exe has runned
through this 32bitfix.exe.

void blit(char color)
{__asm{
 push ds
 les di,video_buffer
 lds si,double_buffer
 mov al,color
 mov cx,16000
 push ds
 push si
 push cx
 rep movsd
 pop cx
 pop di
 pop es
 pop ds
 mov ah,al
 push ax
 shl eax,16
 pop ax
 rep stosd
}}

one more thing is to make sure that your malloc'd double_buffer fits into
mod 4 bytes.(speed)
*/

#include <stdio.h>

void main(short argc,char **argv)
{
 FILE *fp;
 fpos_t filelen,newp,oldp;
 fpos_t i,j;
 int ch,isn;
 char *filemem,*funcstr="blitfunc_1234567890_1",funcstrlen;
 char asmops[]={0x1e,0x56,0x51,0xf3,0x66,0xa5,0x59,0x5f,0x07,0x1f,0x8a,0xe0,0x50,0x66,0xc1,0xe0,0x10,0x58,0xf3,0x66,0xab};

 if(argc<2)
 {
  printf("usage: %s file\n",argv[0]);
  return;
 }
 
 if((fp=fopen(argv[1],"rb+"))==0)
 {
  printf("cannot open file: %s\n",argv[1]);
  return;
 }

 fseek(fp,0,SEEK_END);
 fgetpos(fp,(fpos_t*)&filelen);
 rewind(fp);
 
 filemem=(char*)malloc(filelen);
 if(!filemem)
 {
  printf("no mem\n");
  return;
 }

 for(i=0;i<filelen;i++)
 {
  filemem[i]=fgetc(fp);
 }

 funcstrlen=strlen(funcstr);

 for(i=0;i<filelen;i++)
 {
  if(filemem[i]==funcstr[0])
  {
   isn=1;
   for(j=0;j<funcstrlen;j++)
   {
    if(filemem[i+j]!=funcstr[j])isn=0;
   }
   if(isn)
   {
    printf("found at %i\n",i);
    fseek(fp,i,SEEK_SET);
    for(j=0;j<funcstrlen;j++)
     fputc(asmops[j],fp);
   }
  }
 }
 fclose(fp);
 free(filemem);
}
