;**************************************************************************
;* Program Name: 386DDASC.ASM                                             *
;* Author      : Julio Monroy                                             *
;* Date        : 9/17/92                                                  *
;*                                                                        *
;* Description : This program will take a double-word (4 bytes) and write *
;*               it out to the screen in ASCII format.                    *
;*                                                                        *
;* THIS PROGRAM IS OFFICIALLY DECLARED PUBLIC DOMAIN.  IT CAN BE USED BY  *
;* ANYONE, ANYWHERE TO INCORPORATE INTO THEIR PROGRAM AS THEY WISH.  THIS *
;* CODE MAY BE DISTRIBUTED FREELY AS LONG AS NO MODIFICATIONS ARE MADE TO *
;* THIS FILE.                                                             *
;*                                                                        *
;* Input : On entry, EAX contains the DWORD to write to the screen.       *
;* Output: Displays ASCII number on screen, unformatted.                  *
;**************************************************************************

_code  segment para public 'CODE'
.386
         assume cs:_code,ds:_code,es:_code,ss:_code
    org 100h

top: jmp   begin

; DATA SEGMENT

     divisors dd  1000000000,100000000,10000000,1000000,100000,10000,1000,100,10,1 ; For decimal conversion
     dum      dd  1500222111           ; Number to print to screen, substitute
                                       ; your own number! Just pop into EAX.
dwordwrite  proc  near

    pusha                              ; Save all registers quickly
    mov     esi,offset divisors        ; SI points to divisors
    mov     ecx,9                      ; ECL counter; ECH zero blanker
wordwriteloop:
    mov     ebx,[esi]                  ; Get divisor
    add     esi,4                      ; Increment SI for next one
    sub     edx,edx                    ; Prepare for division
    idiv    ebx                        ; Divide EDX:EAX by EBX
    push    edx                        ; Save remainder
    or      ch,al                      ; See if zero
    jz      leadzero                   ; If so, do not display it
    add     al,'0'                     ; Convert number to ASCII
    mov     dl,al                      ; Print out character
    mov     ah, 2                      ; by calling DOS
    int     21h
leadzero:
    pop     eax                        ; Get back remainder
    dec     cl                         ; Decrement counter
    jg      wordwriteloop              ; If CL still > 0, do it again
    mov     ch,1                       ; No more zero blanking
    jz      wordwriteloop              ; Convert last digit to ASCII
    popa                               ; Restore all registers quickly
    ret

dwordwrite endp


begin:                                 ; Start execution code.

   push cs                             ; Establish data segment
   pop  ds
   mov  eax,dum                        ; Move dword into 386 register
   call dwordwrite                     ; Call dword display routine

   mov  ax,4C00h                       ; Terminate program normally
   int  21h

_code  ends

        dw  64 dup(?)

       end  top

