COMMENT*

 CopyTime.ASM    Written by Julian H. Schmidt and released to the public
 domain.  Assembles with MASM.

 Here's a program I just wrote to determine how much of a difference data
 'alignment' makes with regard to the speed of moving things around in
 memory.
 
 Pseudocode:
 Fill buffer1 with sample data (in word chunks).
 Load CX with a large value for loop control.
 While CX > 0
     Copy data words from buffer1 to buffer2 with MOVSW
 Terminate the program

 END OF COMMENT*
 ;------------------------------------------------------------
 ;Equates:
 DATASIZE = 20480    ;Size in bytes of a data buffer. (20K)
 STACKSIZE = 1024    ;Size (in words) of the stack. (1K)
 ;
 PARAPROG = 1        ;To facilitate conditional assembly:
                     ;Comment this out to de-align the data segment.
 ;
 SAMPLEWORD = "JS"   ;A word of data to put into memory.
 LOOPNUMBER = 0FFFFh ;Number of times to go through the copy process.
 
 ;------------------------------------------------------------
 IFDEF PARAPROG
 
 _data    Segment para public 'DATA'
 one_location    db DATASIZE dup(?)  ;1st data buffer.
 two_location    db DATASIZE dup(?)  ;2nd data buffer.
 _data    Ends
 
 ELSE
 
 _data    Segment    para Public 'DATA'
 a_byte          db ?                ;Mark an unused byte here.
 one_location    db DATASIZE dup(?)  ;1st data buffer.
 two_location    db DATASIZE dup(?)  ;2nd data buffer.
 _data    Ends
 
 ENDIF
 
 ;------------------------------------------------------------
 _code        Segment byte public 'CODE'
     assume cs:_code,ds:_data,es:_data,ss:_stack
 
 Start:                      ;Program entry point.
     mov    ax,_data         ;Make the data segment accessible.
     mov    ds,ax            ; "
     mov    es,ax            ;Point ES to the Data Segment.
     lea    bx,one_location  ;Point BX to beginning of buffer.
     mov    ax,SAMPLEWORD    ;Load a word value into AX.
     mov    cx,DATASIZE/2    ;CX is loop control (number of words).
 
 FillLoop:    ;This is unnecessary - I don't _use_ the data.
     mov    [bx],ax          ;Copy AX's value into memory.
     add    bx,2             ;Move the pointer to the next word.
     loop   FillLoop         ;Loop to fill the entire buffer.
 
     mov    cx,LOOPNUMBER    ;CX is used here for loop control.
 CopyLoop:
     push   cx               ;Save the outer loop counter.
     lea    si,one_location  ;Point SI to beginning of 1st buffer.
     lea    di,two_location  ;Point DI to beginning of 2nd buffer.
     mov    cx,DATASIZE/2    ;CX = number of words to move.
 rep        movsw            ;Move words from one buffer to another.
     pop    cx               ;Restore the outer loop counter.
     loop   CopyLoop         ;Go through the copy process many times.
 
     mov    ax,4c00h         ;Request function 4Ch (DOS).
     int    21h              ;Dos's terminate with return code.
 
 _code    Ends
 
 _stack        Segment para stack 'STACK'
     dw    STACKSIZE   dup (?)
 _stack        Ends
 
 END Start
 
 ---
    Julian'sReader    ...shorter of breath, and one day closer to death...
 
--- SFScan v2.6 (beta)
 * Origin: Wombat's Wagon, Phila, PA (215)331-2590 (1:273/911.0)
