; From  Benjamin L Mcgee - DELAY
;
; ax = number of clock ticks to delay 
; makes no effort to preserve registers 
 
data   segment public 
    outtime dw 2 dup(0) 
data ends 
 
code segment public 
 
dlay proc near 
            public dlay             ; don't know if that's necessary 
            push ax                 ; ax = # ticks to delay 
            xor ax, ax              ; bios get time 
            int 1ah                 ;  
            pop ax                  ; 
            add dx, ax              ; low byte 
            mov outtime, dx         ; save low 
            xor ax, ax              ; 
            adc ax, cx              ; high byte         
            mov outtime + 2, ax     ; save high 
not_yet:             
            xor ax, ax              ; bios get time 
            int 1ah                 ;  
            cmp al, 0               ; has midnight passed 
            jne midnight            ; yup? reset outtime 
            cmp cx, outtime + 2     ; if current hi < outtime hi 
            jb  not_yet             ; then don't timeout 
            cmp dx, outtime         ; if current hi < outtime hi... 
                                    ; AND current low < outtime low 
            jb not_yet              ; then don't timeout 
            jmp its_time            ; 
midnight:                        
            sub outtime, 00B0h      ; since there are 1800B0h ticks a day 
            sbb outtime + 2, 0018h  ; outtime = 1800B0h - outtime 
            jmp not_yet             ; 
its_time:                             
            ret                     ; 
dlay endp 
 
code ends 
 
