;VGA non-standard 256 color routines
;By Matt Pritchard
:Placed in public domain
;With Input from Michael Abrash
;MASM v5.10a used for this

        .MODEL Medium

        VGA_SEGMENT     EQU  0A000H     ;Vga Memory Segment
        SCREEN_XWIDTH   EQU  360        ;Width of screen in Pixels
        SCREEN_WIDTH    EQU  90         ;Width of screen in bytes
        SCREEN_HEIGHT   EQU  240        ;Height of screen

        GC_INDEX        EQU  03CEH      ;VGA Graphics Controller
        SC_INDEX        EQU  03C4H      ;VGA Sequence controller
        CRTC_INDEX      EQU  03D4H      ;VGA CRT Controller
        MISC_OUTPUT     EQU  03C2H      ;VGA Misc Register
        MAP_MASK        EQU  02         ;Map Register #
        READ_MAP        EQU  04         ;Read Map Register #

        FALSE   EQU     0               ;Boolean false constant
        TRUE    EQU     -1              ;boolean true constant

        .DATA

        .CODE

        ;360 x 240 VGA Mode data


VMODE_DATA
        DW      06B00H          ; Horz total
        DW      05901H          ; Horz Displayed
        DW      05A02H          ; Start Horz Blanking
        DW      08E03H          ; End Horz Blanking
        DW      05E04H          ; Start H Sync
        DW      08A05H          ; End H Sync
        DW      00D06H          ; Vertical Total
        DW      03E07H          ; Overflow
        DW      04109H          ; Cell Heigth
        DW      0EA10H          ; V Sync Start
        DW      0AC11H          ; V Sync End/Prot Cr0 Cr7
        DW      0DF12H          ; Vertical Displayed
        DW      02D13H          ; Offset
        DW      00014H          ; Dword Mode off
        DW      0E715H          ; V Blank Start
        DW      00616H          ; V Blank End
        DW      0E317H          ; turn on Byte Mode

; Routine: SET_VGA_MODE
;  Sets up Super high VGA 256 Color RES mode (360 x 240) 
; 
; BASIC: DECLARE SUB SET.VGA.MODEX ALIAS "SET_VGA_MODE" 
; C: void SET_VGA_MODE ();
;

    PUBLIC      SET_VGA_MODE

SET_VGA_MODE    PROC    FAR

    PUSH    BP          ;Save Registers
    PUSH    DS
    PUSH    SI
    PUSH    DI

    MOV     AX, 13H             ; Start with Mode 13H
    INT     10H                 ; Let BIOS Set Mode

    MOV     DX, SC_INDEX        ; Sequencer Addr
    MOV     AX, 0604H           ; Disable Chain 4 Mode
    OUT     DX, AX

    MOV     AX, 0100H           ; (A)synchronous Reset
    OUT     DX, AX

    MOV     DX, MISC_OUTPUT     ; VGA Misc Register
    MOV     AL, 0E7H            ; Use 28Mhz Clock & 60Hz
    OUT     DX, AL

    MOV     DX, SC_INDEX        ; VGA Sequencer Regs
    MOV     AX, 0300H           ; Restart Sequencer...
    OUT     DX, AX

    MOV     DX, CRTC_INDEX      ; Vga crtc Registers
    MOV     AL, 11H             ; cr11
    OUT     DX, AL              ; Load Current Value
    INC     DX                  ; Point to Data
    IN      AL, DX              ; Get CR11
    AND     AL, 7FH             ; Mask out Write Protect
    OUT     DX, AL              ; And send it back

    MOV     DX, CRTC_INDEX      ; Vga Crtc Registers
    CLD                         ; Forward Block Load
    MOV     SI, OFFSET VMODE_DATA       ; Get Parameter Data
    MOV     CX, 17              ; Number of Data Entries

SV3_CPY:
    MOV     AX,CS:[SI]          ; Get Data from Code Segment
    INC     SI                  ; Advance to next word
    INC     SI
    OUT     DX, AX              ; Send to VGA
    LOOP    SV3_CPY             ; Copy all data...

    ;Clear all VGA memory to black

    MOV     DX, SC_INDEX        ; Select All Planes
    MOV     AX, 0F02H
    OUT     DX, AX

    MOV     AX, VGA_SEGMENT     ; Point to VGA memory
    MOV     ES, AX
    MOV     DI, 000

    XOR     AX, AX              ; Clear 256K...
    MOV     CX, 8000H           ; (32K * 2 * 4 planes)
    REP     STOSW

    POP     DI                  ; Restore registers
    POP     SI
    POP     DS
    POP     BP

    RET                         ;We Done.. Outa here

SET_VGA_MODE    ENDP

; Routine: CLEAR_VGA_SCREEN (*Color%)
;  Sets the Entire Screen to one Color
;
; BASIC: DECLARE SUB CLEAR.VGA ALIAS "CLEAR_VGA_SCREEN" _ 
;        (BYVAL ColorNum%) 
; C: pascal void CLEAR_VGA_SCREEN (int Color_Num); 
;

CVS_STACK STRUC
                DW      ?       ;saved DI
                DW      ?       ;saved BP
                DD      ?       ;Caller
    CVS_COLOR   DB      ?,?     ;Color to Fill With CVS_STACK ENDS

    PUBLIC      CLEAR_VGA_SCREEN

CLEAR_VGA_SCREEN        PROC    FAR

    PUSH    BP                  ; Save registers
    PUSH    DI

    MOV     BP,SP               ; Setup Stack frame

    MOV     DX, SC_INDEX        ; Select All Panes
    MOV     AX, 0F02H           ; Map Mask (02) = 0F
    OUT     DX, AX

    MOV     AX, VGA_SEGMENT     ; Point to VGA memory
    MOV     ES, AX
    MOV     DI, 0

    MOV     AL,[BP].CVS_COLOR   ; Get Color to set
    MOV     AH,AL               ; Copy for Word Write

    MOV     CX, 10800           ; # of bytes in 360x240 mode
    REP     STOSW               ; Blast it!

    POP     DI                  ; restore registers
    POP     BP

    RET     2                   ; exit & clean up stack

CLEAR_VGA_SCREEN        ENDP

; Routine: SETPOINT (*Xpos1, *Ypos1%, *ColorNum%) 
;   Sets a single pixel in 360x240 256 color mode 
; 
; BASIC: DECLARE SUB SETPOINT (BYVAL X%, BYVAL Y%, BYVAL ColorNum%) 
; C: pascal void SETPOINT (int Xpos, int Ypos, int Color_num);
;

SP_STACK STRUC
                DW      ?       ;saved BP
                DD      ?       ;Caller
    SETP_COLOR  DB      ?,?     ;Pixel color
    SETP_YPOS   DW      ?       ;Pixel Y pos
    SETP_XPOS   DW      ?       ;Pixel X pos SP_STACK ENDS

    PUBLIC SETPOINT

SETPOINT    PROC    FAR

    PUSH    BP                  ;Save base pointer

    MOV     BP,SP               ;Set up stack frame

    MOV     AX, SCREEN_WIDTH    ;Get Screen Line Width
    MUL     [BP].SETP_YPOS      ;AX = Ypos * 90

    MOV     BX,[BP].SETP_XPOS   ;Get Xpos
    MOV     CX, BX              ;Save copy of Xpos
    SHR     BX, 1               ;XByte = Xpos/4
    SHR     BX, 1

    ADD     BX,AX               ;BX = 90 * Ypos + Xpos/4

    MOV     AX, 0102h           ;Plane Mask & Select Register
    AND     CL, 3               ;Get plane # from Xpos
    SHL     AH, CL              ;Shift to Get Plane Value
    MOV     DX, SC_INDEX        ;Setup to select plane

    OUT     DX, AX              ;Select Plane...

    MOV     AX,VGA_SEGMENT      ;Setup Vga Segment
    MOV     ES,AX

    MOV     AL,[BP].SETP_COLOR  ;Get Color

    MOV     ES:[BX], AL         ;Draw Point

    POP     BP                  ;Restore Bp

    RET     6                   ;Exit and Clean up Stack

SETPOINT    ENDP

; Routine: int READPOINT (*Xpos, *Ypos%)
;    Returns the color of single pixel in AX 
; 
; BASIC: DECLARE FUNCTION READPOINT% (BYVAL X%, BYVAL Y%) 
; C: pascal void READPOINT (int Xpos, int Ypos);
;

RP_STACK STRUC
                DW      ?       ;saved Bp
                DD      ?       ;Caller
    RP_YPOS     DW      ?       ;Pixel Y pos
    RP_XPOS     DW      ?       ;Pixel X pos RP_STACK ENDS

    PUBLIC      READPOINT

READPOINT        PROC    FAR

    PUSH    BP

    MOV     BP,SP               ;Set up stack frame

    MOV     AX, SCREEN_WIDTH    ;Get Screen Line Width
    MUL     [BP].RP_YPOS        ;AX = Ypos * Screen Width

    MOV     BX,[BP].RP_XPOS     ;Get Xpos
    MOV     CX, BX              ;Save Copy of Xpos
    SHR     BX, 1               ;XByte = Xpos/4
    SHR     BX, 1

    ADD     BX,AX               ;BX = Screen_Width * Ypos + Xpos/4

    MOV     AL, READ_MAP        ;GC Read Mask Register
    MOV     AH, CL              ;Get Xpos
    AND     AH, 3               ;& mask out Plane #
    MOV     DX, GC_INDEX        ;Setup to select Read Mask

    OUT     DX, AX              ;Select Plane...

    MOV     AX,VGA_SEGMENT      ;Setup Vga Segment
    MOV     ES,AX

    XOR     AX,AX               ;Clear Return Value

    MOV     AL,ES:[BX]          ;Get Color of Pixel

    POP     BP                  ;Restore registers

    RET     4                   ;Exit and Clean up Stack

READPOINT        ENDP

; EOF VGAMODEX.ASM
