; Before running this program, make sure the LASTDRIVE= statement in your
; CONFIG.SYS file is large enough to accomodate the extra drive(s).

              PROC   NEAR                 ; Make all RETs near RETs

              MOV    AX,OFFSET INIT       ; Push start address of init.
              PUSH   AX                   ;    code on stack
              MOV    CX,OFFSET END - 32H  ; Get size of prog. minus this
                                          ;    routine in CX
              MOV    SI,OFFSET FIRSTBYTE  ; Start of code to be moved
              MOV    DI,32H               ; Move it into PSP
              REP
              MOVSB
              RET

; The RET above is actually overwritten during the move, but is being
; executed out of the prefetch queue, and in the process, it forces the
; prefetch queue to be flushed and reloaded before continuing at INIT.


FIRSTBYTE     ORG    32H                  ; Reset WASM's internal PC

; The new INT 13h handler begins here:

INT13         STI                         ; Enable interrupts
              PUSH   DS                   ; Save registers
              PUSH   ES
              PUSH   AX
              MOV    AX,0D800H            ; Get RLL BIOS segment in ES
              MOV    ES,AX
              XOR    AX,AX                ; Set DS to zero
              MOV    DS,AX
              TEST   DL,80H               ; Is this a hard drive?
              JZ     (TOINT13.1)          ; No, go to original handler
              AND    DL,7FH               ; Yes, clear bit 7
              SEG    CS
              CMP    DL,OTHERHDS          ; Is it on 1st controller
                                          ;    (IDE)?
              JB     TOINT13.1HD          ; Yes, turn bit 7 back on and
              SEG    CS                   ;    go to original handler
              SUB    DL,OTHERHDS          ; No, tell RLL handler it's
              SEG    ES                   ;    drive C or D
              MOV    AL,[3F8EH]           ; Get # of RLL drives
              MOV    [0475H],AL           ; Tell RLL handler there are
                                          ;    no other HDs
              OR     DL,80H               ; Turn bit 7 back on
              SEG    CS
              MOV    AX,RLL1              ; Store far pointer to 1st
              MOV    [0104H],AX           ;    RLL parameter table in
              SEG    CS                   ;    INT 41H vector
              MOV    AX,RLL1 + 2
              MOV    [0106H],AX
              SEG    CS
              MOV    AX,RLL2              ; Store far pointer to 2nd
              MOV    [0118H],AX           ;    RLL parameter table in
              SEG    CS                   ;    INT 46H vector
              MOV    AX,RLL2 + 2
              MOV    [011AH],AX
              POP    AX                   ; Restore registers
              POP    ES
              POP    DS
              PUSHF                       ; Push flags for IRET
              SEG    CS
              CALL   DWORD INT13.2        ; Call RLL INT 13H Handler
              PUSHF                       ; Save flags
              PUSH   DS                   ; Save registers
              PUSH   ES
              PUSH   AX
              MOV    AX,0D800H            ; Get RLL BIOS segment in ES
              MOV    ES,AX
              XOR    AX,AX                ; Set DS to zero
              MOV    DS,AX
              SEG    CS
              MOV    AL,OTHERHDS          ; Get # of IDE drives
              SEG    ES
              ADD    AL,[3F8EH]           ; Add # of RLL drives
              MOV    [0475H],AL           ; Store in BIOS data area
              POP    AX                   ; Restore registers
              POP    ES
              POP    DS
              POPF                        ; Restore flags
              RETF   2                    ; Return from INT

(TOINT13.1)   JMPS   TOINT13.1            ; Springboard to orig.
                                          ;    INT 13H handler

TOINT13.1HD   OR     DL,80H               ; Turn bit 7 of drive # on
              SEG    CS
              MOV    AX,IDE1              ; Store far pointer to 1st
              MOV    [0104H],AX           ;    IDE parameter table in
              SEG    CS                   ;    INT 41H vector
              MOV    AX,IDE1 + 2
              MOV    [0106H],AX
              SEG    CS
              MOV    AX,IDE2              ; Store far pointer to 2nd
              MOV    [0118H],AX           ;    IDE parameter table in
              SEG    CS                   ;    INT 41H vector
              MOV    AX,IDE2 + 2
              MOV    [011AH],AX
TOINT13.1     POP    AX                   ; Restore registers
              POP    ES
              POP    DS
              SEG    CS                   ; Jump to original INT 13h
              JMP    DWORD INT13.1        ;    handler


OTHERHDS      DB     0      ; # of HDs on 1st controller

INT13.1       DW     0,0    ; Far pointer to orig. (IDE) INT 13H handler
INT13.2       DW     0,0    ; Far pointer to ST21R (RLL) INT 13H handler

IDE1          DW     0,0    ; Far pointer to 1st IDE parameter table
IDE2          DW     0,0    ; Far pointer to 2nd IDE parameter table

RLL1          DW     0,0    ; Far pointer to 1st RLL parameter table
RLL2          DW     0,0    ; Far pointer to 2nd RLL parameter table

RLL1_DATA     DW     -1,70H ; 1st RLL drive data table
              DS     60H
RLL1DPB       DS     21H    ; 1st RLL Drive Parameter Block (DPB)

RLL2_DATA     DW     -1,70H ; 2nd RLL drive data table
              DS     60H
RLL2DPB       DS     21H    ; 2nd RLL Drive Parameter Block (DPB)

LAST_PHYS_DR  DB     0      ; Last physical drive #
LAST_LOG_DR   DB     0      ; Last logical drive #


INIT          PUSH   DS
              PUSH   ES
              MOV    AX,0D800H            ; Get RLL BIOS segment in ES
              MOV    ES,AX
              XOR    AX,AX
              SEG    ES
              TEST   BYTE [3F8EH],0FFH    ; Has this prog. already run?
              JNZ    (DONE)               ; If so, don't run it again
              MOV    DS,AX                ; Set DS to zero
              SEG    ES                   ; Restore memory locations
              MOV    [3F8CH],AL           ;    altered by ST21R error
              SEG    ES                   ;    routine, retrieving total
              XCHG   [3F80H],AL           ;    # of HDs in the process
              SUB    AL,[0475H]           ; Subtract # of IDE HDs, which
              SEG    ES                   ;    leaves the # of RLL HDs
              MOV    [3F8EH],AL           ; Store it in ST21R data area
              XCHG   AL,[0475H]           ; Save # of IDE HDs and tell
              SEG    CS                   ;    ST21R no HDs installed
              MOV    OTHERHDS,AL
              MOV    AX,[0104H]           ; Save far pointer to 1st IDE
              SEG    CS                   ;    parameter table (found in
              MOV    IDE1,AX              ;    INT 41H vector)
              MOV    AX,[0106H]
              SEG    CS
              MOV    IDE1 + 2,AX
              MOV    AX,[0118H]           ; Save far pointer to 2nd IDE
              SEG    CS                   ;    parameter table (found in
              MOV    IDE2,AX              ;    INT 46H vector)
              MOV    AX,[011AH]
              SEG    CS
              MOV    IDE2 + 2,AX
              PUSH   WORD [4EH]           ; Save DOS' INT 13h handler
              PUSH   WORD [4CH]           ;    on stack
              PUSH   CS                   ; Push far pointer to where
              MOV    AX,OFFSET CONTINUE   ;    we want to return after
              PUSH   AX                   ;    installation is complete
              DB     60H                  ; PUSHA (ST21R needs this
              CLD                         ;    to finish installation)
              PUSH   DS                   ; Save DS and ES
              PUSH   ES
              MOV    AX,CS                ; Save 512 bytes from
              MOV    ES,AX                ;    0000:7C00 so ST21R can
              MOV    SI,7C00H             ;    use this area as a
              MOV    DI,OFFSET END        ;    temporary buffer
              MOV    CX,100H
              REP
              MOVSW
              POP    DS                   ; Restore DS and ES, but in
              POP    ES                   ;    reverse order (for ST21R)
              JMP    0186H,0D800H         ; Force ST21R to install itself
                                          ; Return to CONTINUE when done

(DONE)        JMP    DONE                 ; Springboard to end of prog.

; After the ST21R has finished installing itself, it will return here.
; Now all we have to do is tie up the loose ends, change the INT 13h
; vector to our own handler, and make DOS aware of the new drive(s).

CONTINUE      PUSH   DS                   ; Save DS and ES
              PUSH   ES
              MOV    AX,CS                ; Restore 512 bytes back to
              MOV    DS,AX                ;    0000:7C00
              MOV    SI,OFFSET END
              MOV    DI,7C00H
              MOV    CX,100H
              REP
              MOVSW
              POP    DS                   ; Restore DS and ES in reverse
              POP    ES                   ;    order
              MOV    AX,[0104H]           ; Save far pointer to 1st RLL
              SEG    CS                   ;    parameter table (found in
              MOV    RLL1,AX              ;    INT 41H vector)
              MOV    AX,[0106H]
              SEG    CS
              MOV    RLL1 + 2,AX
              MOV    AX,[0118H]           ; Save far pointer to 2nd RLL
              SEG    CS                   ;    parameter table (found in
              MOV    RLL2,AX              ;    INT 46H vector)
              MOV    AX,[011AH]
              SEG    CS
              MOV    RLL2 + 2,AX
              SEG    CS
              MOV    AL,OTHERHDS          ; Get # of IDE HDs
              SEG    ES
              ADD    AL,[3F8EH]           ; Add # of RLL HDs
              MOV    [0475H],AL           ; Save in BIOS data area
              MOV    AX,[4CH]             ; Save RLL INT 13h handler
              SEG    CS
              MOV    INT13.2,AX
              MOV    AX,[4EH]
              SEG    CS
              MOV    INT13.2 + 2,AX
              POP    WORD [4CH]           ; Restore DOS' INT 13h handler
              POP    WORD [4EH]           ;    from stack

; The following section of code will hook INT 13h without disabling the
; filter(s) inserted ahead of the original BIOS handler by DOS.  If the
; INT 13h handler is hooked in any other way, the system will likely halt
; with a Memory Allocation Error after formatting a drive.

              MOV    AH,13H               ; Get addr. to restore INT 13h
              INT    2FH                  ;    to on system halt or warm
                                          ;    boot in ES:BX and old
                                          ;    INT 13h handler in DS:DX
              SEG    CS
              MOV    INT13.1,DX           ; Save old INT 13h handler
              SEG    CS
              MOV    INT13.1 + 2,DS
              MOV    AX,CS                ; Point DS:DX to new INT 13h
              MOV    DS,AX                ;    handler (leave ES:BX as
              MOV    DX,OFFSET INT13      ;    it was)
              MOV    AH,13H               ; Give these addresses back to
              INT    2FH                  ;    DOS

; Our new INT 13h handler is now active, and can be used to access all
; hard drives.  DOS is still unaware that the new drives exist, however.

              MOV    AX,0803H             ; Get pointer to first drive
              INT    2FH                  ;    data table in DS:DI
NEXTTABLE     MOV    AX,[DI + 4]          ; Get physical drive # in AL,
                                          ;    logical drive # in AH
              LDS    DI,[DI]              ; Get pointer to next table
              INC    DI                   ; If the offset is 0FFFFh,
              JZ     FOUNDLAST            ;    then exit this loop
              DEC    DI
              JMPS   NEXTTABLE            ; Else, repeat
FOUNDLAST     SEG    CS                   ; Save last physical drive
              MOV    WORD LAST_PHYS_DR,AX ;    and last logical drive
              MOV    BX,OFFSET RLL1_DATA  ; Set up first RLL HD
              CALL   SETUP
              MOV    AX,[3F8EH]           ; How many RLL HDs are there?
              DEC    AX
              JZ     DONE                 ; If only one, we're done
              MOV    BX,OFFSET RLL2_DATA  ; Else, set up the other RLL HD
              CALL   SETUP
DONE          POP    ES                   ; Restore DS and ES
              POP    DS
              SEG    CS
              MOV    ES,[2CH]             ; Free environment block
              MOV    AH,49H
              INT    21H
              LEA    DX,[BX + 84H]        ; Get end of resident portion
                                          ;    and convert to paragraphs
              DB     0C1H,0EAH,4          ; SHR DX,4
              INC    DX
              MOV    AX,3100H             ; Terminate and Stay Resident
              INT    21H                  ;    (TSR)


SETUP         MOV    AX,CS                ; Point DS and ES to this
              MOV    DS,AX                ;    segment
              MOV    ES,AX
              MOV    [BX + 2],CS          ; Ptr. to next table = CS:FFFF
              MOV    AL,LAST_PHYS_DR      ; Get last physical drive #
              INC    AL                   ; Add 1
              MOV    [BX + 4],AL          ; Store in table
              MOV    DL,AL                ; Move to DL for sector read
              MOV    LAST_PHYS_DR,AL      ; Update last physical drive #
              MOV    AL,LAST_LOG_DR       ; Get last logical drive #
              INC    AL                   ; Add 1
              MOV    [BX + 5],AL          ; Store in table
              MOV    LAST_LOG_DR,AL       ; Update last logical drive #
              MOV    DI,BX                ; Save table offset in DI
              MOV    AX,0201H             ; Prepare to read 1 sector
              MOV    CX,1                 ; Start at track 0 sector 1
              XOR    DH,DH                ; Head 0
              MOV    BX,OFFSET END        ; Place buffer at end of code
              INT    13H                  ; Read Master Boot Record
              MOV    SI,01BEH             ; Point SI to partition 1 data
              MOV    DH,[BX + SI + 1]     ; Get partition 1 starting hd.,
              MOV    CX,[BX + SI + 2]     ;    sector, and cylinder
              MOV    DL,[DI + 4]          ; Get drive # from table
              MOV    AX,0201H             ; Prepare to read 1 sector
              INT    13H                  ; Read partition 1 boot sector
              MOV    BX,DI                ; Get table offset back in BX
              ADD    DI,6                 ; Point DI to BIOS Param. Block
              MOV    SI,OFFSET END + 0BH  ; Copy BPB from boot sector
              MOV    CX,19H               ;    to drive data table
              CLD
              REP
              MOVSB
              ADD    DI,8                 ; Point DI to 2nd BPB in table
              MOV    SI,OFFSET END + 0BH  ; Copy BPB from boot sector
              MOV    CX,19H               ;    to 2nd BPB in table (BPB
              REP                         ;    for highest capacity
              MOVSB                       ;    supported)
              ADD    SI,7                 ; Copy volume label from boot
              MOV    CX,0BH               ;    sector
              ADD    DI,CX                ; Copy it to drive data table
              REP
              MOVSB
              ADD    DI,5                 ; Copy filesystem type ('FAT12   '
              MOV    CX,4                 ;    or 'FAT16   ') from boot
              REP                         ;    record to table
              MOVSW
              SUB    SI,17H               ; Copy volume serial # from
              SUB    DI,0CH               ;    boot sector to table
              MOV    CX,2
              REP
              MOVSW
              DEC    CX                   ; CX = FFFF
              MOV    [BX + 47H],CX        ; Store in table (time of last
              MOV    [BX + 49H],CX        ;    access - FFFFFFFF = never)
              MOV    BYTE [BX + 22H],5    ; Set device type in table to
                                          ;    fixed disk
              MOV    BYTE [BX + 23H],21H  ; Set bit flags for drive
              MOV    DL,[BX + 4]          ; Get drive # from table
              PUSH   BX                   ; Save table offset on stack
              MOV    AH,8                 ; Get drive parameters
              INT    13H
              POP    BX                   ; Get table offset back in BX
              DB     0C0H,0E9H,6          ; SHR CL,6 - move bits 6 and 7
              XCHG   CH,CL                ;    to high end of CH
              INC    CX                   ; Add 1 to get # of cylinders
              MOV    [BX + 25H],CX        ; Store it in drive data table
              XOR    AL,AL                ; All bits off in AL
              CMP    BYTE [BX + 5FH],36H  ; Check for '6' in 'FAT16   '
              JNE    FATTYPE              ; If not, bit 6 off = 12 bit FAT
              MOV    AL,40H               ; Else, bit 6 on = 16 bit FAT
FATTYPE       MOV    [BX + 1FH],AL        ; Store it in drive data table
              MOV    DI,BX                ; Move table offset to DI
              MOV    AX,0801H             ; Append table to chain of
              INT    2FH                  ;    tables
              MOV    BX,DI                ; Get table offset back in BX
              LEA    BP,[BX + 64H]        ; Point BP to buffer for DPB
              LEA    SI,[BX + 6]          ; Point SI to BPB in table
              MOV    AH,53H               ; Translate BPB to DPB
              INT    21H
              MOV    AX,[BX + 5]          ; Get logical drive #
              SEG    ES
              MOV    [BP],AX              ; Store it in DPB as drive #
              SEG    ES                   ; Store it in DPB as unit #
              MOV    [BP + 1],AX          ;    within device driver
              MOV    DX,BX                ; Save table offset in DX
              MOV    AH,52H               ; Get pointer to List of
              INT    21H                  ;    Lists (LoL) in ES:BX
              SEG    ES                   ; Get pointer to 1st DPB
              LDS    SI,[BX]              ;    in DS:SI
              LDS    DI,[SI + 13H]        ; Get far pointer to device
              SEG    CS                   ;    driver header in DS:DI
              MOV    [BP + 13H],DI        ; Store it in DPB
              SEG    CS
              MOV    [BP + 15H],DS
              MOV    AX,0FFFFH            ; Set pointer to next DPB to
              SEG    CS                   ;    FFFF:FFFF
              MOV    [BP + 19H],AX
              SEG    CS
              MOV    [BP + 1BH],AX
              XCHG   BX,DX                ; Get table offset back in BX
              SEG    CS                   ;    (save LoL pointer in DX)
              MOV    AL,[BX + 5]          ; Get logical drive number
              ADD    AL,41H               ; Convert to ASCII (0=A, etc.)
              XCHG   BX,DX                ; Get LoL pointer back in BX
              SEG    ES                   ; Get pointer to Current
              LDS    SI,[BX + 16H]        ;    Directory Structure (CDS)
NEXTCDS       CMP    AL,[SI]              ; Is this the right entry?
              JE     FOUNDCDS             ; Yes, exit loop
              ADD    SI,58H               ; No, go to next entry
              JMPS   NEXTCDS
FOUNDCDS      MOV    [SI + 45H],BP        ; Store DPB pointer in CDS
              MOV    [SI + 47H],CS
              SEG    ES                   ; Change # of blk devices
              INC    BYTE [BX + 20H]      ;    installed
DPBLINK       LDS    SI,[SI - 13H]        ; Change "pointer to next DPB"
              MOV    [SI + 19H],BP        ;    in previous DPB
              MOV    [SI + 1BH],CS
              MOV    BX,DX                ; Get table offset back in BX
              SUB    AL,41H               ; Convert ASCII drive to
              MOV    DL,AL                ;    logical drive # in DL
              MOV    AX,5F07H             ; Enable drive
              INT    21H
              RET                         ; Return to main program

END           ENDP
