;------------------------------------
; atz.asm - Slightly tweaked from the original.
; David Kirschbaum Toad Hall

TITLE   ATZ     5-11-90 [3-19-94]

LF      EQU     0AH
CR      EQU     0DH

COM1    EQU     03F8H
COM2    EQU     02F8H

CSEG    SEGMENT
        ASSUME DS:CSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
        ORG     100H

ATZ     PROC    NEAR
        mov     si,offset str           ;string we wish to send to modem
        mov     dx,COM1                 ;comm port of your choice
        mov     bx,5                    ;handy constant for port offsets
CharLup:
        lodsb
        or      al,al                   ;0 terminates the string
        jz      Terminate               ;done
        call    Send_Char
        jmp     CharLup

Terminate:
        mov     ax,4C00H                ;terminate
        int     21H
ATZ     ENDP


Send_Char       PROC    NEAR
        mov     ah,al                   ;char to send to modem
        add     dx,bx                   ;modem port offset constant

Wait:   in      al,dx                   ;read comm port status
        and     al,20H                  ;clear to send?
        jz      Wait                    ;not yet
        mov     al,ah                   ;char to send to modem
        sub     dx,bx                   ;back to comm port base
        out     dx,al                   ;send the char
        ret
Send_Char       ENDP


str     DB      'ATZ',CR,0              ;String we wish to send

CSEG    ENDS
        END     ATZ

