;----------------------------
; flat386.asm - Herman Dullink
;  OK, try this... ( To make use of >1Mb addresses, you'll have to enable )
;                  ( the A20 line. This is another story...               )

.386p

code    segment use16

        org     100h
flat    proc

        xor     eax,eax
        mov     ax,ds                   ; Build Global Descriptor Table
        shl     eax,4
        add     dword ptr ds:GDTR[2],eax

        lgdt    qword ptr ds:GDTR       ; Load GDT Register

        cli                             ; We don't want ANY interrupts...
        mov   eax,CR0
        or    al,1                      ; Enter Protected mode
        mov   CR0,eax
        
        mov     bx,FLAT_sel             ; fs will have 4Gbyte limit :-)
        mov     fs,bx

        and   al,not 1                  ; Back to Real mode
        mov   CR0,eax
        sti                             ; We can have interrupts now

        ret                             ; Done :-)

flat    endp

GDT             dd      0,0

FLAT_desc       dw      0ffffh          ; Limit (bit 0..15)
                db      ?,?,?           ; Base (bit 0..23)
                db      92h             ; Access rights
                db      0cfh            ; Page granularity + Limit(16..19)
                db      ?               ; Base (bit 24..31)

GDTR            dw      $ - GDT         ; Limit (16 bytes)
                dd      offset GDT      ; Offset within current segment...
                dw      0

FLAT_sel        equ     FLAT_desc - GDT_desc

code    ends
        end     flat
