;-------------------------
; prnt.asm - Output a text file to Epson printer in small print.
; by James Vahn

cseg segment
assume  cs:cseg,ds:cseg
org 100h                                ;COM format

Begin:
        mov     cx,7                    ;Count the 7 bytes used
        mov     si,offset msg           ;to setup the printer.
   lo1: mov     dx,0                    ;LPT1
        mov     ah,0
        lodsb                           ;mov al,ds:[si] : inc si
        int     17h                     ;Send AL to printer.
        loop    lo1                     ;Get more data until CX=0

        mov     si,82h
        cmp     byte ptr[si-2],0        ;No filename! Exit.
        je      error

  lo2:  lodsb                           ;Find filename in PSP
        cmp     al,0Dh                  ;terminated with 0Dh.
        jne     lo2
 open:
        mov     byte ptr [si-1],0h      ;Filename delimiter.
        mov     ax,3D00h                ;Open for read.
        mov     dx,82h
        int     21h
        jc      error                   ;Bad filename. Exit.
        mov     word ptr [hndl],ax      ;Save the file handle.
 read:
        mov     bx,word ptr [hndl]
        mov     ah,3Fh
        mov     cx,01h                  ;Get one byte.
        mov     dx,offset buf
        int     21h
        jc      error                   ;Bad file read, exit.
        or      ax,ax                   ;End of file?
        je      exit

        mov     dx,0                    ;LPT1
        mov     ah,0
        mov     al,byte ptr[buf]        ;Send the character
        int     17h                     ;to the printer.
        jmp     read
 exit:
        mov     ax,4C00h
        int     21h                     ;Normal exit to DOS.
 error:
        mov     ah,09h
        mov     dx,offset errmsg        ;Print error message.
        int     21h

        mov     ax,4C01h                ;Exit errorlevel 1.
        int     21h

 buf     db 0                           ;Temp data storage.
 hndl    dw 0                           ;File handle storage.
 msg     db 27,51,15,27,83,0,15         ;Fine print mode.
 errmsg  db 'Outputs a text file to Epson printer in small print.',13,10
         db 'Useage: PRNT filename.ext',13,10,36

cseg ends
end Begin
