cseg segment
assume cs:cseg
org 100h
Begin:

        call    CHECK_ANSI
        jc      noansi
        mov     dx,offset msg1
        jmp     exit
 noansi:
        mov     dx,offset msg2
 exit:
        mov     ah,9
        int     21h
        int     20h

 msg1   db 'ANSI',13,10,36
 msg2   db 'No ANSI',13,10,36

;---------------------------
;CHECK_ANSI - check if ANSI active by Jeff Owens
; bugfix by Jerry Coffin
;
; inputs:    none
; 
; output:    CF = 1 if no ANSI driver active
;            CF = 0 if ANSI active
;* * * * * * * * * * * * * *

	public	CHECK_ANSI
CHECK_ANSI		PROC	FAR

     mov     bx,1
     call    is_device       ;Test if redirected.
     jnc     no_ansi
     PUSH    AX
     PUSH    DX
     PUSH    DS
     MOV     AX,CS
     MOV     DS,AX
     CALL    console_input
     CALL    CHECK_ANSI_cont1

     DB	     1BH,'[6n$'
;
CHECK_ANSI_cont1:
     POP     DX
     CALL    console_output
     MOV     AH,0Bh		;check STDIN status, al=ff if input
     INT     21h
     CMP     AL,0FFh
     JZ      IA_1		;jmp if char. is ready from ansi call
     CALL    isansi_cont2

     db	     0dH,'    ',0dH,'$'

isansi_cont2:
     POP	DX
     CALL    console_output
     STC
     JMP     IA_2
IA_1:
     CALL    console_input
     CLC
IA_2:
     POP     DS
     pop     DX
     POP     AX
     JB      NO_ANSI
     CLC
     RETF
NO_ANSI:
     STC
     RETF
CHECK_ANSI	ENDP
;------------------------------
console_output:
     MOV     AH,09
     INT     21h
     RET

console_input:
     MOV     AH,06
     MOV     DL,0FFh
     INT     21h
     JNZ     console_input
     RET

is_device proc
; call with: a file handle in BX. Use AX, DX.
; returns: carry clear: handle refers to a file
;          carry set:    handle refers to a device.
;
        mov     ax,4400h
        int     21h
        rcl     dl,1
        ret
is_device endp

cseg ends
end Begin
