; From  Mikko Hyvarinen - OS detection

.386
jumps
locals

cseg segment para use16 public 'code'
assume cs:cseg, ds:cseg, ss:cseg

org 100h

start:
    jmp real_start

msg_no_os2      db  'OS/2 not detected', 13, 10, '$'
msg_os2_2x      db  'OS/2 2.x detected', 13, 10, '$'
msg_os2_warp    db  'OS/2 Warp detected', 13, 10, '$'
msg_no_win      db  'Windows 3.1+ not detected', 13, 10, '$'
msg_win         db  'Windows 3.1+ detected', 13, 10, '$'

real_start:
    mov ax, 4010h
    int 2fh
    cmp ax, 4010h
    jz @@not_installed
    or ax, ax
    jz @@os2_warp
    mov dx, offset msg_os2_2x
    mov ax, 0900h
    int 21h
    jmp @@test_win
@@not_installed:
    mov dx, offset msg_no_os2
    mov ax, 0900h
    int 21h
    jmp @@test_win
@@os2_warp:
    mov dx, offset msg_os2_warp
    mov ax, 0900h
    int 21h
    jmp @@test_win
@@end:
    mov ax, 4c00h
    int 21h
@@test_win:
    mov ax, 160ah
    int 2fh
    or ax, ax
    jz @@win_found
    mov dx, offset msg_no_win
    mov ax, 0900h
    int 21h
    jmp @@end
@@win_found:
    mov dx, offset msg_win
    mov ax, 0900h
    int 21h
    jmp @@end

cseg ends
end start
