 ;Randomizer is a procedure that will return a random (pseudo-random)
 ;  number in the al register.
 ;It must be supplied with a seed number (currently in a global
 ;  variable called Seed.  (Fill Seed with the 16-bit seconds and
 ;  hundreds of seconds value from Dos's Int21h/Function2Ch).
 
     Code_Seg    segment
     assume  cs:Code_Seg,ds:Randomizer_Data,ss:Stack
 
 Randomizer  proc    far        ;This procedure generates an 8-bit
                                ;  random number and passes it in AL.
      push    cx                ;Save caller's cx.
      push    dx                ;Save caller's dx.
 
      mov     ax,Seed           ;move Seed into ax.
      mov     cx,8              ;Number of bits to be generated.
 Next:
      xor     dx,dx
      test    ax,02             ;Is bit 1 = 1?
      jz      Bit1e0            ;If bit 1 = 0, (DL) <- 0.
      mov     dl,1              ;If bit 1 = 1, (DL) <- 1.
 Bit1e0:      test    ax,04     ;Is bit 2 = 1?
      jz      Bit2e0            ;If bit 2 = 0, (DH) <- 0.
      mov     dh,1              ;If bit 2 = 1, (DH) <- 1.
 Bit2e0:      xor    dl,dh      ;DL (bit 0) <- xor of ax (bits 1 & 2).
      shr     dl,1              ;Carry flag <- DL (bit 0).
      rcr     ax,1              ;Rotate ax moving the carry flag
                                ;  into the high bit of ax.
      loop    next              ;Loop 8 times until cx = 0.
                                ;New 8-bit random number now in al.
      mov     seed,ax           ;Current random # becomes new seed.
      pop     dx                ;Restore caller's dx register.
      pop     cx                ;Restore caller's cx register.
      ret                       ;Return!
 Randomizer  endp
 
 Rand         proc    far
 
      mov     ax,Randomizer_Data
      mov     ds,ax            ;Set up the data segment.
    ;Now, I must get a seed number.  I'll use seconds
    ;  & hundredths of seconds from the system time.
      mov     ax,2C00h         ;Request function 2Ch.
      int     21h              ;Dos's Get System Time.
      mov     Seed,dx          ;Fill in the seed with time.
 
      mov     cx,40            ;Set loop counter equal to 40.
 Rloop:       call    Randomizer    ;Get 8-bit random number.
      mov     dl,al            ;(DL) <- random integer in (AL).
      mov     ah,2             ;Set ah for character display.
      int     21h              ;call DOS display function.
      loop    Rloop            ;loop 40 times.
 
      mov     ax,4c00h         ;Request function 4Ch.
      int     21h              ;Dos's Terminate with return code.
 
     Code_Seg    ends
 
 Randomizer_Data    segment
 Seed        dw ?              ;Put data here
 Randomizer_Data    ends
 
 Stacks       segment stack
     db       20 dup("STACK")
 Stacks       ends
     End      Rand

 
 Here's the basis of how this procedure gets a random number:
 
     15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
                                                       SHIFTED OUT
                   16 BIT REGISTER                                >
                                                        BITS LOST
                                                 
                                                 
       SHIFT IN RESULT        EXCLUSIVE OR       
                              BITS 1 AND 2       
       OF EXCLUSIVE OR                      
 
 An initial SEED integer is placed in a 16-bit register (shown above).
 An exclusive OR is performed on bits 1 and 2 of the register.  The
 result is shifted into the most significant bit of the register with the
 other bits in the register being shifted right one position.  The
 rightmost bit is shifted out (lost).  This is done eight times giving
 you a random number in the lower part of the register (AL).
 
