        PAGE ,132
;----------------------------------------------------------
; FBINTODEC
;
; Copyright Bob Kline 1988
;
; Purpose:
;	convert binary float to decimal components
;
; Input:
;       DX:AX contains binary floating point value
;       in IEEE format
;
; Output:
;       DX:AX contains mantissa with decimal point
;       understood to be at end; good to 7-8 places
;       of precision; CX contains sign in low bit;
;       BX contains signed, unbiased decimal exponent
;
; Other registers changed:
;       DI, SI
;
; Example:
;       1.234567e6 (1,234,567) input in DX:AX as
;       32-bit value: bit 31 is sign, bits 30-23
;       are the 8-bit biased binary exponent, and
;       the lowest 23 bits are the mantissa, with
;       a 24th (high) bit understood to be set.
;
;       Output would be 1234567 in DX:AX, -4 in
;       BX, and 0 in CX.
;
; Other procedures called:
;       LDIV10 -- divide 32-bit unsigned integer by 10
;----------------------------------------------------------
        PUBLIC  FBINTODEC
        EXTRN   LDIV10:PROC

	.MODEL	SMALL

	.CODE

FBINTODEC PROC

; isolate the sign flag and save it
        MOV     CX,DX
        ROL     CX,1
        AND     CX,1
        PUSH    CX

; keep the exponent in SI for now, and remove bias
        MOV     SI,DX
        AND     SI,7FFFH
        MOV     CL,7
        SHR     SI,CL
        SUB     SI,127

; isolate the mantissa and restore the high bit
        AND     DX,7FH
        OR      DX,80H

; start out the decimal exponent with 0
        XOR     DI,DI

; if this is a big number slide the mantissa up
        CMP     SI,32
	JL	LOWEXP
        MOV     CX,8
SHFT1:  SHL     AX,1
        RCL     DX,1
        LOOP    SHFT1

; while the exponent is greater than 31 divide by 10
        JMP     SHORT TEST1
LOOP1:  CALL    LDIV10
        XOR     CX,CX   ; shift count

; keep shifting the mantissa left until high bit set
        JMP     SHORT TEST2
LOOP2:  SHL     AX,1
        RCL     DX,1
        INC     CX      ; shift count
TEST2:  TEST    DX,8000H
        JZ      LOOP2

; fold the remainder (BX) back into the mantissa,
;   reduce the binary exponent by the number of
;   shifts we made, and bump up the decimal exponent
        OR      AX,BX
        SUB     SI,CX
        INC     DI

; is the exponent > 31 ?
TEST1:	CMP	SI,31
	JG	LOOP1

; normalize the mantissa
        MOV     CX,31
        SUB     CX,SI
	JZ	DONE
SHFT2:	SHR	DX,1
	RCR	AX,1
        LOOP    SHFT2
        JMP     SHORT DONE

LOWEXP:
; multiply by 10 and shift while exponent
;   is less than 23
        JMP     SHORT TEST3
LOOP3:  MOV     CX,10
        PUSH    AX
        MOV     AX,DX
        MUL     CX
        MOV     BX,AX
        POP     AX
        MUL     CX
        ADD     DX,BX
        XOR     CX,CX   ; shift counter
        JMP     SHORT TEST4
LOOP4:  SHR     DX,1
        RCR     AX,1
        INC     CX      ; shift count
TEST4:  TEST    DX,0F000H
        JNZ     LOOP4

; adjust binary (SI) and decimal (DI) exponents
        ADD     SI,CX
        DEC     DI

TEST3:  CMP     SI,23
	JL	LOOP3

; normalize mantissa
        SUB     SI,23
	JZ	DONE
        MOV     CX,SI
SHFT3:  SHL     AX,1
        RCL     DX,1
        LOOP    SHFT3

DONE:
; move the exponent to BX and get the sign back
        MOV     BX,DI
        POP     CX
        RET

FBINTODEC ENDP

        END
