       PAGE ,132
;----------------------------------------------------------
; FCMP -- version for use with assembly language programs
;
; Copyright Bob Kline 1988
;
; Purpose:
;       Compare two floating-point values to see which is
;       larger.
;
; Input:
;       4-byte real in DX:AX and 4-byte real in CX:BX
;
; Output:
;       AX contains positive integer if first value is
;       greater, negative integer if first is smaller,
;       0 if values equal.
;
; Other registers affected:
;	DX, CX, BX, SI
;
; Other procedures called:
;       none
;----------------------------------------------------------
        PUBLIC  FCMP

	.MODEL	SMALL

	.CODE

FCMP        PROC

; see if the signs are different
        PUSH    DX
        PUSH    CX
        AND     DX,8000h
        AND     CX,8000h
        CMP     DX,CX
        POP     CX
        POP     DX
	JE	SAME_SIGN
        JG      SKIP1
        MOV     AX,-1
        RET
SKIP1:  MOV     AX,1
        RET

; if we're here, the signs must have been the same
;   save the sign and try the rest of the numbers
SAME_SIGN:
	MOV	SI,DX
	AND	SI,8000h
	PUSH	SI
	SUB	DX,CX
	JE	LOW_CHECK
	XCHG	DX,AX
	JMP	SHORT CHECK_SIGN
LOW_CHECK:
	SUB	AX,BX
CHECK_SIGN:
	POP	SI
	OR	SI,SI
	JZ	POSITIVE
	NEG	AX
POSITIVE:
        RET

FCMP        ENDP

        END
