	PAGE ,132
;----------------------------------------------------------
; FDECTOBIN
;
; Copyright Bob Kline 1988
;
; Purpose:
;	convert decimal components to 4-byte real
;
; Input:
;       DX:AX contains mantissa with decimal point
;       understood to be at end; good to 7-8 places
;       of precision; CX contains sign in low bit;
;       BX contains signed, unbiased decimal exponent
;
; Output:
;       DX:AX contains binary floating point value
;       in IEEE format
;
; Other registers affected:
;	BX, CX, DI, SI
;
; Other procedures called:
;       LDIV10 -- divide 32-bit unsigned integer by 10
;----------------------------------------------------------
        PUBLIC  FDECTOBIN
        EXTRN   LDIV10:PROC

	.MODEL	SMALL

BINARYEXPONENT	EQU	SI
DECIMALEXPONENT EQU	DI
REMAINDER	EQU	BX

	.CODE

FDECTOBIN PROC

; get the sign out of the way -- we won't need it until the end
	PUSH	CX

; take care of zero as a special case -- if the decimal mantissa
;   is 0 then DX:AX are all set -- don't forget to clean off the
;   stack
	OR	DX,DX
	JNZ	L1
	OR	AX,AX
	JNZ	L1
	POP	CX
	RET

; use SI to hold the binary exponent (which we'll start off unbiased --
;   the end result will have 23 digits after the 'binary' point) and
;   DI to hold the decimal exponent
L1:	MOV	BINARYEXPONENT,23
	MOV	DECIMALEXPONENT,BX
	XOR	BX,BX

; if the decimal exponent is negative, adjust it up to zero by a series
;   of divisions of the mantissa by 10
	OR	DECIMALEXPONENT,DECIMALEXPONENT
	JNS	L2

; since we are going to be dividing the mantissa by 10, shift it left
;   as far as it will go so we won't lose any precision in the process
	JMP	SHORT L3
L4:	SHL	AX,1
	RCL	DX,1
	DEC	BINARYEXPONENT
L3:	TEST	DX,8000h
	JZ	L4
	OR	AX,REMAINDER
	CALL	LDIV10
	INC	DECIMALEXPONENT
	JS	L3
	JZ	L5

; if the decimal exponent is greater than zero, adjust it back to zero
;   by successive multiplication of the mantissa by 10 -- keep the
;   mantissa shifted far enough to the right that the multiplications
;   don't lose any of the top bits
L6:	SHR	DX,1
	RCR	AX,1
	INC	BINARYEXPONENT
L7:	TEST	DX,0F000h
	JNZ	L6
	MOV	CX,10
	PUSH	AX
	XCHG	DX,AX
	MUL	CX
	MOV	BX,AX
	POP	AX
	MUL	CX
	ADD	DX,BX
	DEC	DECIMALEXPONENT
L2:	JNZ	L7

; if the mantissa occupies too many positions shift it to the right,
;   rounding up as necessary as we go
	JMP	SHORT L5
L8:	SHR	DX,1
	RCR	AX,1
	ADC	AX,0
	ADC	DX,0
	INC	BINARYEXPONENT
L5:	TEST	DX,0FF00h
	JNZ	L8

; if the mantissa is too far right, shift it to the left
	JMP	SHORT L9
L10:	SHL	AX,1
	RCL	DX,1
	DEC	BINARYEXPONENT
L9:	TEST	DX,80h
	JZ	L10

; make the top bit invisible -- it's assumed
	AND	DX,7Fh

; bias the exponent, shift it left, and fold it in, stirring
;   gently for 20 minutes
	ADD	BINARYEXPONENT,127
	MOV	CL,7
	SHL	BINARYEXPONENT,CL
	OR	DX,BINARYEXPONENT

; finally, get the sign into the top bit of DX
	POP	CX
	OR	CX,CX
	JZ	L11
	OR	DX,8000h
L11:	RET

FDECTOBIN ENDP

        END
