;			FLOAT.INC
;
;       Header file to be included in assembly-language code
;	which uses FLOAT.LIB.  This file provides declarations
;	for the external globals to which the assembler will
;	need access in order to use the routines from the
;	floating-point library.  This file can also be used
;	as a quick-reference sheet for the routines.
;
;       Copyright Bob Kline 1988

EXTRN	_errno:WORD
;       0 = no error
	EDOM	EQU	33	; invalid argument
	ERANGE	EQU	34	; overflow

EXTRN	ATOF:PROC
;	INPUT:		SI = pointer to string
;	OUTPUT: 	DX:AX = 4-byte real
;       ALSO CHANGED:   BX, CX, DI, SI, BP

EXTRN	ITOF:PROC
;	INPUT:		AX = 2-byte integer
;	OUTPUT: 	DX:AX = 4-byte real
;       ALSO CHANGED:   CX

EXTRN	F_ADD:PROC
;	INPUT:		DX:AX = 4-byte real
;			CX:BX = 4-byte real
;	OUTPUT: 	DX:AX = 4-byte real sum
;	ALSO CHANGED:	BX, CX, DI, SI, BP, possibly _errno

EXTRN	FABSVAL:PROC
;	INPUT:		DX:AX = 4-byte signed real
;	OUTPUT: 	DX:AX = 4-byte positive real
;       ALSO CHANGED:   No other registers

EXTRN	FBINTODEC:PROC
;	INPUT:		DX:AX = 4-byte real
;	OUTPUT: 	DX:AX = integer mantissa
;			CX = sign
;			BX = signed, unbiased decimal exponent
;       ALSO CHANGED:   DI, SI

EXTRN	FCMP:PROC
;	INPUT:		DX:AX = 4-byte real
;			CX:BX = 4-byte real
;	OUTPUT: 	AX = integer result
;	ALSO CHANGED:	BX, CX, DX, DI, SI, BP

EXTRN	FDECTOBIN:PROC
;	INPUT:		DX:AX = integer mantissa
;			CX = sign
;			BX = signed, unbiased decimal exponent
;	OUTPUT: 	DX:AX = 4-byte real
;	ALSO CHANGED:	BX, CX, DI, SI

EXTRN	FDIVIDE:PROC
;	INPUT:		DX:AX = 4-byte real dividend
;			CX:BX = 4-byte real divisor
;	OUTPUT: 	DX:AX = 4-byte real result
;	ALSO CHANGED:	BX, CX, DI, SI, BP, possibly _errno

EXTRN	FMULT:PROC
;	INPUT:		DX:AX = 4-byte real multiplicand
;			CX:BX = 4-byte real multiplier
;	OUTPUT: 	DX:AX = 4-byte product
;	ALSO CHANGED:	BX, CX, DI, SI, BP, possibly _errno

EXTRN	F_SUB:PROC
;	INPUT:		DX:AX = 4-byte real subtrahend
;			CX:BX = 4-byte real minuend
;	OUTPUT: 	DX:AX = 4-byte real difference
;	ALSO CHANGED:	BX, CX, DI, SI, BP, possibly _errno

EXTRN	FTOA:PROC
;	INPUT:		DX:AX = 4-byte real
;			SI = address for output string
;			CX = precision
;	CHANGED:	AX, BX, CX, DX, DI, SI, BP

EXTRN	FTOI:PROC
;	INPUT:		DX:AX = 4-byte real
;	OUTPUT: 	AX = 2-byte signed integer
;	ALSO CHANGED:	BX, CX, DX, possibly _errno

EXTRN	FTOE:PROC
;	INPUT:		DX:AX = 4-byte real
;			SI = address for output string
;			CX = precision
;	CHANGED:	AX, BX, CX, DX, DI, SI

EXTRN	FTOL:PROC
;	INPUT:		DX:AX = 4-byte real
;	OUTPUT: 	DX:AX = 4-byte signed long integer
;	ALSO CHANGED:	BX, CX, possibly _errno

EXTRN	LTOF:PROC
;	INPUT:		DX:AX = 4-byte signed long integer
;	OUTPUT: 	DX:AX = 4-byte real
;	ALSO CHANGED:	CX

