        PAGE ,132
;----------------------------------------------------------
; FTOI -- version for use with assembly language programs
;
; Copyright Bob Kline 1988
;
; Purpose:
;       Convert single-precision floating-point value
;	to two-byte integer.
;
; Input:
;       DX:AX contain 4-byte real to be converted
;
; Output:
;	2-byte integer returned in AX.
;
; Other registers affected:
;       BX, CX, DX
;
; Other procedures called:
;       none
;----------------------------------------------------------
        PUBLIC  FTOI
	EXTRN	_errno:WORD

ERANGE		EQU	34

	.MODEL	SMALL

	.CODE

FTOI    PROC

; isolate sign and save it on the stack
	MOV	CX,DX
	AND	CX,8000h
	PUSH	CX

; unpack exponent and remove bias
	MOV	BX,DX
	AND	BX,7F80h
	SHL	BX,1
        XCHG    BH,BL
	SUB	BX,127

; if exponent is negative, result is zero
	JNS	NON_ZERO
	XOR	AX,AX
	POP	CX
	RET

; if the exponent is greater than 14, the number
;   is too big for a 16-bit integer
NON_ZERO:
	CMP	BX,15
	JL	OK
	MOV	_errno,ERANGE
	POP	CX
	RET

; unpack mantissa & shift right (23 - exponent) places
OK:     AND     DX,7Fh
        OR      DX,80h
        MOV     CX,23
	SUB	CX,BX
AGAIN:	SHR	DX,1
	RCR	AX,1
	LOOP	AGAIN
	POP	CX
	OR	CX,CX
	JZ	POSITIVE
	NEG	AX
POSITIVE:
	RET

FTOI    ENDP

        END
