        PAGE ,132
;----------------------------------------------------------
; FTOL -- version for use with assembly language programs
;
; Copyright Bob Kline 1988
;
; Purpose:
;       Convert single-precision floating-point value
;	to four-byte long integer.
;
; Input:
;       DX:AX contain 4-byte real to be converted
;
; Output:
;	4-byte long integer returned in DX:AX.
;
; Other registers affected:
;       CX, BX
;
; Other procedures called:
;       none
;----------------------------------------------------------
        PUBLIC  FTOL
	EXTRN	_errno:WORD

ERANGE		EQU	34

	.MODEL	SMALL

	.CODE

FTOL    PROC

; isolate sign and save it on the stack
	MOV	CX,DX
	AND	CX,8000h
	PUSH	CX

; unpack exponent and remove bias
	MOV	BX,DX
	AND	BX,7F80h
	SHL	BX,1
        XCHG    BH,BL
	SUB	BX,127

; if exponent is negative, result is zero
	JNS	NON_ZERO
	XOR	AX,AX
	XOR	DX,DX
	POP	CX
	RET

; if the exponent is greater than 30, the number
;   is too big for a 32-bit long integer
NON_ZERO:
	CMP	BX,31
	JL	OK
	MOV	_errno,ERANGE
	POP	CX
	RET

; unpack mantissa
OK:     AND     DX,7Fh
        OR      DX,80h

; if exponent is 23, we're done except for the sign
        CMP     BX,23
	JE	GET_SIGN

; if the exponent is bigger than 23, we need to shift
;   left, otherwise, shift right
	JG	BIG
	MOV	CX,23
	SUB	CX,BX
LOOP1:	SHR	DX,1
	RCR	AX,1
	LOOP	LOOP1
	JMP	SHORT GET_SIGN

; large number -- shift mantissa to the left
BIG:	MOV	CX,BX
	SUB	CX,23
LOOP2:	SHL	AX,1
	RCL	DX,1
	LOOP	LOOP2

; get the sign back off the stack
GET_SIGN:
	POP	CX
	OR	CX,CX
	JZ	POSITIVE
        NEG     DX
        NEG     AX
        SBB     DX,0
POSITIVE:
	RET

FTOL   ENDP

        END
