        PAGE ,132
;----------------------------------------------------------
; ITOF -- version for use with assembly language programs
;
; Copyright Bob Kline 1988
;
; Purpose:
;       Convert two-byte integer to floating point value
;
; Input:
;       AX holds integer to be converted
;
; Output:
;       4-byte real stored in DX:AX
;
; Other registers used:
;       CX
;
; Other procedures called:
;       none
;----------------------------------------------------------
        PUBLIC  ITOF

	.MODEL	SMALL

	.CODE

ITOF    PROC

; prepare CX for sign and check for (integer == 0)
        XOR     CX,CX
        OR      AX,AX
        JNZ     SAVE_SIGN
        XOR     DX,DX
        RET

SAVE_SIGN:
        JNS     POSITIVE
        NEG     AX
        OR      CH,80h
POSITIVE:
        PUSH    CX

; use BX for mantissa, starting out with 23
        MOV     CX,23

; shift left until we get a one bit in the
;   23rd position from the right
        XOR     DX,DX
MORE:   SHL     AX,1
        RCL     DX,1
        DEC     CX
        TEST    DX,80h
        JZ      MORE
        AND     DX,7Fh

; bias the exponent and fold it in
        ADD     CX,127
        XCHG    CH,CL
        SHR     CX,1
        OR      DX,CX

; get the sign back off the stack fold it in, and we're done
	POP	CX
        OR      DX,CX

        RET

ITOF   ENDP

        END
