        PAGE ,132
;----------------------------------------------------------
; LTOF -- version for use in assembly language programs
;
; Copyright Bob Kline 1988
;
; Purpose:
;       Convert four-byte long integer to floating point value
;
; Input:
;       DX:AX hold long value to be converted
;
; Output:
;       4-byte real returned in DX:AX
;
; Other registers affected:
;       CX
;
; Other procedures called:
;       none
;----------------------------------------------------------
        PUBLIC  LTOF

	.MODEL	SMALL

	.CODE

LTOF    PROC

; prepare CX for sign and check for (integer == 0)
        OR      DX,DX
        JNZ     SAVE_SIGN
        OR      AX,AX
        JNZ     SAVE_SIGN
        RET

SAVE_SIGN:
        XOR     CX,CX
        OR      DX,DX
        JNS     POSITIVE
        NEG     DX
        NEG     AX
        SBB     DX,0
        OR      CH,80h
POSITIVE:
        PUSH    CX

; use CX for mantissa, starting out with 24
        MOV     CX,24

; if necessary, shift right until top 7 bits
;   are zero
        JMP     SHORT TEST1
LOOP1:  SHR     DX,1
        RCR     AX,1
        INC     CX
TEST1:  TEST    DX,0FE00h
        JNZ     LOOP1

; shift left until we get a one bit in the
;   24th position from the right
        JMP     SHORT TEST2
LOOP2:  SHL     AX,1
        RCL     DX,1
        DEC     CX
TEST2:  TEST    DX,100h
        JZ      LOOP2

; round and shift one to the right
        ADD     AX,1
        ADC     DX,0
        SHR     DX,1
        RCR     AX,1

; make top bit invisible
        AND     DX,7Fh

; bias the exponent and fold it in
        ADD     CX,127
        XCHG    CH,CL
        SHR     CX,1
        OR      DX,CX

; get the sign back off the stack & fold in,
;   and we're done
	POP	CX
        OR      DX,CX
        RET

LTOF   ENDP

        END
