;    movfiles.asm   10/9/84   gwf
;This routine is called from a basic program. (example below). It finds
; all files which match the given mask in the oldpath directory and moves
; them to the new path directory. The name is not changed.
;
;	 10 COLOR 7,1:CLS
;	 20 INPUT"OLD PATH (Include drive letter and :) ",OLDPATH$
;	 25 if len(oldpath$)>17 then print"Cannot be that long":goto 20
;	 30 INPUT"NEW PATH (Include drive letter and :) ",NEWPATH$
;	 35 if len(newpath$)>17 then print"Cannot be that long":goto 30
;	 40 INPUT"MASK ",MASK$
;	 45 mask$=mask$+chr$(0) 	    'IMPORTANT TO DO THIS
;	 50 PRINT"JUST BEFORE CALL ";TIME$
;	 60 CALL MOVFILES(OLDPATH$,NEWPATH$,MASK$)
;	 70 PRINT"JUST AFTER CALL  ";TIME$
;
find_first equ	4eh	;Find first match function call
find_next  equ	4fh	;Find next match function call
re_name equ	56h	;Rename a file function call
get_dta equ	2fh	;Get current disk transfer area function call
doscall equ	21h	;DOS interrupt number
;
dgroup	group	datarea
datarea segment para public 'DATA'
;
o_pa_len  dw	  ?		  ;length of old path string
o_path	  db	  20h dup('\')    ;   actual old path string it will end in '\'
o_off_set dw	  ?		  ;this is offset to end of old path
;
n_pa_len  dw	  ?		  ;length of new path string
n_path	  db	  20h dup('\')    ;   actual new path string it will end in '\'
n_off_set dw	  ?		  ;this is offset to end of new path file
;
datarea ends
;
cseg	  segment 'CODE'
	  assume  cs:cseg,ds:datarea
	  public  MOVFILES
MOVFILES  proc	  far
	push	bp		;save BP for basic
	mov	bp,sp		;set base for parm list
	push	ds		;save DS for basic
	push	es		;save ES for basic
	mov	ax,datarea	;local data space
	mov	ds,ax		;now DS is the local space
;
;
	mov	si,ss:[bp+10]	;get addr of old path string length
	mov	ax,es:[si]	;get len of old path string
	mov   o_pa_len,ax
	mov	ax,es:[si+2]	;get address of old path string
;
;   set up address of string from basic and local data area string
;
	mov	si,ax		;set address of string in si
	lea	di,o_path	;load address of local data area string
	mov	cx,o_pa_len	;set loop counter to length of string
	call	mov_it		;move string to local area
;
;Append the mask to the end of the old path. (for the find first call)
	mov	ax,offset o_path;we need to compute the address where the
	add	ax,o_pa_len	; the append will begin. Offset plus length
	add	ax,1		;    plus 1 for the '\'.
	mov	o_off_set,ax	; save for future reference
	mov	di,ax		;load address of local data area string
;
	mov	si,ss:[bp+6]	;get addr of mask string length
	mov	cx,es:[si]	;get len of mask string
	mov	ax,es:[si+2]	;get address of mask string
;
;   set up address of string from basic and local data area string
;
	mov	si,ax		;set address of string in si
	call	mov_it		;move string to local area
;

	mov	si,ss:[bp+8]	;get addr of new path string length
	mov	ax,es:[si]	;get len of new path string
	mov   n_pa_len,ax
	mov	ax,es:[si+2]	;get address of new path string
;
;   set up address of string from basic and local data area string
;
	mov	si,ax		;set address of string in si
	lea	di,n_path	;load address of local data area string
	mov	cx,n_pa_len	;set loop counter to length of string
	call	mov_it		;move string to local area
;
;
	mov	ax,offset n_path;we need to compute the address where the
	add	ax,n_pa_len	; the append will begin. Offset plus length
	add	ax,1		;    plus 1 for the '\'.
	mov	n_off_set,ax
;
;Now all parameters are local. It is time to have local ES.
;	mov	ax,datarea	;local data space
;	mov	es,ax		;now ES is the local space
;	assume	es:datarea
;
;AT THIS POINT IN THE PROGRAM WE ARE ALL SET TO DO THE GET FIRST FUNCTION CALL.
;We will find the first file name in the old directory which matches on the
;mask. We will move it to the new path w/o changing its name. We will then
;invoke the find next call until all are moved.
;
	mov	ah,find_first	;find first match function number
	mov	cx,16h		;set attribute byte to match any file
	mov  dx,offset o_path	;DS:DX points to the absolute file name
				;  which we want to match
	int	doscall 	;Call DOS


	mov	ah,get_dta	;get disk transf. area func. number
	int	doscall 	;Call DOS

;ES:BX points to current disk transfer area
	mov	si,bx		;location of the DTA
	add	si,30d		;location of the name found
;Move into old path.
	mov	di,o_off_set	;address of where name should start in old path
	mov	cx,13d		; 8part name, period, 3 place extension, and 0h
	call	mov_it		;    actually move it there

;Move into new path.
	mov	si,bx		;location of the DTA
	add	si,30d		;location of the name found
	mov	di,n_off_set	;address of where name should start in new path
	mov	cx,13d		; 8part name, period, 3 place extension, and 0h
	call	mov_it		;    actually move it there

;We will now rename this first found before we enter the find next loop

;DS:DX points to old name
	mov	dx,offset o_path;location of old name put in DX
;ES:DI points to new name
	push	es		;save es for later
	push	ds		;need es to be equal to ds
	pop	es		;   now it is
	mov   di,offset n_path	;location of new name put in DI

	mov	ah,re_name	;rename function number
	int	doscall 	;Call DOS
	pop	es		;restore es for the next DTA.

;The first matching file if the old path has been found and moved.
;Now we will take care of all others in the do_next_old loop.

do_next_old:
	mov	ah,find_next	;Find next function call
	int	doscall 	;Call DOS
	cmp	ax,12h		;18d is the no more files error code
	je	exit		;    leave if no more files

	mov	ah,get_dta	;get disk transf. area func. number
	int	doscall 	;Call DOS

;ES:BX points to current disk transfer area
	mov	si,bx		;location of the DTA
	add	si,30d		;location of the name found
;Move into old path.
	mov	di,o_off_set	;address of where name should start in old path
	mov	cx,13d		; 8part name, period, 3 place extension, and 0h
	call	mov_it		;    actually move it there

;Move into new path.
	mov	si,bx		;location of the DTA
	add	si,30d		;location of the name found
	mov	di,n_off_set	;address of where name should start in new path
	mov	cx,13d		; 8part name, period, 3 place extension, and 0h
	call	mov_it		;    actually move it there

;We will now rename this file before we jump back to the find next loop

;DS:DX points to old name
	mov	dx,offset o_path;location of old name put in DX
;ES:DI points to new name
	push	es		;save es for later
	push	ds		;need es to be equal to ds
	pop	es		;   now it is
	mov   di,offset n_path	;location of new name put in DI

	mov	ah,re_name	;rename function number
	int	doscall 	;Call DOS
	pop	es		;restore es for the next DTA.
	jmp	do_next_old	;Go back to do the next one.

exit:	pop	es		;    for basic
	pop	ds		;    for basic
	pop	bp		;    for basic
	ret	6		;return to basic 3 parameters were sent
;
MOVFILES  endp
;

;---------------------------------------------------------------------
mov_it	proc	near
;
;   move string from basic data area to local data area
;
mov_st: mov	al,es:[si]	;move character from basic to al
	mov	ds:[di],al	;move character to local data area
	inc	si		; increment
	inc	di		;   pointers
	loop	mov_st		; if cx<>0 then do next
;
	ret
mov_it	endp
;---------------------------------------------------------------------
;-----------------------------------------------------------------------
cseg	ends
	end			;end of assembly
