.model small

.data
extrn	video_seg:word
extrn	insert_mode:byte

.code
extrn	mcga:near
public	insert
;--------------------------------------------------;
;   This toggles the insert/overstrike modes       ;
;--------------------------------------------------;
insert	proc	near
	push	di
	mov	di,-1
overstrike_mode:
	push	cx		; save CX
	push	es
	mov	cx,0507h	; default color, overstrike cursor
	cmp	byte ptr cs:mcga,90h
	jne	i01
	mov	cx,0607h	; MCGA
i01:	cmp	word ptr video_seg,0B000h
				; monochrome video mode?
	mov	ax,40h
	mov	es,ax		; ES points to BIOS data area
	mov	al,es:[17h]	; get keyboard status
	mov	ah,es:[84h]	; get (rows on screen - 1)
	jne	not_mono
	cmp	ah,29		; rows on screen
	jge	not_mono
	mov	cx,0C0Dh	; first scan line = 12, last = 13
	mov	ah,42		; fake a 43-row mode for direct programming
not_mono:
	and	al,10000000b	; isolate insert toggle
	mov	insert_mode,al
	jz	not_insert
	or	di,di
	jz	not_insert
	shr	ch,1		; first scan line
not_insert:
	cmp	ah,42		; is this 43-row EGA mode?
	jae	direct_cursor	; if so, need to program cursor directly
	cmp	ch,2
	jne	bc01
	inc	ch
bc01:	mov	ah,1		; set cursor size int 10h function
	push	bp
	int	10h
	pop	bp
	jmp	short size99

direct_cursor:
	mov	dx,es:[63h]
	mov	al,0Ah
	mov	ah,ch		; AH = first scan line
	cmp	byte ptr cs:mcga,90h
	jne	dc01
	shr	ah,1
dc01:	out	dx,ax
	inc	al
	mov	ah,cl		; AH = last scan line
	cmp	byte ptr cs:mcga,90h
	jne	dc02
	shr	ah,1
dc02:	out	dx,ax

size99:	pop	es
	pop	cx		; restore CX
	pop	di
	ret
insert	endp
	end
