; MARK.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

include	model.inc

public	mark, cut, copy, paste, pastesiz
extrn	rowcount:near
extrn	locate:near, working:near
extrn	sub_push:near
extrn	error:near
extrn	working:near
extrn	display_bottom:near
extrn	open_space:near
extrn	memcopy:near

include	dataseg.inc
extrn	count_start:dword, file_row:dword
extrn	mark_mode:byte, mark_home:dword, mark_start:dword
extrn	mark_end:dword, cursor:dword
extrn	dirty_bits:byte, filesiz:dword, push_mode:byte
extrn	cur_posn:word

pasteptr	dd 0
pastesiz	dd 0

cut_proc	dd alloc_paste

@curseg	ends

include	codeseg.inc
;
; toggle the mark state and resets the paste buffer pointers
;
mark	proc	near
	xor	eax,eax
	not	mark_mode	; toggle the mode flag
	cmp	mark_mode,al	; turning mode on?
	jne	short mark_on
	or	dirty_bits,1	; need to redraw the screen
	mov	mark_end,eax
	dec	eax		; 0FFFFFFFFh
	mov	mark_start,eax
	jmp	short mark_ret
mark_on:
	mov	eax,cursor	; get the cursor offset
	mov	mark_start,eax	; start of marked range
mark_ret:
	mov	mark_end,eax	; end of marked range
	mov	mark_home,eax	; center of marked range
	clc
	ret
mark	endp

;
; remove marked text; copy to paste buffer
;
cut	proc	near
	cmp	mark_mode,0	; is the mark mode on?
	je	no_mark		; if not, then do nothing
	call	copy_marked	; sets up cut_proc
	jc	short no_mark	; exit if too big
	call	sub_push	; adjust push_offset if nessesary

	mov	esi,mark_end	; source
	mov	edi,mark_start	; target
	xor	ecx,ecx
	mov	[count_start],ecx
	mov	eax,edi		; mark_start
	mov	[count_start+4],eax

	inc	ecx
	mov	[file_row],ecx
	mov	ecx,[filesiz]
	sub	ecx,esi		; ESI = mark_end
				; ECX = bytes to move down

; update file buffer
	mov	eax,pastesiz
	sub	filesiz,eax	; EAX = block size
	call	working
	push	ds
	push	es
	mov	ax,fs
	mov	es,ax
	mov	ds,ax
	call	memcopy
	pop	es
	pop	ds

; move cursor to mark_start
	mov	esi,mark_start
	mov	cursor,esi
	mov	dx,cur_posn
	call	locate		; adjust the screen position

cut_exit:
	call	mark		; this turns off select
sizof_call	equ	$-cut_exit
	or	dirty_bits,10000001b
	call	rowcount+sizof_call
no_mark:clc
	ret
cut	endp

copy	proc	near
	cmp	mark_mode,0	; is the mark mode on?
	je	short no_copy	; if not, then do nothing
	call	copy_marked
	jc	short no_copy
	call	mark		; turn mark mode off
	
no_copy:
	clc
	ret
copy	endp

paste	proc	near
	mov	ecx,pastesiz	; number of characters in buffer
	jecxz	no_paste	; if zero, nothing to paste

	push	es
	mov	eax,ecx
	call	open_space
	mov	ecx,pastesiz
	mov	edi,cursor	; ES:[EDI] -> space in file buffer
	mov	esi,pasteptr
	call	memcopy
	pop	es
	call	display_bottom	; update screen from cursor to screen bottom

no_paste:
	clc
	ret

paste	endp

;
; used locally by CUT and COPY
;
copy_marked:

	push	ds
	push	es
	jmp	cut_proc
copy0:
	mov	ecx,mark_end	; get end of mark region
	sub	ecx,mark_start

	push	ecx
	mov	esi,pasteptr
	mov	ebx,ecx		; bytes wanted
	sys	ResMemNear	; resize buffer
	pop	ecx
	jc	short copy_exit
	mov	pasteptr,esi
	mov	eax,ecx

	push	ds
	pop	es
	mov	edi,pasteptr	; ES:[EDI] -> paste buffer
	mov	esi,mark_start
	mov	pastesiz,ecx	; save block size
	push	fs
	pop	ds		; DS:[ESI] -> marked block
	call	memcopy

copy_exit:
	pop	es
	pop	ds
	ret

alloc_paste:
	mov	cut_proc,offset @curseg:copy0
	mov	ebx,1024	; initial block size
	sys	GetMemNear
	mov	pasteptr,esi
	jmp	copy0

@curseg	ends
	end
