; SCRNDATA.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

include	model.inc

public	get_screen_data
extrn	crtinfo:near
extrn	getcrt:near
extrn	swap_files:near
extrn	mouse_init:near

include	dataseg.inc

extrn	columns:byte, normal:byte, dirty_bits:byte
extrn	inverse:byte, warning:byte, window_row:byte
extrn	rows:word, saved_pos:word, screen_addr:dword
extrn	default_normal:byte

@curseg	ends

include	codeseg.inc
get_screen_data	proc	near
	lea	edi,normal
	lea	esi,default_normal
	push	ds
	pop	es
	mov	ecx,3
	rep	movsb			; assume color screen for now

	xor	ah,ah
	call	crtinfo
	mov	screen_addr,ebx
	dec	eax
	dec	eax			; allow space for fkey prompts
	mov	byte ptr columns,ch
	cmp	ch,60			; allow one more space if 40 columns
	sbb	eax,0
	mov	rows,ax
	or	dirty_bits,00100001b	; flag for screen update

; check for monochrome screen
	push	eax			; save rows in AL
	call	getcrt
	cmp	ax,0FFFFh		; CGA?
	je	short screen_data1	;  yup, keep color attribute
	cmp	ax,0			; MDA?
	je	short screen_data0	;  yup, use monochrome attribute
	cmp	ax,208			; InColor?
	je	short screen_data1	;  yup, keep color
	cmp	ax,128			; Hercules?
	jb	short screen_data1	;  no, must be color
screen_data0:
	mov	normal,07h
screen_data1:
	pop	eax			; AL = rows
	mov	saved_pos,-1
	call	mouse_init
	cmp	window_row,1
	je	short screen_data_exit
	mov	ax,rows
	inc	al
	shr	al,1
	mov	window_row,al
	call	screen_data2
screen_data2:
	mov	bx,1
	call	swap_files
screen_data_exit:
	ret

get_screen_data	endp

@curseg	ends
	end
