        page    60,132
        title   A Console Device Driver

;****************************************************************
;*    This is a Console Device Driver                           *
;****************************************************************

;****************************************************************
;*      INSTRUCTING THE ASSEMBLER                               *
;****************************************************************

     cseg      segment   para public    'code'
     console   proc      far
               assume    cs:cseg, es:cseg, ds:cseg

;structures

rh              struc   ;fixed request header structure
rh_len          db      ?     ;len of packet
rh_unit         db      ?     ;unit code (block devices only)
rh_cmd          db      ?     ;device driver command
rh_status       dw      ?     ;returned by the device driver
rh_res1         dd      ?     ;reserved
rh_res2         dd      ?     ;reserved
rh              ends          ;

rh0             struc   ;request header for Initialization (command 0)
rh0_rh          db      size rh dup (?) ;fixed request header portion
rh0_nunits      db      ?     ;number of units (block devices only)
rh0_brk_ofs     dw      ?     ;offset address for break
rh0_brk_seg     dw      ?     ;segment address for break
rh0_bpb_tbo     dw      ?     ;offset address of pointer to BPB array
rh0_bpb_tbs     dw      ?     ;segment address of pointer to BPB array
rh0_drv_ltr     db      ?     ;first available drive (DOS 3+) (block only)
rh0             ends          ;

rh4             struc   ;request header for INPUT         (command 4)
rh4_rh          db      size rh dup(?)  ;fixed request header portion
rh4_media       db      ?     ;media descriptor from DPB
rh4_buf_ofs     dw      ?     ;offset address of data transfer area
rh4_buf_seg     dw      ?     ;segment address of data transfer area
rh4_count       dw      ?     ;transfer count (sectors for block)
                              ;(bytes for character)
rh4_start       dw      ?     ;start sector number (block only)
rh4             ends          ;

rh5             struc   ;request header for ND_INPUT (command 5)
rh5_rh          db      size rh dup (?) ;fixed request header portion
rh5_return      db      ?     ;character returned
rh5             ends          ;

rh7             struc   ;request header Input_Flush (command 7)
rh7_len         db      ?     ;len of packet
rh7_unit        db      ?     ;unit code (block devices only)
rh7_cmd         db      ?     ;device driver command
rh7_status      dw      ?     ;returned by the device driver
rh7_res1        dd      ?     ;reserved
rh7_res2        dd      ?     ;reserved
rh7             ends          ;

rh8             struc   ;request header for OUTPUT        (command 8)
rh8_rh          db      size rh dup(?)  ;fixed request header portion
rh8_media       db      ?     ;media descriptor from DPB
rh8_buf_ofs     dw      ?     ;offset address of data transfer area
rh8_buf_seg     dw      ?     ;segment address of data transfer area
rh8_count       dw      ?     ;transfer count (sectors for block)
                              ;(bytes for character)
rh8_start       dw      ?     ;start sector number (block only)
rh8             ends          ;

rh9             struc   ;request header for OUTPUT_VERIFY (command 9)
rh9_rh          db      size rh dup(?)  ;fixed request header portion
rh9_media       db      ?     ;media descriptor from DPB
rh9_buf_ofs     dw      ?     ;offset address of data transfer area
rh9_buf_seg     dw      ?     ;segment address of data transfer area
rh9_count       dw      ?     ;transfer count (sectors for block)
                              ;(bytes for character)
rh9_start       dw      ?     ;start sector number (block only)
rh9             ends          ;

;****************************************************************
;*      MAIN PROCEDURE CODE                                     *
;****************************************************************

     begin:

;****************************************************************
;*      DEVICE HEADER REQUIRED BY DOS                           *
;****************************************************************

next_dev       dd   -1             ;no other drivers following
attribute      dw   8003h          ;character,output,input
strategy       dw   dev_strategy   ;Strategy routine address
interrupt      dw   dev_interrupt  ;Interrupt routine address
dev_name       db   'CON     '     ;name of our Console driver

;****************************************************************
;*      WORK SPACE FOR OUR DEVICE DRIVER                        *
;****************************************************************

rh_ofs	dw   ?    ;offset address of the request header
rh_seg	dw   ?    ;segment address of the request header

sav	db   0    ;character saved from the keyboard

;****************************************************************
;*      THE STRATEGY PROCEDURE                                  *
;****************************************************************

dev_strategy:  mov  cs:rh_seg,es   ;save the segment address
               mov  cs:rh_ofs,bx   ;save the offset address
               ret                 ;return to DOS

;****************************************************************
;*      THE INTERRUPT PROCEDURE                                 *
;****************************************************************

;device interrupt handler - 2nd call from DOS

dev_interrupt:

        cld                     ;save machine state on entry
        push    ds
        push    es
        push    ax
        push    bx
        push    cx
        push    dx
        push    di
        push    si

        mov     ax,cs:rh_seg    ;restore ES as saved by STRATEGY call
        mov     es,ax           ;
        mov     bx,cs:rh_ofs    ;restore BX as saved by STRATEGY call

;jump to appropriate routine to process command

        mov     al,es:[bx].rh_cmd       ;get request header header command
        rol     al,1                    ;times 2 for index into word table
        lea     di,cmdtab               ;function (command) table address
        mov     ah,0                    ;clear hi order
        add     di,ax                   ;add the index to start of table
        jmp     word ptr[di]            ;jump indirect

;CMDTAB is the command table that contains the word address
;for each command. The request header will contain the
;command desired. The INTERRUPT routine will jump through an
;address corresponding to the requested command to get to
;the appropriate command processing routine.

CMDTAB  label   byte            ;* = char devices only
        dw      INITIALIZATION  ; initialization
        dw      MEDIA_CHECK     ; media check (block only)
        dw      GET_BPB         ; build bpb
        dw      IOCTL_INPUT     ; ioctl in
        dw      INPUT           ; input (read)
        dw      ND_INPUT        ;*non destructive input no wait
        dw      INPUT_STATUS    ;*input status
        dw      INPUT_FLUSH     ;*input flush
        dw      OUTPUT          ; output (write)
        dw      OUTPUT_VERIFY   ; output (write) with verify
        dw      OUTPUT_STATUS   ;*output status
        dw      OUTPUT_FLUSH    ;*output flush
        dw      IOCTL_OUT       ; ioctl output
        dw      OPEN            ; device open
        dw      CLOSE           ; device close
        dw      REMOVEABLE      ; removeable media
        dw      OUTPUT_BUSY     ; output til busy

;****************************************************************
;*      YOUR LOCAL PROCEDURES                                   *
;****************************************************************

TONE    proc    near            ;tone
        mov     ah,0            ;clear ah
        push    ax              ;save ax
        mov     al,0b6h         ;timer chip control word
        out     43h,al          ;send to timer
        mov     dx,0            ;clear dividend (hi)
        mov     ax,14000        ;frequency
        pop     cx              ;restore key value as divisor
        inc     cx              ;add 1 to prevent div by 0
        div     cx              ;quotient is ax
        out     42h,al          ;output lo order byte
        xchg    ah,al           ;reverse
        out     42h,al          ;output hi order byte
        in      al,61h          ;get speaker/timer value
        or      al,3            ;turn on timer & speaker
        out     61h,al          ;set timer chip
        mov     cx,15000        ;value for 50 milliseconds
tone1:	loop    tone1		;loop
        in      al,61h          ;get timer chip value
        and     al,0fch         ;turn off speaker & timer
        out     61h,al          ;set timer chip
        ret                     ;return to caller
Tone    endp                    ;end of tone

;****************************************************************
;*      DOS COMMAND PROCESSING                                  *
;****************************************************************

;command 0      Initialization
Initialization:

        call    initial                 ;display message
        lea     ax,initial              ;set Break Addr. at initial
        mov     es:[bx].rh0_brk_ofs,ax  ;store offset address
        mov     es:[bx].rh0_brk_seg,cs  ;store segment address
        jmp     done                    ;set done status and exit

;command 1      Media_Check
Media_Check:

        jmp     done               ;set done bit and exit

;command 2      Get_BPB
Get_BPB:

        jmp     done               ;set done bit and exit

;command 3      IOCTL_Input
IOCTL_Input:

	jmp	unknown			;set error bit/code and exit

;command 4	Input		
Input:

	mov	cx,es:[bx].rh4_count	;load input count 
	mov	di,es:[bx].rh4_buf_ofs	;load offset address
	mov	ax,es:[bx].rh4_buf_seg	;load segment address 
	mov	es,ax			; move to es
read1:	mov	ax,0			;clear ax
	xchg	al,sav			;pick up saved character
	cmp	al,0			;is it 0?
	jne	read3			;no - we return it
read2:	mov	ah,0			;service = read
	int	16h			;Keyboard BIOS call
	cmp	ax,0			;is key = 0?
	je	read2			;yes - go get another
	cmp	al,0			;is it an extended key?
	jne	read3			;no - we return it
	mov	sav,ah			;save scan code
read3:	mov	es:[di],al		;store key value in buffer
	inc	di			;point to next buffer loc
	push	cx			;save cx
	call	tone			;sound a tone
	pop	cx			;restore for loop control
	loop	read1			;continue til count = 0
	mov	ax,cs:rh_seg		;restore es
	mov	es,ax			; from rh_seg
	mov	bx,cs:rh_ofs		;restore bx
	jmp	done			;set done bit and exit

;command 5	ND_Input
ND_Input:

	mov	al,sav			;pickup saved character
	cmp	al,0			;is it 0?
	jne	nd1			;no - return it to DOS
	mov	ah,1			;service = status check
	int	16h			;Keyboard BIOS call
	jz	busy			;ZF=1 means no key in buffer
	cmp	ax,0			;is key = 0?
	jne	nd1			;no - return it to DOS
	mov	ah,0			;service = read
	int	16h			;Keyboard BIOS call
	jmp	ND_Input		;check again
nd1:	mov	es:[bx].rh5_return,al	;return key to DOS
	jmp	done			;set done bit and exit

;command 6	Input_Status
Input_Status:

	jmp	done			;set done bit and exit

;command 7	Input_Flush
Input_Flush:

	mov	sav,0			;clear saved key
IF1:	mov	ah,1			;service = check status
	int	16h			;Keyboard BIOS calla
	jz	done			;ZF=1 means buffer empty
	mov	ah,0			;service = read
	int	16h			;Keyboard BIOS call
	jmp	IF1			;loop until buffer empty

;command 8	Output
Output:

	mov	cx,es:[bx].rh8_count	;load output count
	mov	di,es:[bx].rh8_buf_ofs	;load offset address
	mov	ax,es:[bx].rh8_buf_seg	;load segment address
	mov	es,ax			; into es
	mov	bx,0			;clear bx
out1:	mov	al,es:[di]		;pick up character to output
	inc	di			;point to next location
	mov	ah,0eh			;service = write char as tty
	int	10h			;Video BIOS call
	loop	out1			;loop til count = 0
	mov	ax,cs:rh_seg		;restore request header
	mov	es,ax			; segment adress as es
	mov	bx,cs:rh_ofs		;restore bx
	jmp	done			;set done bit and exit

;command 9	Output_Verify   
Output_Verify:

	jmp	output			;same as output

;command 10	Output_Status   
Output_Status:

	jmp	done			;set done bit and exit

;command 11      Output_Flush    
Output_Flush:

	jmp	done			;set done bit and exit

;command 12      IOCTL_Out       
IOCTL_Out:

	jmp	unknown			;set error bit/code and exit

;command 13      Open            
Open:

	jmp	done			;set done bit and exit

;command 14      Close           
Close:

	jmp	done			;set done bit and exit

;command 15      Removeable      
Removeable:

	jmp	unknown			;set error bit/code and exit

;command 16      Output Til Busy
Output_Busy:

	jmp	unknown			;set error bit/code and exit

;****************************************************************
;*      ERROR EXIT                                              *
;****************************************************************

unknown:	
	or	es:[bx].rh_status,8003h	;set error bit and error code
	jmp	done			;set done and exit

;****************************************************************
;*      COMMON EXIT                                             *
;****************************************************************
busy:	or	es:[bx].rh_status,0200h	;set busy bit

done:	or	es:[bx].rh_status,0100h	;set done

	pop	si			;restore all registers
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	es
	pop	ds
	ret				;return to DOS

;****************************************************************
;*      END OF PROGRAM                                          *
;****************************************************************

;this procedure is called form the Initialization command and
;is executed only once. WE can tell DOS that the next available
;memory location (Break Adress) is here. This allows DOS to over
;write this code; we save space.

initial	proc	near	;display message on console
	lea	dx,msg1	;message to be displayed
	mov	ah,9	;display
	int	21h	;DOS call
	ret		;return to caller
initial	endp

msg1	db   'The Waite Group Console Driver',0dh,0ah,'$'

console	endp		;end of console procedure
cseg	ends		;end of cseg segment
	end	begin	;end of program
