dump	proc		;dumps device driver information
			;to lpt1 via int 17h BIOS routine

;requires:
;		nothing (user must preserve required registers)
;uses:
;
;returns:
;		nothing


;get command descriptor

	mov	ax,cs:rh_seg	;get the ES register
	mov	es,ax		;
	mov	bx,cs:rh_ofs	;get the BX register
	mov	al,es:[BX]+2	;get command code
	mov	ah,0		;clear high-order of AX
	rol	al,1		;left shift 1 to multiply by 2
	lea	di,cmtab	;get address of command msg table
	add	di,ax		;index to address of command msg 
	mov	ax,[di]		;get address
 	call	prtmsg		;print command message

;display the request header

	mov	dl,es:[bx]	;LEN of request header
	mov	dh,0		;clear high-order DX
	lea	di,cs:crh1	;address of display message
	call	hex2asc		;convert to ASCII
	mov	dl,es:[bx]+1	;UNIT of request header
	mov	dh,0		;clear high-order DX
	lea	di,cs:crh2	;address of display message
	call	hex2asc		;convert to ASCII
	mov	dl,es:[bx]+2	;CMD of request header
	mov	dh,0		;clear high-order DX
	lea	di,cs:crh3	;address of display message
	call	hex2asc		;convert to ASCII
	mov	dx,es:word ptr [bx]+3	;STATUS of request header
	lea	di,cs:crh4	;address of display message
	call	hex2asc		;convert to ASCII
	lea	ax,cs:crh	;print the request header
	call	prtmsg		;

;display request header unique to each command

	mov	al,es:[BX]+2	;get command code
d0:	cmp	al,0		;initialization?
	jne	d1		;no
    
d1:	cmp	al,1		;media_check?
	jne	d2		;no
	mov	dl,es:[bx]+14	;media status
	mov	dh,0		;clear hi-order DX 
	lea	di,cs:cp1a		;
	call	hex2asc		;
	lea	ax,cs:cp1	;
	call	prtmsg		;
	jmp	dexit		;
d2:	cmp	al,2		;get_bpb?
	jne	d3		;no
d3:	cmp	al,3		;ioctl_input?
	jne	d4		;no
d4:	cmp	al,4		;input?
	jne	d5		;no
	mov	dx,es:word ptr [bx]+18	;count
	lea	di,cs:cp4a	;
	call	hex2asc		;
	mov	dx,es:word ptr [bx]+20	;start sector
	lea	di,cs:cp4b	;
	call	hex2asc		;
	lea	ax,cs:cp4	;
	call	prtmsg		;
	jmp	dexit		;
d5:	cmp	al,5		;nd_input?
	jne	d6		;no
d6:	cmp	al,6		;input_status?
	jne	d7		;no
d7:	cmp	al,7		;input_flush?
	jne	d8		;no
d8:	cmp	al,8		;output?
	jne	d9		;no
	mov	dx,es:word ptr [bx]+18	;count
	lea	di,cs:cp4a	;
	call	hex2asc		;
	mov	dx,es:word ptr [bx]+20	;start sector
	lea	di,cs:cp4b	;
	call	hex2asc		;
	lea	ax,cs:cp4	;
	call	prtmsg		;
	jmp	dexit		;
d9:	cmp	al,9		;output_verify?
	jne	da		;no
	mov	dx,es:word ptr [bx]+18	;count
	lea	di,cs:cp4a		;
	call	hex2asc		;
	mov	dx,es:word ptr [bx]+20	;start sector
	lea	di,cs:cp4b	;
	call	hex2asc		;
	lea	ax,cs:cp4	;
	call	prtmsg		;
	jmp	dexit		;
da:	cmp	al,0ah		;output_status?
	jne	dbb		;no
dbb:	cmp	al,0bh		;output_flush?
	jne	dc		;no
dc:	cmp	al,0ch		;ioctl_out?
	jne	ddd		;no
ddd:	cmp	al,0dh		;open?
	jne	de		;no
de:	cmp	al,0eh		;close?
	jne	df		;no
df:	cmp	al,0fh		;removeable?
	jne	d10		;no
d10:	cmp	al,10h		;output_busy?
	jne	dexit		;no

dexit:	ret
dump	endp

crh	db	' len '
crh1	db	'0000',0dh,0ah
	db	' unit '
crh2	db	'0000',0dh,0ah
	db	' cmd '
crh3	db	'0000',0dh,0ah
	db	' status '
crh4	db	'0000',0dh,0ah,'$'

cp1	db	' media status '	;command 1
cp1a 	db	'0000',0dh,0ah,'$'

cp4	db	' count '		;commands 4,8,9
cp4a 	db	'0000',0dh,0ah
	db	' start '
cp4b	db	'0000',0dh,0ah,'$'

cm0	db	'initialization',0dh,0ah,'$'
cm1	db	'media_check   ',0dh,0ah,'$'
cm2	db	'get_bpb       ',0dh,0ah,'$'
cm3	db	'ioctl_in      ',0dh,0ah,'$'
cm4	db	'input         ',0dh,0ah,'$'
cm5	db	'nd_input      ',0dh,0ah,'$'
cm6	db	'input_status  ',0dh,0ah,'$'
cm7	db	'input_flush   ',0dh,0ah,'$'
cm8	db	'output        ',0dh,0ah,'$'
cm9	db	'output_verify ',0dh,0ah,'$'
cma	db	'output_status ',0dh,0ah,'$'
cmb	db	'output_flush  ',0dh,0ah,'$'
cmc	db	'ioctl_out     ',0dh,0ah,'$'
cmd	db	'device_open   ',0dh,0ah,'$'
cme	db	'device_close  ',0dh,0ah,'$'
cmf	db	'removeable    ',0dh,0ah,'$'
cm10	db	'output_busy   ',0dh,0ah,'$'
cm11	db	'command_17    ',0dh,0ah,'$'
cm12	db	'command_18    ',0dh,0ah,'$'
cm13	db	'generic_ioctl ',0dh,0ah,'$'
cm14	db	'command_20    ',0dh,0ah,'$'
cm15	db	'command_21    ',0dh,0ah,'$'
cm16	db	'command_22    ',0dh,0ah,'$'
cm17	db	'get_device    ',0dh,0ah,'$'
cm18	db	'set_device    ',0dh,0ah,'$'

cmtab	label	word
	dw	cm0
	dw	cm1
	dw	cm2
	dw	cm3
	dw	cm4
	dw	cm5
	dw	cm6
	dw	cm7
	dw	cm8
	dw	cm9
	dw	cma
	dw	cmb
	dw	cmc
	dw	cmd
	dw	cme
	dw	cmf
	dw	cm10

hex2asc	proc

;requires:
;		dx = binary number 
;		di = address of ASCII string
;uses:
;		ax - for character conversion
;		cx - loop control
;returns:
;		nothing

	push	cx	;save cx
	push	ax	;save ax
	mov	cx,4	;number of hex digits
h1:	push	cx	;save cx inside this loop
	mov	cl,4	;shift count (bits/hex digit)
	rol	dx,cl	;rotate left 1 hex digit
	mov	al,dl	;move hex digit to al
	and	al,0fh	;mask off desired hex digit
	cmp	al,0ah	;is it above 9h?
	jge	h2	;yes
	add	al,30h	;numeric hex digit
	jmp	h3	;skip
h2:	add	al,37h	;alpha hex digit
h3:	mov	cs:[di],al	;store hex digit in string
	inc	di	;next string address
	pop	cx	;get saved loop count
	loop	h1	;loop start
	pop	ax	;restore ax
	pop	cx	;restore cx
	ret		;return to caller	
hex2asc	endp

prtmsg	proc

;requires:
;		ax = address of string to be printed
;uses:
;		dx - printer number (0 = lpt1:)
;		si - source string address
;returns:
;		nothing

	push	dx		;save dx
	push	si		;save si
	mov	dx,0		;printer 0
	mov	si,ax		;use si as pointer
prt1:	mov	ah,0		;print a character
	mov	al,[si]		;get a character
	cmp	al,'$'		;end of string?
	je	prt2		;yes - exit
	int	17h		;print BIOS call
	inc	si		;next 
	jmp	prt1		;loop back
prt2:	pop	si		;restore si
	pop	dx		;restore dx
	ret			;return to caller
prtmsg	endp

